/*
 * @(#)RealtimeListMaker.java            2004. 12. 23.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.actor;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsTypes;
import pluto.log.Composer;
import pluto.mail.MailSendingInstanceFactory;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.parser.SpoolHashParser;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class RealtimeListMaker extends BasicListMaker {

	

	/**
	 * 오늘날짜의 스케쥴을 가져오는 쿼리
	 */
	public static String			QUERY_SELECT_REALTIME_LAST_SCHEDULE			= null;

	/**
	 * 인서트할 정보들을 모아오는 쿼리들
	 */
	public static List				QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO	= null;

	/**
	 * 실제 스케쥴을 생성하는쿼리
	 */
	public static String			QUERY_INSERT_REALTIME_SCHEDULE				= null;
	
	public static String			QUERY_UPDATE_QUERY_STATUS_REALTIME			= null;

	public static String			QUERY_SELECT_BASE_SCHEDULE_INFO				= null;
	
	public static String 			QUERY_UPDATE_REALTIME_CONTENT_CREATE        = null;
	
	static {
		try {
			QUERY_SELECT_REALTIME_LAST_SCHEDULE = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_LAST_SCHEDULE");

			QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO");

			QUERY_INSERT_REALTIME_SCHEDULE = SqlManager.getQuery("COMMON", "QUERY_INSERT_REALTIME_SCHEDULE");
			
			QUERY_UPDATE_QUERY_STATUS_REALTIME = SqlManager.getQuery("COMMON", "QUERY_UPDATE_QUERY_STATUS_REALTIME");
			
			QUERY_SELECT_BASE_SCHEDULE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_BASE_SCHEDULE_INFO");
			
			QUERY_UPDATE_REALTIME_CONTENT_CREATE = SqlManager.getQuery("COMMON", "QUERY_UPDATE_REALTIME_CONTENT_CREATE");
		}
		catch(Exception e) {
			log.error("query init error", e);
			System.exit(1);
		}
	}

	/**
	 * 리스트 메이커 클래스 이름
	 */
	protected static String			CONTENT_MAKER_CLASS_NAME					= null;

	Object lock = new Object();
	
	public static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;

		CONTENT_MAKER_CLASS_NAME = prop.getProperty("make.class"); //mercury.contents.auto.producer.RealtimeContentPD
	}

	/** Creates a new instance of RealtimeListMaker */
	public RealtimeListMaker() throws Exception {
		super();
	}

	protected void inner_init(Properties prop) throws Exception {
		this.SCHEDULE_INFO = prop;

		// 로그 조립 인스턴스 초기화
		this.composer = Composer.getComposerInstance();

		// 스풀 헤쉬파서 초기화
		this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");

		this.POST_ID = this.SCHEDULE_INFO.getProperty("MSG_TYPE") + "_" + this.SCHEDULE_INFO.getProperty("MSG_TYPE_SEQ");

		// 음력을 입력해 준다.
		this.SCHEDULE_INFO.setProperty("LUNARDAY", Cal.getLunarDate());

		this.setName(this.POST_ID + "_RealtimeListMaker");
		this.WORK_FILE_ID = this.POST_ID + "_realtime_" + Cal.getSerialDate();

		// id 초기화 (by lena 2005.03초 쯤..)
		this.WORKDAY = null;
		this.SEQNO = null;
	}

	private	static	synchronized String MaxSeqDataSet(String map_header,String mail_type,String mail_type_seq, String channel_type) throws Exception{
		eMsConnection EMS_CONNECTION = null;
		eMsStatement __EMS_EXEC_STMT__ = null;
		eMsResultSet __SELECT_RESULT__ = null;
		
		Properties prop = new Properties();
		prop.setProperty("MAPPINGHEADER", map_header);
		prop.setProperty("MSG_TYPE", mail_type);
		prop.setProperty("MSG_TYPE_SEQ", mail_type_seq);
		prop.setProperty("CHANNEL_TYPE", channel_type);
		
		try{
			EMS_CONNECTION = ConnectionPool.getConnection();
			
			__EMS_EXEC_STMT__ = EMS_CONNECTION.createStatement();
			
			StringBuffer buffer = new StringBuffer();
			
			synchronized (QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO) {
				
				for (Iterator iter = QUERY_SELECT_REALTIME_INSERT_SCHEDULE_INFO.iterator(); iter.hasNext();) {
					String __EXEC_QUERY__ = (String) iter.next();
					buffer.setLength(0);
					StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__, prop, "${", "}", true, false);
					__SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(buffer.toString());
					
					if( __SELECT_RESULT__.next() ) {
						//결과를 차곡 차곡 쌓아 놓는다.
						__SELECT_RESULT__.putToMap(prop, false);
					}
					else {
						throw new RuntimeException("INFO RESULT SET SELECT FAIL");
					}
					if(__SELECT_RESULT__ != null){
						__SELECT_RESULT__.close();
					}
				}
			}
			//정보를 다 모았으면 스케쥴을 업데이트한다.
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_INSERT_REALTIME_SCHEDULE, prop, "${", "}", true, false);
			if (log.isDebugEnabled()) {
				log.debug("REALTIME SCHEDULE CREATE QUERY", buffer.toString());
			}
			
			int count = __EMS_EXEC_STMT__.executeUpdate( buffer.toString() );
	
			if( count < 1 ) {
				throw new RuntimeException("SCHEDULE INSERT FAIL");
			}
			
			return prop.getProperty("WORKDAY", "") + "_" + prop.getProperty("SEQNO", "");
			
		} catch(Exception e){
			log.error("Max Seq error", e);
			throw e;
		} finally{
			if(__SELECT_RESULT__ != null){
				__SELECT_RESULT__.close();
			}
			if(__EMS_EXEC_STMT__ != null){
				__EMS_EXEC_STMT__.close();
			}
			if(EMS_CONNECTION != null){
				EMS_CONNECTION.recycle();
			}
		}
	}
	
	protected synchronized void execute_DBInsertProcess() throws Exception {

		eMsStatement __EMS_EXEC_STMT__ = null;
		eMsResultSet __SELECT_RESULT__ = null;

		StringBuffer buffer = new StringBuffer(1024);
		eMsConnection EMS_CONNECTION = null;
		
		String workId = Cal.getSerialDate();
		this.SCHEDULE_INFO.setProperty("WORK_ID", workId);
		
		try {
			EMS_CONNECTION = ConnectionPool.getConnection();
			
			__EMS_EXEC_STMT__ = EMS_CONNECTION.createStatement();

			// 일단 100 번테이블에 정보를 점검하여생성한다.
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_SELECT_REALTIME_LAST_SCHEDULE, this.SCHEDULE_INFO, "${", "}", true, false);

			__SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(buffer.toString());

			if( __SELECT_RESULT__.next() ) {
				// 기존에 만들어진 스케쥴이 있다면
				__SELECT_RESULT__.putToMap(this.SCHEDULE_INFO, false);
				//log.debug(" ################## = " +
				// this.SCHEDULE_INFO.toString());
			}
			else {
				//기존에 만들어진 스케쥴이 없다면 정보를 만들고 기본값을 세팅한다.
				//먼저 닫고
				if(__SELECT_RESULT__ != null){
					__SELECT_RESULT__.close();
				}
				//정보 쿼리를 차례로 실행한다.
				
				/*
				 * schedule_info 테이블에 insert 시.
				 * 여러 thread 가 구동하기 때문에, MaxSeqDataSet() func safe를 위하여, QUERY_SELECT_BASE_SCHEDULE_INFO 동일한 쿼리를 한번더 select 한다. 
				 * 
				 */
				String map_header = this.SCHEDULE_INFO.getProperty("MAPPINGHEADER","");
				String key_value = "";
				key_value = MaxSeqDataSet( map_header , this.SCHEDULE_INFO.getProperty("MSG_TYPE"), this.SCHEDULE_INFO.getProperty("MSG_TYPE_SEQ"),this.SCHEDULE_INFO.getProperty("CHANNEL_TYPE"));
				
				String[] map_info = key_value.split("\\_");
				
				this.SCHEDULE_INFO.setProperty("WORKDAY", map_info[0]);
				this.SCHEDULE_INFO.setProperty("SEQNO", map_info[1]);
				this.SCHEDULE_INFO.setProperty("POST_ID",map_info[0]+ "_"+ map_info[1]);
				
				
				buffer.setLength(0);

				//TODO Object Lock 사용
				//synchronized ( QUERY_SELECT_BASE_SCHEDULE_INFO ) {
				synchronized (lock) {
					StringConvertUtil.ConvertString(buffer, QUERY_SELECT_BASE_SCHEDULE_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
					
					__SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(buffer.toString());
					
					if( __SELECT_RESULT__.next() ) {
						//결과를 차곡 차곡 쌓아 놓는다.
						__SELECT_RESULT__.putToMap(this.SCHEDULE_INFO, false);
					}
					else {
						throw new RuntimeException("INFO RESULT SET SELECT FAIL");
					}
					if(__SELECT_RESULT__ != null){
						__SELECT_RESULT__.close();
					}
				}
			}

			// 생성이 종료되었으니까 기본 값들 ( BasicListMaker에서 지정되는 )을 설정해야한다.
			this.WORKDAY = this.SCHEDULE_INFO.getProperty("WORKDAY");
			this.SEQNO = this.SCHEDULE_INFO.getProperty("SEQNO");

			// 컨텐트가 생성되었는지확인하고 없으면 만들어야 한다.
			if (log.isDebugEnabled()) 
				log.debug("REALTIME FINAL SCHEDULE_INFO", this.SCHEDULE_INFO.toString());
			
			/**
			 * TODO [JOO] QUERY_SELECT_REALTIME_LAST_SCHEDULE 에서 MODY_FLAG 가 "Y" 이면 실행한다. 
			 */
			if( !ContentInfoManager.checkContentInfo(this.SCHEDULE_INFO.getProperty("POST_ID"))
				|| this.SCHEDULE_INFO.getProperty("MODIFY_FLAG","N").equals("Y")) {
				// 정보가 생성되었으면 컨텐트를만들자
				if (log.isDebugEnabled()) 
					log.debug("CONTENT INFO MAKE PROPERTIES=>", this.SCHEDULE_INFO.toString());
				ContentPD INNER_CONTENT_PD = (ContentPD) MailSendingInstanceFactory.getInstance(this.SCHEDULE_INFO, eMsTypes.CONTENTPD_INSTANCE);
				INNER_CONTENT_PD.process(this.SCHEDULE_INFO);
				ContentInfo __CONTENT_INFO__ = INNER_CONTENT_PD.getContentInfo();
				ContentInfoManager.registContentInfo(__CONTENT_INFO__);
				
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_REALTIME_CONTENT_CREATE, this.SCHEDULE_INFO, "${", "}", true, false);
				
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
			throw e;
		}
		finally {
			if(EMS_CONNECTION != null){
				EMS_CONNECTION.recycleStatement(__EMS_EXEC_STMT__);
				EMS_CONNECTION.recycle();	
			}
		}

		super.execute_DBInsertProcess();
	}
	
	protected void updateQueryStatus(String querySeq, String queryType) {
		// 이 메소드에서 생기는 Exception 은 외부에 영향을 줘서는 안된다.
		// 에러는 로깅만 남긴다.
		
		if (log.isDebugEnabled()) 
			log.debug("updateQueryStatus =>" + SCHEDULE_INFO.toString());
		
		eMsConnection EMS_CONNECTION = null;
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		StringBuffer buffer = new StringBuffer(512);
		Properties prop = new Properties();
		
		try {
			prop.setProperty("MSG_TYPE", this.SCHEDULE_INFO.getProperty("MSG_TYPE",""));
			prop.setProperty("MSG_TYPE_SEQ", this.SCHEDULE_INFO.getProperty("MSG_TYPE_SEQ",""));
			prop.setProperty("QUERY_SEQ", querySeq);
			prop.setProperty("QUERY_TYPE", queryType);
			
			EMS_CONNECTION = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_QUERY_STATUS_REALTIME, prop, "${", "}", true, false);
			if (log.isDebugEnabled()) 
				log.debug("QUERY_STATUS =>" + buffer.toString());
			
		}
		catch(Exception ignore) {
			log.error(getName(), "SKIP.....");
		}
		finally {
			if( EMS_CONNECTION != null){
				EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
				EMS_CONNECTION.recycle();	
			}
		}
	}

	protected void updateTaskState(String __STATE__) throws Exception {
		//do nothing
	}

	protected void deleteCurrentList() throws Exception {
		//do nothing
	}
}
