/*
 * @(#)ReSendInfoActor.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.actor;

import java.io.ByteArrayOutputStream;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.io.FileElement;
import pluto.lang.Name;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;
import pluto.util.recycle.BufferedObjectPool;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.handler.LongMappingSpoolReader;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;
import freemarker20.ext.beans.StaticModels;
import freemarker20.template.SimpleHash;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class ReSendInfoActor extends Name implements InfoActor, pluto.log.Log  {
	
	
	
	
	/* 자동메일 매핑 파싱하는 파서*/
	protected static SpoolHashParser AUTO_KEY_VALUE_PARSER = null;
	
	protected static SpoolHeaderParser AUTO_HEADER_PARSER = null;
	
	protected static SimpleHash _MEMBER_HASH_ = null;
	
	protected static ByteArrayOutputStream INNER_BYTE_ARRAY = null;
	
	static{
		AUTO_KEY_VALUE_PARSER = new SpoolHashParser( "|" );
		AUTO_HEADER_PARSER = new SpoolHeaderParser();
		INNER_BYTE_ARRAY = new ByteArrayOutputStream( 1024 );
		_MEMBER_HASH_ = new SimpleHash();
	}
	
	/** Creates a new instance of MailPreViewInfoActor */
	public ReSendInfoActor() {
		this.setName( "PreviewInfoActor_" + Cal.getSerialDate() );
	}
	
	public void execute(InfoBeans arg) throws Exception {
		inner_execute( arg );
	}
	
	public synchronized static void inner_execute(InfoBeans arg) throws Exception {
		
		Properties prop = arg.getArgs();
		
		// String WORKDAY = prop.getProperty( "WORKDAY" );
		// String SEQNO = prop.getProperty( "SEQNO" );
		String MEMBER_ID = prop.getProperty( "MEMBER_ID" );
		String MEMBER_ID_SEQ = prop.getProperty( "MEMBER_ID_SEQ" );
		String RESEND_SEQ = prop.getProperty( "RESEND_SEQ" );
		String POST_ID = prop.getProperty( "POST_ID" );
		String MEMBER_MAPPING = prop.getProperty( "MAPPING" );
		String LIST_TABLE = prop.getProperty( "LIST_TABLE" );
		
		String SECURE_FLAG = prop.getProperty( "SECURE_FLAG" , "1" );
		String TO_TOKEN = prop.getProperty( "TO_EMAIL" );
		
		if( StringUtil.isError( TO_TOKEN ) ){
			prop.setProperty( "STATUS" , "INVALID EMAIL:".concat( TO_TOKEN) );
			return;
		}
		
		String DOMAIN = StringUtil.getDomain( TO_TOKEN );
		
		if (log.isDebugEnabled())  log.debug( prop.toString() );
		
		ContentInfo sendContentInfo = ContentInfoManager.getContentInfo( POST_ID );
		SpoolInfo sendSpoolInfo = SpoolInfoManager.getSpoolInfo( POST_ID );
			
		if( sendContentInfo == null ) {
			prop.setProperty( "STATUS" , "CONTENT INFO DOSE NOT EXIST!!!" );
			return;
		}
		
		try{
			/**파일이라면 파일을 읽어와야 한다.
			 */
			if( MEMBER_MAPPING.startsWith( "isam://" ) ) {
				synchronized( INNER_BYTE_ARRAY ){
					INNER_BYTE_ARRAY.reset();

					int idx_of_comma = MEMBER_MAPPING.indexOf( "," , 7 );
					int idx_of_at = MEMBER_MAPPING.indexOf( "@" , idx_of_comma );
					long start = Long.parseLong( MEMBER_MAPPING.substring( 7 , idx_of_comma ) );
					long end = Long.parseLong( MEMBER_MAPPING.substring( idx_of_comma + 1 , idx_of_at ) );
					
					LongMappingSpoolReader reader = LongMappingSpoolReader.getInstance( MEMBER_MAPPING.substring( idx_of_at + 1 ).replace( '\\' , '/' ) );
					
					reader.inner_get( start , end , INNER_BYTE_ARRAY );

					MEMBER_MAPPING = INNER_BYTE_ARRAY.toString( eMsLocale.FILE_SYSTEM_IN_CHAR_SET );
				}
			}
			else if( MEMBER_MAPPING.startsWith( "file://" ) ) {
				synchronized( INNER_BYTE_ARRAY ){
					INNER_BYTE_ARRAY.reset();
					
					FileElement.putFileBodyToStream( MEMBER_MAPPING.substring( 7 ) , INNER_BYTE_ARRAY );
					
					MEMBER_MAPPING = INNER_BYTE_ARRAY.toString( eMsLocale.FILE_SYSTEM_IN_CHAR_SET );
				}
			}
			
			String[] RCPT_ARRAY = new String[ SIZE_OF_RCPT_ARRAY ];
			
			synchronized( _MEMBER_HASH_ ){
				AUTO_KEY_VALUE_PARSER.parse( _MEMBER_HASH_ , MEMBER_MAPPING , sendSpoolInfo.getHEADER_KEY_MAP( "|" ) , sendSpoolInfo.getDefaultSimpleHashMapping() );
				
				/**매핑에 추가되는 기본 값들을 설정한다.
				 */
				_MEMBER_HASH_.put( "p_id" , POST_ID );
				
				//트래킹 맴버아이디
				_MEMBER_HASH_.put( "enc_mid" , TrackingInfoConvertor.enc_MEMBER_ID( MEMBER_ID.concat("_").concat( MEMBER_ID_SEQ ).concat("^").concat( RESEND_SEQ )  )  );
				//트래킹 맴버메일아이디
				_MEMBER_HASH_.put( "enc_p_id" , TrackingInfoConvertor.enc_MAIL_ID(  POST_ID  )  );
				//트래킹 마감일
				_MEMBER_HASH_.put( "enc_t_close" , TrackingInfoConvertor.enc_CLOSE( Cal.getAddDayDate( 7 )  )  );
				
				//함수변환
				_MEMBER_HASH_.put("statics", StaticModels.INSTANCE);
				
				_MEMBER_HASH_.put( "SECURE_FLAG" , SECURE_FLAG );
				
				RCPT_ARRAY[ INDEX_OF_CONTENT ]  = sendContentInfo.getResultMailBody( _MEMBER_HASH_ , sendSpoolInfo.getDefaultMapping());
			}
			
			RCPT_ARRAY[ INDEX_OF_SEND_KIND ] = "RESEND";
			RCPT_ARRAY[ INDEX_OF_POST_ID ] = POST_ID;
			RCPT_ARRAY[ INDEX_OF_MEMBER_ID ] = MEMBER_ID.concat("_").concat( MEMBER_ID_SEQ ).concat("^").concat( RESEND_SEQ );
			RCPT_ARRAY[ INDEX_OF_TOKEN_ID ] = TO_TOKEN;
			RCPT_ARRAY[ INDEX_OF_DOMAIN ] = DOMAIN;
			RCPT_ARRAY[ INDEX_OF_MAIL_FROM ] = sendContentInfo.getReturnPath();
			RCPT_ARRAY[ INDEX_OF_STEP ] = "0";
			RCPT_ARRAY[ INDEX_OF_LIST_TABLE ] = LIST_TABLE;
			RCPT_ARRAY[ INDEX_OF_SPOOL ] = null;
			
			BufferedObjectPool pool = BufferedAgentPool.getBufferedObjectPool( "direct" , DOMAIN );
			pool.push( RCPT_ARRAY );
			
			prop.setProperty( "STATUS" , "OK" );
		}
		catch( Exception e ){
			prop.setProperty( "STATUS" , "ERR" );
			prop.setProperty( "ERR_TRACE" , StringConvertUtil.exToString( e ) );
		}
		
		return;
	}
}

