/*
 * @(#)ContentsPreviewInfoActor.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.actor;

import java.io.ByteArrayOutputStream;
import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import pluto.io.FileElement;
import pluto.lang.Name;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.handler.LongMappingSpoolReader;
import venus.spool.common.parser.SpoolHashParser;
import freemarker20.ext.beans.StaticModels;
import freemarker20.template.SimpleHash;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class ContentsPreviewInfoActor extends Name implements InfoActor, pluto.log.Log  {
	
	
	
	
	/* 자동메일 매핑 파싱하는 파서*/
	protected static SpoolHashParser AUTO_KEY_VALUE_PARSER = null;
	
	protected static ByteArrayOutputStream INNER_BYTE_ARRAY = null;
	
	protected static SimpleHash _MEMBER_HASH_ = null;
	
	protected static ContentPD INNER_CONTENT_MAKE_INSTANCE = null;
	
	static{
		AUTO_KEY_VALUE_PARSER = new SpoolHashParser( "|" );
		INNER_BYTE_ARRAY = new ByteArrayOutputStream( 1024 );
		_MEMBER_HASH_ = new SimpleHash();
	}
	
	public static void init( Object tmp ) throws Exception{
		Properties prop = ( Properties )tmp;
		INNER_CONTENT_MAKE_INSTANCE = ( ContentPD )( Class.forName( prop.getProperty( "instant.content.make.class")).newInstance() );
	}
	
	/** Creates a new instance of ContentsPreviewInfoActor */
	public ContentsPreviewInfoActor() {
		this.setName( "PreviewInfoActor_" + Cal.getSerialDate() );
	}
	
	public void execute(InfoBeans arg) throws Exception {
		inner_execute( arg );
	}
	
	public synchronized static void inner_execute(InfoBeans arg) throws Exception {
		
		Properties prop = arg.getArgs();
		
		String MEMBER_ID = prop.getProperty( "MEMBER_ID" );
		String TO_TOKEN = prop.getProperty("TO_EMAIL");
		String POST_ID = prop.getProperty( "POST_ID" );
		String MEMBER_MAPPING = prop.getProperty( "MAPPING" );
		
		if(StringUtil.isNull(POST_ID)){
			POST_ID = prop.getProperty( "WORKDAY" )+"_"+prop.getProperty( "SEQNO" );
			 log.debug( "[POST_ID IS NULL]==> REMAKE:"+POST_ID );
		}
		
		if (log.isDebugEnabled())  log.debug( prop.toString() );
		
		ContentInfo sendContentInfo = ContentInfoManager.getContentInfo( POST_ID );
		SpoolInfo sendSpoolInfo = SpoolInfoManager.getSpoolInfo( POST_ID );
		
		if( sendContentInfo == null ) {
			if( INNER_CONTENT_MAKE_INSTANCE == null ){
				prop.setProperty( "CONTENTS" , "CONTENT INFO DOSE NOT EXIST!!!" );
				return;
			}
			
			try{
				INNER_CONTENT_MAKE_INSTANCE.process( prop );
				sendContentInfo = INNER_CONTENT_MAKE_INSTANCE.getContentInfo();
				ContentInfoManager.registContentInfo( sendContentInfo );
			}
			catch( Exception e ){
				if (log.isDebugEnabled())  log.error(e.getMessage());
				prop.setProperty( "CONTENTS" , "INSTANT CONTENT MAKE ERROR:" + e.toString() );
				return;
			}
		}
		
		/**파일이라면 파일을 읽어와야 한다.
		 */
		if( MEMBER_MAPPING.startsWith( "isam://" ) ) {
			synchronized( INNER_BYTE_ARRAY ){
				INNER_BYTE_ARRAY.reset();
				
				int idx_of_comma = MEMBER_MAPPING.indexOf( "," , 7 );
				int idx_of_at = MEMBER_MAPPING.indexOf( "@" , idx_of_comma );
				long start = Long.parseLong( MEMBER_MAPPING.substring( 7 , idx_of_comma ) );
				long end = Long.parseLong( MEMBER_MAPPING.substring( idx_of_comma + 1 , idx_of_at ) );
				
				LongMappingSpoolReader reader = LongMappingSpoolReader.getInstance( MEMBER_MAPPING.substring( idx_of_at + 1 ).replace( '\\' , '/' ) );
				
				reader.inner_get( start , end , INNER_BYTE_ARRAY );
				
				MEMBER_MAPPING = INNER_BYTE_ARRAY.toString( eMsLocale.FILE_SYSTEM_IN_CHAR_SET );
			}
		}
		else if( MEMBER_MAPPING.startsWith( "file://" ) ) {
			synchronized( INNER_BYTE_ARRAY ){
				INNER_BYTE_ARRAY.reset();
				
				FileElement.putFileBodyToStream( MEMBER_MAPPING.substring( 7 ) , INNER_BYTE_ARRAY );
				
				MEMBER_MAPPING = INNER_BYTE_ARRAY.toString( eMsLocale.FILE_SYSTEM_IN_CHAR_SET );
			}
		}
		
		synchronized( _MEMBER_HASH_ ){
			_MEMBER_HASH_.clear();
			if (log.isDebugEnabled())  log.debug( "MAP: " + MEMBER_MAPPING );
			if (log.isDebugEnabled())  log.debug( "KEYMAP: " + sendSpoolInfo.getHEADER_KEY_MAP( "|" ).toString() );

			//매핑의 종류에 따라서 파싱하는 방법이 다르게 되므로 추가...
			if( MEMBER_MAPPING.startsWith( "#P#:" ) ){
				// 매핑이 key value 로 들어 왔을 때
				StringConvertUtil.ConvertStringToSimpleHash( _MEMBER_HASH_ , MEMBER_MAPPING );
			}
			else{
				// 일반 헤더정보로 왔을때.
				AUTO_KEY_VALUE_PARSER.setDelim( sendContentInfo.getScheduleInfo().getProperty("DELIMIT","|" ) );
				AUTO_KEY_VALUE_PARSER.parse(  _MEMBER_HASH_ , MEMBER_MAPPING , sendSpoolInfo.getHEADER_KEY_MAP( "|" ) , sendSpoolInfo.getDefaultSimpleHashMapping() );
			}
			
			// 직렬 매핑 컬럼이 있다면 그거를 map_# 형태로 전환한다.
			if( _MEMBER_HASH_.containsKey( "SERIAL_MAPPING" ) ){
				AUTO_KEY_VALUE_PARSER.parseSerialMapping(  _MEMBER_HASH_ , _MEMBER_HASH_.getAsString( "SERIAL_MAPPING" ) , sendContentInfo.getScheduleInfo().getProperty("DELIMIT","|" ) );
			}
			// 종료..
			
			
			/**매핑에 추가되는 기본 값들을 설정한다.
			 */
			
			_MEMBER_HASH_.put( "m_id" , MEMBER_ID );
			_MEMBER_HASH_.put( "m_email" , TO_TOKEN );
			//_MEMBER_HASH_.put( "m_name" , "name" );
			_MEMBER_HASH_.put( "m_name" , prop.getProperty("MEMBER_NAME") );
			_MEMBER_HASH_.put( "p_id" , POST_ID );
			
			_MEMBER_HASH_.put( "TMS_M_ID" , MEMBER_ID );
			//_MEMBER_HASH_.put( "EMS_M_EMAIL" , TO_TOKEN );
			_MEMBER_HASH_.put( "EMS_M_TOKEN" , TO_TOKEN );
			//_MEMBER_HASH_.put( "TMS_M_NAME" , "name" );
			_MEMBER_HASH_.put( "TMS_M_NAME" , prop.getProperty("MEMBER_NAME") );

			//트래킹 맴버아이디
			_MEMBER_HASH_.put( "enc_mid" , TrackingInfoConvertor.enc_MEMBER_ID( "preView_1"  )  );
			//트래킹 맴버메일아이디
			_MEMBER_HASH_.put( "enc_p_id" , TrackingInfoConvertor.enc_MAIL_ID( POST_ID  )  );
			//트래킹 마감일
			_MEMBER_HASH_.put( "enc_t_close" , TrackingInfoConvertor.enc_CLOSE( "19000101" )  );
			
			//함수변환
			_MEMBER_HASH_.put("statics", StaticModels.INSTANCE);
			
			prop.setProperty( "CONTENTS" , sendContentInfo.getPreViewMailBody( _MEMBER_HASH_ , sendSpoolInfo.getDefaultMapping() ) );
		}
		
		return;
	}
}

