/*
 * @(#)BasicListMaker.java            2004. 12. 23.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul,
 * Korea republic of. All rights reserved.
 *
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 *
 */

package jupiter.auto.actor;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.AutoSendType;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.constrants.CommonColumn;
import com.humuson.tms.constrants.ErrorCode;

import jupiter.common.actor.ListMaker;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.UniqueKey;
import pluto.log.Composer;
import pluto.log.SmtpLogger;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;
import pluto.util.FilterUtils;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.handler.LongMappingSpooler;
import venus.spool.common.handler.SpoolFileObjectController;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;

/**
 * Class description :
 *
 * @version
 * @author dragon
 *
 */
@Slf4j
public class BasicListMaker extends SpoolFileObjectController implements ListMaker {

	private static String			QUERY_UPDATE_STATE_INFO						= null;

	private static String			QUERY_SELECT_LIST_QUERY_INFO				= null;

	private static String			QUERY_INSERT_SCHEDULED_SEND_LIST			= null;

	public static String			QUERY_SELECT_TARGET_CNT						= null;

	private static String			QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE	= null;

	private static String			QUERY_DELETE_CURRENT_LIST					= null;

	public static String			QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE	= null;

	private static String			QUERY_UPDATE_SCHEDULED_SEND_LIST 			= null;
	//중복발송방지쿼리
	private static String			QUERY_UPDATE_MSG_ERROR						= null;

	private static String 			QUERY_UPDATE_SCHEDULED_ERROR				= null;

	// 피로도 설정값 가져오는 쿼리
	private static String querySelectFatigueInfo = null;
	private static String querySelectMemberFatigueCount = null;
	private static String queryInsertOrUpdateFatigueList = null;

	/**
	 * 리스트 생성 중간 파일들이 저장되는 디렉토리
	 */
	public static String			TMP_WORKING_DIRECTORY						= null;

	public static int				MAPPING_LIMIT								= 1024;

	//개인정보 (이메일/전화번호) 암호화 여부
	public static String			MEMBER_INFO_ENCRYPT_YN						= "N";

	public static String 			encKey 										= null;
	public static String FATIGUE_USE_YN = null;
	
	static {

		try {

			QUERY_UPDATE_STATE_INFO = SqlManager.getQuery("COMMON", "QUERY_UPDATE_STATE_INFO");

			QUERY_SELECT_LIST_QUERY_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_LIST_QUERY_INFO");

			QUERY_INSERT_SCHEDULED_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_INSERT_SCHEDULED_SEND_LIST");

			QUERY_UPDATE_SCHEDULED_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SCHEDULED_SEND_LIST");

			QUERY_SELECT_TARGET_CNT = SqlManager.getQuery("COMMON", "QUERY_SELECT_TARGET_CNT");

			QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE = SqlManager.getQuery("COMMON", "QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE");

			QUERY_DELETE_CURRENT_LIST = SqlManager.getQuery("COMMON", "QUERY_DELETE_CURRENT_LIST");

			QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE = SqlManager.getQuery("COMMON", "QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE");

			QUERY_UPDATE_MSG_ERROR = SqlManager.getQuery("UPDATE_ERROR", "QUERY_UPDATE_MSG_ERROR");

			QUERY_UPDATE_SCHEDULED_ERROR = SqlManager.getQuery("UPDATE_ERROR", "QUERY_UPDATE_SCHEDULED_ERROR");

			TMP_WORKING_DIRECTORY = eMsSystem.getProperty("temp.working.dir", System.getProperty("java.io.tmpdir")).trim();

			MAPPING_LIMIT = Integer.parseInt(eMsSystem.getProperty("long.mapping.limit", "1000").trim());

			MEMBER_INFO_ENCRYPT_YN = eMsSystem.getProperty("member.info.encrypt.yn","N");

			encKey = eMsSystem.getProperty("member.info.encrypt.key");

			// 피로도 관련 쿼리 추가
			querySelectFatigueInfo = SqlManager.getQuery("COMMON", "QUERY_SELECT_FATIGUE_INFO");	// 피로도 설정값
			querySelectMemberFatigueCount = SqlManager.getQuery("COMMON","QUERY_SELECT_MEMBER_FATIGUE_COUNT");	// 멤버별 피로도 발송건수 가져오는 쿼리
			queryInsertOrUpdateFatigueList = SqlManager.getQuery("COMMON", "QUERY_INSERT_OR_UPDATE_FATIGUE_LIST");	// 피로도 발송건수 올리기
			
			FATIGUE_USE_YN = eMsSystem.getProperty("fatigue.yn","N");

		} catch(Exception e) {
			log.error("query load fail", e);
			System.exit(1);
		}
	}

	/**
	 * 실행 쿼리를 매핑하는 정보 Hash
	 */
	protected Properties			SCHEDULE_INFO								= null;

	/**
	 * 쿼리 매핑정보추출 쿼리를 저장하는 VECTOR
	 */
	protected Vector<ConnectInfo>				VECTOR_QUERY_MAPPING_INFO					= new Vector<ConnectInfo>();

	/**
	 * 리스트 쿼리
	 */
	protected Vector<ConnectInfo>				VECTOR_QUERY_LIST_INFO						= new Vector<ConnectInfo>();

	/**
	 * 기본매핑 쿼리 저장
	 */
	protected Vector<ConnectInfo>				VECTOR_QUERY_SIMPLE_MAPPING_INFO			= new Vector<ConnectInfo>();

	/**
	 * BLOB TYPE의 매핑
	 */
	protected Vector<ConnectInfo>				VECTOR_QUERY_BLOB_MAPPING_INFO				= new Vector<ConnectInfo>();

	/**
	 * LIST MAPPING 쿼리
	 */
	protected Vector<ConnectInfo>				VECTOR_QUERY_LOOP_MAPPING_INFO				= new Vector<ConnectInfo>();

	/**
	 * UPDATE 쿼리저장
	 */
	protected Vector<ConnectInfo>				VECTOR_QUERY_UPDATE_INFO					= new Vector<ConnectInfo>();

	/**
	 * 기본 리스트 정보를 저장하는 파일이름
	 */
	protected String				LIST_STORE_FILE_NAME						= null;

	/**
	 * 기본매핑을 추가하는 파일 이름
	 */
	protected String				MAPPING_INFO_ADDED_FILE_NAME				= null;

	/**
	 * LONG 매핑 추가 파일이름
	 */
	protected String				BLOB_MAPPING_INFO_ADDED_FILE_NAME			= null;

	/**
	 * LOOP 매핑 추가 파일 이름
	 */
	protected String				LOOPING_INFO_ADDED_FILE_NAME				= null;

	/**
	 * 리스트 테이블에 INSERT 한 정보를 가지는 파일 이름
	 */
	protected String				INFO_ADDED_FINAL_FILE_NAME					= null;

	/**
	 * 단계별 기본 정보가 되는 파일 이름
	 */
	protected String				NEXT_BASE_INFO_FILE_NAME					= null;

	protected String				POST_ID										= null;

	protected String				WORKDAY										= null;

	protected String				SEQNO										= null;

	/**
	 * 파일 작업시 기본이 되는 기본파일 정보
	 */
	protected String				WORK_FILE_ID								= null;

	/* 자동메일 매핑 파싱하는 파서 */
	protected SpoolHashParser		AUTO_KEY_VALUE_PARSER						= null;

	/* 현재 작업되는 메일의 Mapping Header */
	protected String				MAPPING_HEADER								= null;

	/**
	 * 로그 조립 COMPOSER
	 */
	protected Composer				composer									= null;

	protected Map<String, String>					__TMP_SIMPLE_HASH__							= new Hashtable<String, String>();

	protected Hashtable<String, String>				__HEADER_MAP__								= new Hashtable<String, String>();

	//protected eMsConnection			EMS_CONNECTION								= null;

	protected String				MAIL_ID = "";

	//삼성생명 전용으로 추가한 부분임.
	protected String TMS_M_TOKEN_DECRYPT  = "TMS_M_TOKEN_DECRYPT";
	protected String KEY_FILLER           = "KEY_FILLER";

	//================ [현대해상]  DB부하 감소를 위해 ems connetion 정보를 셋팅하는 변수 시작 ==============
	protected String				EMS_DB_URL = "";

	protected String				EMS_DB_ID = "";

	protected String				EMS_DB_PWD = "";
	//================ [현대해상]  DB부하 감소를 위해 ems connetion 정보를 셋팅하는 변수 끝  ==============

	private eMsPreparedStatement psMemberFatigueCount = null;	// 멤버별 피로도 발송건수 체크에 사용할 자원

	private int fatigueDayLimitCount = 0;	// 피로도에 설정된 일 발송건수
	private int fatigueMonthLimitCount = 0;	// 피로도에 설정된 월 발송건수
	private int fatigueFilteredCount = 0;	// 피로도에 필터링된 건수

	/** Creates a new instance of BasicListMaker */
	public BasicListMaker() {
	}

	/**
	 * 내부변수를 초기화 한다.
	 */
	protected void inner_init(Properties prop) throws Exception {
		this.SCHEDULE_INFO = prop;

		// 로그 조립 인스턴스 초기화
		this.composer = Composer.getComposerInstance();

		// 스풀 헤쉬파서 초기화
		this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");

		// 음력을 입력해 준다.
		this.SCHEDULE_INFO.setProperty("LUNARDAY", Cal.getLunarDate());

		this.WORKDAY = this.SCHEDULE_INFO.getProperty("WORKDAY");
		this.SEQNO = this.SCHEDULE_INFO.getProperty("SEQNO");

		this.POST_ID = this.SCHEDULE_INFO.getProperty("POST_ID");

		this.MAIL_ID = this.SCHEDULE_INFO.getProperty("MAIL_ID");

		this.setName("["+this.MAIL_ID + "] "+ this.POST_ID + "'s BasicListMaker");

		this.WORK_FILE_ID = this.POST_ID + "_real_" + Cal.getSerialDate();

	}


	@Override
	protected void inner_process(Properties prop) throws Exception {
		inner_init(prop);

		if (log.isDebugEnabled())
			log.debug("EXEC INFO=>".concat(this.SCHEDULE_INFO.toString()));

		try {
			/**
			 * 리스트를 생성하기위한 쿼리와 쿼리를 매핑하기위한 쿼리등... 쿼리정보를 저장하는 단계
			 */
			if (log.isDebugEnabled())
				log.debug("execute_getConnectInfo START");
			execute_getConnectInfo();
			if (log.isDebugEnabled())
				log.debug("execute_getConnectInfo END");

			/**
			 * 쿼리에 매핑에 필요한 정보를 생성하는 단계
			 */
			if (log.isDebugEnabled())
				log.debug("execute_QueryMappingInfoProcess START");
			execute_QueryMappingInfoProcess();
			if (log.isDebugEnabled())
				log.debug("execute_QueryMappingInfoProcess END");

			/**
			 * 리스트생성시작 마킹
			 */
			updateTaskState("11");

			if (log.isDebugEnabled())
				log.debug("execute_BasicInfoProcess START");
			execute_BasicInfoProcess();
			if (log.isDebugEnabled())
				log.debug("execute_BasicInfoProcess END");

			/* 심플 매핑을 가지고 온다 */
			if (log.isDebugEnabled())
				log.debug("execute_MappingProcess START");
			execute_MappingProcess();
			if (log.isDebugEnabled())
				log.debug("execute_MappingProcess END");

			/* 심플 매핑을 가지고 온다 */
			if (log.isDebugEnabled())
				log.debug("execute_MappingProcess START");
			execute_BlobMappingProcess();
			if (log.isDebugEnabled())
				log.debug("execute_MappingProcess END");

			/*
			 * 리스트 매핑을 가지고 온다
			 */
			if (log.isDebugEnabled())
				log.debug("execute_LoopingProcess START");
			execute_LoopingProcess();
			if (log.isDebugEnabled())
				log.debug("execute_LoopingProcess END");

			// 매핑 헤더 값을 셋팅한다. 나중에 꺼내 쓰기 위해..
			this.MAPPING_HEADER = this.SCHEDULE_INFO.getProperty("MAPPINGHEADER");

			/**
			 * 리스트생성종료 마킹
			 */
			updateTaskState("13");
		}
		catch(NoTargetListException e) {
			/**
			 */
			/**
			 * 대상리스트가 없는 경우에는
			 */
			updateTaskState("19");
			return;
		}
		catch(Exception e) {
			log.error("error", e);
			/**
			 * 리스트생성에러 마킹
			 */
			updateTaskState("12");

			if (log.isDebugEnabled())
				log.debug("main process method END");

			throw e;
		}

		try {
			/**
			 * 기존 리스트를 삭제한다.
			 */
			if (log.isDebugEnabled())
				log.debug("deleteCurrentList START");
			deleteCurrentList();
			if (log.isDebugEnabled())
				log.debug("deleteCurrentList START");

			/**
			 * 리스트업로드 시작
			 */
			updateTaskState("14");

			/**
			 * 리스트 테이블에 인서트 한다.
			 */
			if (log.isDebugEnabled())
				log.debug("execute_DBInsertProcess START");
			execute_DBInsertProcess();
			if (log.isDebugEnabled())
				log.debug("execute_DBInsertProcess END");

			/**
			 * 리스트업로드 종료
			 */
			updateTaskState("16");

			/**
			 * 리스트 업데이트 시작
			 */
			if (log.isDebugEnabled())
				log.debug("execute_FinalProcess START");
			execute_FinalProcess();
			if (log.isDebugEnabled())
				log.debug("execute_FinalProcess END");

			/**
			 * 리스트생성종료 마킹
			 */
			updateTaskState("19");
		}
		catch(NoTargetListException e) {
			/**
			 * 대상리스트가 없는 경우에는
			 */
			updateTaskState("19");
		}
		catch(Exception e) {
			/**
			 * 리스트 업로드 중에러 발생
			 */
			updateTaskState("15");
			throw e;
		}

	}

	/**
	 * 리스트를 생성하면서 사용하게될 쿼리를 설정한다.
	 *
	 * @param prop
	 *        발송스케쥴 정보
	 * @param conn
	 *        데이터베이스 연결
	 * @throws Exception
	 *         에러
	 */
	protected void execute_getConnectInfo() throws Exception {
		// 가져오기 전에 에러로 다시돌 경우에 대비해서 벡터를 비운다.
		this.VECTOR_QUERY_LIST_INFO.clear();
		this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.clear();
		this.VECTOR_QUERY_BLOB_MAPPING_INFO.clear();
		this.VECTOR_QUERY_LOOP_MAPPING_INFO.clear();
		this.VECTOR_QUERY_UPDATE_INFO.clear();
		this.VECTOR_QUERY_MAPPING_INFO.clear();

		eMsConnection EMS_CONNECTION = ConnectionPool.getConnection();

		//[현대해상] eMs ConnectInfo 가져오기
		ConnectInfo EMS_CON_INFO  = eMsConnection.getConnectInfo("ems");
		EMS_DB_URL = EMS_CON_INFO.getDB_URL();
		EMS_DB_ID = EMS_CON_INFO.getDB_UID();
		EMS_DB_PWD = EMS_CON_INFO.getDB_PASS();

		eMsStatement __SELECT_STATEMENT__ = null;
		eMsResultSet rs = null;


		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();

			StringBuffer buffer = new StringBuffer(512);
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_SELECT_LIST_QUERY_INFO, this.SCHEDULE_INFO, "${", "}", true, false);
			rs = __SELECT_STATEMENT__.executeQuery(buffer.toString());

			if (log.isDebugEnabled()) {
				log.debug("[================================================>]");
				log.debug("대상자 리스트 query["+buffer.toString()+"]");
				log.debug("[================================================>]");
			}

			if (log.isDebugEnabled())
				log.debug("exec local=>", "OK");

			Properties __TMP_CONNECT_INFOS__ = new Properties();

			while (rs.next()) {
				__TMP_CONNECT_INFOS__.clear();

				rs.putToMap(__TMP_CONNECT_INFOS__, false);

				ConnectInfo __TMP_CONNECTION_INFO__ = null;

				switch (eMsConnection.GET_CONNECTION_TYPE) {
					case eMsConnection.__CONNECTION_INDEX_TYPE__: {
						__TMP_CONNECTION_INFO__ = eMsConnection.getConnectInfo(__TMP_CONNECT_INFOS__.getProperty(eMsConnection.GET_CONNECTION_INDEX));
						break;
					}
					default: {
						__TMP_CONNECTION_INFO__ = new ConnectInfo();

						__TMP_CONNECTION_INFO__.setDB_ID(this.getName());
						__TMP_CONNECTION_INFO__.setDB_NAME(this.getName());

						__TMP_CONNECTION_INFO__.setDRIVER(__TMP_CONNECT_INFOS__.getProperty("CONNECT_DRIVER"));
						__TMP_CONNECTION_INFO__.setDB_URL(__TMP_CONNECT_INFOS__.getProperty("CONNECT_IP"));
						__TMP_CONNECTION_INFO__.setDB_UID(__TMP_CONNECT_INFOS__.getProperty("CONNECT_ID"));
						__TMP_CONNECTION_INFO__.setDB_PASS(HumusonDecryptor.decrypt( __TMP_CONNECT_INFOS__.getProperty("CONNECT_PWD"), encKey));
						__TMP_CONNECTION_INFO__.setDB_BASE_CHARSET(__TMP_CONNECT_INFOS__.getProperty("BASE_CHARSET"));
						__TMP_CONNECTION_INFO__.setDB_IN_CHARSET(__TMP_CONNECT_INFOS__.getProperty("IN_CHARSET"));
						__TMP_CONNECTION_INFO__.setDB_OUT_CHARSET(__TMP_CONNECT_INFOS__.getProperty("OUT_CHARSET"));


						__TMP_CONNECTION_INFO__.setQUERY_SEQ(__TMP_CONNECT_INFOS__.getProperty("QUERY_SEQ"));
						__TMP_CONNECTION_INFO__.setQUERY_TYPE(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE"));
						__TMP_CONNECTION_INFO__.setENCRYPT_YN(__TMP_CONNECT_INFOS__.getProperty("ENCRYPT_YN"));

						break;
					}
				}

				__TMP_CONNECTION_INFO__.setQUERY(__TMP_CONNECT_INFOS__.getProperty("QUERY_SELECT"));
				if (log.isDebugEnabled()) {
					log.debug("쿼리 정보 ("+Integer.parseInt(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE"))+") ["+__TMP_CONNECT_INFOS__.getProperty("QUERY_SELECT") +"]");
				}
				__TMP_CONNECTION_INFO__.setAPPEND_NULL(__TMP_CONNECT_INFOS__.getProperty("APPEND_NULL", "N").equalsIgnoreCase("Y"));
				if (log.isDebugEnabled()) {
					log.debug("APPEND NULL : ("+__TMP_CONNECT_INFOS__.getProperty("APPEND_NULL") +")");
				}

				switch (Integer.parseInt(__TMP_CONNECT_INFOS__.getProperty("QUERY_TYPE"))) {
					/* 리스트 추출 쿼리 */
					case 10: {
						this.VECTOR_QUERY_LIST_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 기본매핑쿼리 */
					case 20: {
						this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* LONG 매핑쿼리 */
					case 25: {
						this.VECTOR_QUERY_BLOB_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 리스트 매핑쿼리 */
					case 30: {
						this.VECTOR_QUERY_LOOP_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 업데이트 쿼리 */
					case 40: {
						this.VECTOR_QUERY_UPDATE_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					/* 쿼리매핑 */
					case 50: {
						this.VECTOR_QUERY_MAPPING_INFO.addElement(__TMP_CONNECTION_INFO__);
						break;
					}

					default: {
						throw new RuntimeException("DB QUERY TYPE IS INVALID");
					}
				}
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(rs != null){
					rs.close();
				}
			}
			catch(Exception ignore) {
			}
			if (EMS_CONNECTION != null) {
				if (__SELECT_STATEMENT__ != null) {
					EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
				}

				EMS_CONNECTION.recycle();
			}
		}

		// 리스트 쿼리가 존재 하지 않는다면 에러를 발생해야쥐...
		if( this.VECTOR_QUERY_LIST_INFO.size() != 1 ) {
			throw new RuntimeException("NO LIST QUERY or TOO MANY QUERY => " + this.VECTOR_QUERY_LIST_INFO.size());
		}
	}

	/**
	 * 쿼리에 매핑할 녀석들을 가져온다. <br>
	 * 발송 정보중에서 QUERY_MAPPING 파라미터를 먼저 파싱하여 query_map_# 순서로
	 *
	 * @param conn
	 * @throws Exception
	 */
	protected void execute_QueryMappingInfoProcess() throws Exception {
		int __QUERY_SIZE__ = this.VECTOR_QUERY_MAPPING_INFO.size();

		if( __QUERY_SIZE__ < 1 ) {
			if (log.isDebugEnabled())
				log.debug("NO QUERY  MAPPING INFO....");
			return;
		}

		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		ConnectInfo __TARGET_CONNECT_INFO__ = null;

		String __EXEC_TARGET_QUERY__ = null;

		StringBuffer buffer = new StringBuffer(1024);

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_MAPPING_INFO.get(i);

			try {

				//[현대해상] eMs 커넥션 정보(out_db.properties)와 자동메일(EMS_AUTO_QUERY_INFO) 커넥션정보가 같은지 비교
				//같으면 EMS커넥션 POOL을 이용하여 커넥션을 가져온다.
				//EMS DB 부하 감소!!!!!!!!!!!!!!!!!!!!
				//====================== 로직 시작 ============================

				if(checkConnectionInfo(__TARGET_CONNECT_INFO__ )){
					__TARGET_CONNECTION__ = ConnectionPool.getConnection();
				}else{
					__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
				}

				//====================== 로직  끝  ============================


				stmt = __TARGET_CONNECTION__.createStatement();

				if (log.isDebugEnabled()) {
					log.debug( ".execute_QueryMappingInfoProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
					log.debug( ".execute_QueryMappingInfoProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
					log.debug( ".execute_QueryMappingInfoProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());
				}

				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = buffer.toString();

				if (log.isDebugEnabled()) {
					log.debug(".execute_QueryMappingInfoProcess() exe query:" + __EXEC_TARGET_QUERY__);
				}

				rs = stmt.executeQuery(__EXEC_TARGET_QUERY__);

				if (log.isDebugEnabled()) {
					log.debug( ".execute_QueryMappingInfoProcess() exe query:[OK]");
				}

				if( rs.next() ) {
					rs.putToMap(this.SCHEDULE_INFO, false);
					if (log.isDebugEnabled())
						log.debug(this.SCHEDULE_INFO.toString());
				}
			}
			catch(Exception e) {
				log.error("target query error", __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					if( rs != null){
						rs.close();
					}
				}
				catch(Exception ignore) {
				}
				try {
					if( stmt != null ){
						stmt.close();
					}
				}
				catch(Exception ignore) {
				}
				try {
					if (__TARGET_CONNECTION__ != null) {
						__TARGET_CONNECTION__.destroy();
					}
				}
				catch(Exception ignore) {
				}
			}
		}
	}

	/**
	 * 기본 회원 정보를 지정파일에 저장한다.
	 */
	protected void execute_BasicInfoProcess() throws Exception {
		String this_day = Cal.getDayDate();

		// 기본리스트 파일 저장 파일이름 결정
		this.LIST_STORE_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".base";

		/**
		 * 저장파일을 초기화 한다.
		 */
		openWriter(this.LIST_STORE_FILE_NAME);

		this.NEXT_BASE_INFO_FILE_NAME = this.LIST_STORE_FILE_NAME;

		String __EXEC_TARGET_QUERY__ = null;

		eMsConnection __TARGET_CONNECTION__ = null;
		eMsResultSet rs = null;
		eMsStatement stmt = null;

		/* 시작 전에 헤더 스트링을 초기화하고 시작한다. */
		this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", "");

		ConnectInfo __TMP_CONNECTION_INFO__ = this.VECTOR_QUERY_LIST_INFO.get(0);

		boolean __APPEND_CHECK__ = false;

		StringBuffer buffer = new StringBuffer(1024);

		try {

			//[현대해상] eMs 커넥션 정보(out_db.properties)와 자동메일(EMS_AUTO_QUERY_INFO) 커넥션정보가 같은지 비교
			//같으면 EMS커넥션 POOL을 이용하여 커넥션을 가져온다.
			//EMS DB 부하 감소!!!!!!!!!!!!!!!!!!!!
			//====================== 로직 시작 ============================

			if(checkConnectionInfo(__TMP_CONNECTION_INFO__ )){
				__TARGET_CONNECTION__ = ConnectionPool.getConnection();
			}else{
				__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);
			}

			//====================== 로직  끝  ============================

			stmt = __TARGET_CONNECTION__.createStatement();

			if (log.isDebugEnabled()) {
				log.debug( ".execute_BasicInfoProcess() db:" + __TMP_CONNECTION_INFO__.toString());
			}

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
			__EXEC_TARGET_QUERY__ = buffer.toString();
			if (log.isDebugEnabled()) {
				log.debug(".execute_BasicInfoProcess() exe query:" + __EXEC_TARGET_QUERY__);
			}
			rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));

			if (log.isDebugEnabled())
				log.debug( ".execute_BasicInfoProcess() exe query:[OK]");

			// [BY HWANG] 암호화할 필요가 있는 경우인지 확인해서 헤더 세팅 //////////////////////////////////////////
			String [] header_list = StringUtil.split(rs.getHeaderString(), "|");
			buffer.setLength(0);

			//액션 인덱스
			int decrypt_index = 0;
			int key_filler_index = 0;
			String temp_header = "";

			for(int i=1; i<=header_list.length; i++) {
				temp_header = header_list[i-1];

				//암호화를 해야하는 플래그를 발견했을 때
				if(temp_header.equals(TMS_M_TOKEN_DECRYPT)){
					//사용할 alias로 수정
					//action>> TMS_M_TOKEN_DECRYPTE ==> TMS_M_TOKEN
					temp_header = "TMS_M_TOKEN";
					decrypt_index = i;
				}

				/* [BY JOO]
				 * **********************************************
				 * KEY_FILLER
				 * - 실시간 메일에 있는 컬럼으로 내용은 아래와 같다.
				 * 1. 고객ID
				 * 2. 발송일시
				 * 3. 안내장코드
				 * 4. 개별대표안내ID
				 * 5. 보안/일반 구분(Y/N) : 보안인경우 'Y'
				 * **********************************************
				 *
				 * 데이터에 고객ID와 보안구분이 없기 때문에 이부분을 추가한다.
				 * 삼성생명 전용으로 개발한 부분이다.
				 */
				//KEY_FILLER를 발견했을 때
				if(temp_header.equals(KEY_FILLER)){
					//사용할 alias로 수정
					//action>> TMS_M_TOKEN_DECRYPTE ==> TMS_M_TOKEN
					temp_header = "SSLIFE_ID|EMS_M_SECURE";
					key_filler_index = i;
				}

				//헤더를 다시 만들어줌
				if(i!=1){
					buffer.append("|");
				}
				buffer.append(temp_header);
			}

			this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
			////////////////////////////////////////////////////////////////////////////////////

			if (log.isDebugEnabled())
				log.debug("TARGET MAPPINGHEADER : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));

			int colcount = rs.getColumnCount();

			String temp = "";


			while (rs.next()) {
				buffer.setLength(0);

				//맨처음오는것이 평문의 email이라면 암호화 한다.
				if(decrypt_index==1 ){
					temp = CryptoUtil.enEmailAddr(rs.getString(1));
				}else if(key_filler_index==1) {//keyfiller면 sslife_id 와 ems_m_secure 값을 가져온다.
					temp = StringUtil.getKeyFillerValue(rs.getString(1));
				}else{
					temp = rs.getString(1);
				}

				//key_filer 일경우에는 컬럼 확인 필요없이 그냥 넣는다.
				if(key_filler_index==1) {
					buffer.append(temp);
				}else{
					DelimConvertor.encodeToBuffer(buffer, (temp == null ? "" : temp.trim()));
				}


				for (int count = 2; count <= colcount; count++) {
					buffer.append("|");

					//평문의 email이라면 암호화 한다.
					if(decrypt_index==count ){
						temp = CryptoUtil.enEmailAddr(rs.getString(count));
					}else if(key_filler_index==count) { //keyfiller면 sslife_id 와 ems_m_secure 값을 가져온다.
						temp = StringUtil.getKeyFillerValue(rs.getString(count));
					}else{
						temp = rs.getString(count);
					}

					//key_filer 일경우에는 컬럼 확인 필요없이 그냥 넣는다.
					if(key_filler_index==count) {
						buffer.append(temp);
					}else{
						DelimConvertor.encodeToBuffer(buffer, (temp == null ? "" : temp.trim()));
					}
				}
				//StringBuffer에 append한 것을 쓴다...
				BUFFERED_WRITER.write(buffer.toString());
				BUFFERED_WRITER.newLine();
				BUFFERED_WRITER.flush();

				__APPEND_CHECK__ = true;
				if (log.isDebugEnabled())
					log.debug("LINE CREATE....");
			}

		}
		catch(Exception e) {
			if( !__APPEND_CHECK__ ) {
				if (log.isDebugEnabled())
					log.debug("NO TARGET LIST....");
				this.deleteWriter();
			}
			else {
				this.closeWriter();
			}
			log.error(getName(), e);
			throw e;
		}
		finally {
			try {
				if( rs != null){
					rs.close();
				}
			}
			catch(Exception ignore) {
			}
			try {
				if( stmt != null ){
					stmt.close();
				}
			}
			catch(Exception ignore) {
			}
			try {
				__TARGET_CONNECTION__.destroy();
			}
			catch(Exception ignore) {
			}
		}
		/**
		 * 리스트가 하나도 없다면 Exception을 날린다.
		 */
		if( !__APPEND_CHECK__ ) {
			if (log.isDebugEnabled())
				log.debug("NO TARGET LIST....");
			this.deleteWriter();  //tmp/날짜/파일.base 삭제 한다.
			throw new NoTargetListException("NO TARGET LIST => " + this.POST_ID);
		}

		this.closeWriter();
	}

	/**
	 * 기본 회원 정보저장 파일을 참조하여 매핑 정보를 추가한 파일을 생성한다. step : BASIC_INFO_OK 에서 실행 된다.
	 */
	protected void execute_MappingProcess() throws Exception {
		int __QUERY_SIZE__ = this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.size();

		if( __QUERY_SIZE__ < 1 ) {
			if (log.isDebugEnabled())
				log.debug("NO MAPPING QUERY  INFO....");
			return;
		}

		String this_day = Cal.getDayDate();
		// 기본리스트 파일 저장 파일이름 결정
		this.MAPPING_INFO_ADDED_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".mapping";

		/**
		 * 저장파일을 초기화 한다.
		 */
		log.debug( ".execute_MappingProcess() set spool file :" + this.MAPPING_INFO_ADDED_FILE_NAME);
		openWriter(this.MAPPING_INFO_ADDED_FILE_NAME);

		log.debug( ".execute_MappingProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
		openReader(this.NEXT_BASE_INFO_FILE_NAME);

		/**
		 * 다음 단계에서 사용할 소스파일을 지정한다.
		 */
		this.NEXT_BASE_INFO_FILE_NAME = this.MAPPING_INFO_ADDED_FILE_NAME;

		ConnectInfo __TARGET_CONNECT_INFO__ = null;
		String __EXEC_TARGET_QUERY__ = null;

		boolean __APPEND_CHECK__ = false;

		eMsConnection __TARGET_CONNECTION__ = null;

		eMsStatement stmt = null;
		eMsPreparedStatement __PS_TARGET_QUERY__ = null;

		eMsResultSet rs = null;
		String __TMP_HEADER_STRING__ = null;

		String __TMP_READ_LINE__ = null;

		StringBuffer buffer = new StringBuffer(1024);

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			try {
				if( i > 0 ) {
					/**
					 * 한번 지나간것이라면 읽어오는 소스는 기존에 만들어 놓은 mapping 파일이어야 한다. 그래서 기존에 생성한 mapping 파일을 인덱스를 append한 파일로 옮기고 그 파일을 다시 읽어 들이도록 설정을 한다.
					 */
					log.debug( ".execute_MappingProcess() set switch file :" + this.MAPPING_INFO_ADDED_FILE_NAME + "=>" + this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
					File rename = new File(this.MAPPING_INFO_ADDED_FILE_NAME);
					File target = new File(this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));

					// 다음 파일이 존재할 경우 삭제
					if( target.exists() ) {
						try {
							if(target.delete()) {
								log.debug("success delete-target-file");
							}
							else {
								log.debug("failed delete-target-file");
							}
						}
						catch(Exception e) {
							log.error(getName(), e);
						}
					}

					if( rename.renameTo(new File(this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i))) ) {
						log.info("Rename Success");
					}
					else {
						log.info("Rename Fail");
					}

					// 기 작업 파일을 옮겼고 같은 파일로 작업파일 지정
					log.info(".execute_MappingProcess() set spool file :" + this.MAPPING_INFO_ADDED_FILE_NAME);
					openWriter(this.MAPPING_INFO_ADDED_FILE_NAME);

					log.info(".execute_MappingProcess() set source file :" + this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
					openReader(this.MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
				}

				__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_SIMPLE_MAPPING_INFO.get(i);

				//[현대해상] eMs 커넥션 정보(out_db.properties)와 자동메일(EMS_AUTO_QUERY_INFO) 커넥션정보가 같은지 비교
				//같으면 EMS커넥션 POOL을 이용하여 커넥션을 가져온다.
				//EMS DB 부하 감소!!!!!!!!!!!!!!!!!!!!
				//====================== 로직 시작 ============================

				if(checkConnectionInfo(__TARGET_CONNECT_INFO__ )){
					__TARGET_CONNECTION__ = ConnectionPool.getConnection();
				}else{
					__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
				}

				//====================== 로직  끝  ============================

				log.debug( ".execute_MappingProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
				log.debug( ".execute_MappingProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
				log.debug( ".execute_MappingProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());

				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = buffer.toString();

				boolean __QUERY_SECOND_MAPPING_FLAG__ = false;

				if( __EXEC_TARGET_QUERY__.indexOf("@{") > 0 ) {
					SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);
					__PS_TARGET_QUERY__ = new eMsPreparedStatement(__EXEC_TARGET_QUERY__, "@{", "}");
					__PS_TARGET_QUERY__.connectTo(__TARGET_CONNECTION__);
					__QUERY_SECOND_MAPPING_FLAG__ = true;
				}
				else {
					stmt = __TARGET_CONNECTION__.createStatement();
				}

				// 시작하면서 초기화 rs 정보
				__TMP_HEADER_STRING__ = null;
				int colcount = 0;

				while (BUFFERED_READER.ready()) {
					__TMP_READ_LINE__ = BUFFERED_READER.readLine();

					if (log.isDebugEnabled())
						log.debug(" read => " + __TMP_READ_LINE__);

					// 공백 라인일경우에 스킵
					if( __TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 1 )
						continue;

					if( __QUERY_SECOND_MAPPING_FLAG__ ) {
						this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, __HEADER_MAP__);
						rs = __PS_TARGET_QUERY__.executeQuery(__TMP_SIMPLE_HASH__);
					}
					else {
						if (log.isDebugEnabled())
							log.debug("exec query", __EXEC_TARGET_QUERY__);
						rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
					}




					//액션 인덱스
					int decrypt_index = 0;
					int key_filler_index = 0;

					if( __TMP_HEADER_STRING__ == null ) {
						__TMP_HEADER_STRING__ = rs.getHeaderString();


						// [BY HWANG] 암호화할 필요가 있는 경우인지 확인해서 헤더 세팅 //////////////////////////////////////////
						String [] header_list = StringUtil.split(__TMP_HEADER_STRING__, "|");
						buffer.setLength(0);
						String temp_header = "";

						for(int i1=1; i1<=header_list.length; i1++) {
							temp_header = header_list[i1-1];

							//암호화를 해야하는 플래그를 발견했을 때
							if(temp_header.equals(TMS_M_TOKEN_DECRYPT)){
								//사용할 alias로 수정
								//action>> TMS_M_TOKEN_DECRYPTE ==> TMS_M_TOKEN
								temp_header = "TMS_M_TOKEN";
								decrypt_index = i1;
							}

							/* [BY JOO]
							 * **********************************************
							 * KEY_FILLER
							 * - 실시간 메일에 있는 컬럼으로 내용은 아래와 같다.
							 *
							 * 1. 고객ID
							 * 2. 발송일시
							 * 3. 안내장코드
							 * 4. 개별대표안내ID
							 * 5. 보안/일반 구분(Y/N) : 보안인경우 'Y'
							 * **********************************************
							 *
							 * 데이터에 고객ID와 보안구분이 없기 때문에 이부분을 추가한다.
							 * 삼성생명 전용으로 개발한 부분이다.
							 */
							//KEY_FILLER를 발견했을 때
							if(temp_header.equals(KEY_FILLER)){
								//사용할 alias로 수정
								//action>> TMS_M_TOKEN_DECRYPTE ==> TMS_M_TOKEN
								temp_header = "SSLIFE_ID|EMS_M_SECURE";
								key_filler_index = i1;
							}

							//헤더를 다시 만들어줌
							if(i1!=1){
								buffer.append("|");
							}
							buffer.append(temp_header);
						}
						//신규헤더를 만들어줌.
						if(decrypt_index > 0 || key_filler_index > 0){
							__TMP_HEADER_STRING__ =  buffer.toString();
						}

						// 쿼리들의 헤더를 저장하는 .... 여러번 루틴을 돌기 때문에 한번만 진행을 함..
						buffer.setLength(0);
						buffer.append(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));

						buffer.append("|");
						buffer.append(__TMP_HEADER_STRING__);

						this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());

						if (log.isDebugEnabled()) {
							log.debug("HEADER SETTING : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
						}
					}

					colcount = rs.getColumnCount();

					if( rs.next() ) {

						do {
							BUFFERED_WRITER.write(__TMP_READ_LINE__);
							// 버퍼초기화하고
							buffer.setLength(0);
							String temp = "";

							for (int count = 1; count <= colcount; count++) {
								buffer.append("|");

								//평문의 email이라면 암호화 한다.
								if(decrypt_index==count ){
									temp = CryptoUtil.enEmailAddr(rs.getString(count).trim());
								}else if(key_filler_index==count) { //keyfiller면 sslife_id 와 ems_m_secure 값을 가져온다.
									temp = StringUtil.getKeyFillerValue(rs.getString(count).trim());
								}else{
									temp = rs.getString(count).trim();
								}

								//key_filer 일경우에는 컬럼 확인 필요없이 그냥 넣는다.
								if(key_filler_index==count) {
									buffer.append(temp);
								}else{
									DelimConvertor.encodeToBuffer(buffer, temp);
								}
							}
							BUFFERED_WRITER.write(buffer.toString());
							BUFFERED_WRITER.newLine();
							BUFFERED_WRITER.flush();


						} while (rs.next());
						__APPEND_CHECK__ = true;
					}
					else if( __TARGET_CONNECT_INFO__.isAPPEND_NULL() ) {
						// 결과가 없다면 공백을 채워서 만든다.
						BUFFERED_WRITER.write(__TMP_READ_LINE__);

						for (int count = 1; count <= colcount; count++) {
							BUFFERED_WRITER.write("| ");
						}
						BUFFERED_WRITER.newLine();
						BUFFERED_WRITER.flush();
						__APPEND_CHECK__ = true;
					}
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					if( rs != null){
						rs.close();
					}
				}
				catch(Exception ignore) {
				}
				if( stmt != null ) {
					try {
						stmt.close();

					}
					catch(Exception ignore) {
					}
				}
				if( __PS_TARGET_QUERY__ != null ) {
					try {
						__PS_TARGET_QUERY__.close();
					}
					catch(Exception ignore) {
					}
				}

				try {
					if (__TARGET_CONNECTION__ != null) {
						__TARGET_CONNECTION__.destroy();
					}
				}
				catch(Exception ignore) {
				}

				if( !__APPEND_CHECK__ ) {
					if (log.isDebugEnabled())
						log.debug("NO MAPPING REAULT RECORD so skip => " + this.POST_ID);
					this.deleteWriter();
				}
				else {
					this.closeWriter();
					if (log.isDebugEnabled())
						log.debug("MAPPING STEP CLEAR => " + this.POST_ID);
				}

				this.closeReader();
			}

			if( !__APPEND_CHECK__ ) {
				throw new NoTargetListException("NO MAPPING REAULT RECORD so skip.. => " + this.POST_ID);
			}
		}		// END FOR LOOP
	}

	protected void execute_BlobMappingProcess() throws Exception {
		int __QUERY_SIZE__ = this.VECTOR_QUERY_BLOB_MAPPING_INFO.size();

		if( __QUERY_SIZE__ < 1 ) {
			if (log.isDebugEnabled())
				log.debug("NO BLOB MAPPING QUERY  INFO....");
			return;
		}

		String this_day = Cal.getDayDate();
		// 기본리스트 파일 저장 파일이름 결정
		this.BLOB_MAPPING_INFO_ADDED_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".blob";

		/**
		 * 저장파일을 초기화 한다.
		 */
		log.debug( ".execute_BlobMappingProcess() set spool file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
		openWriter(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);

		log.debug( ".execute_BlobMappingProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
		openReader(this.NEXT_BASE_INFO_FILE_NAME);

		/**
		 * 다음 단계에서 사용할 소스파일을 지정한다.
		 */
		this.NEXT_BASE_INFO_FILE_NAME = this.BLOB_MAPPING_INFO_ADDED_FILE_NAME;

		ConnectInfo __TARGET_CONNECT_INFO__ = null;
		String __EXEC_TARGET_QUERY__ = null;

		boolean __APPEND_CHECK__ = false;

		eMsConnection __TARGET_CONNECTION__ = null;

		eMsStatement stmt = null;
		eMsPreparedStatement __PS_TARGET_QUERY__ = null;

		eMsResultSet rs = null;
		String __TMP_HEADER_STRING__ = null;

		String __TMP_READ_LINE__ = null;

		StringBuffer buffer = new StringBuffer(1024);

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			try {
				if( i > 0 ) {
					/**
					 * 한번 지나간것이라면 읽어오는 소스는 기존에 만들어 놓은 mapping 파일이어야 한다. 그래서 기존에 생성한 mapping 파일을 인덱스를 append한 파일로 옮기고 그 파일을 다시 읽어 들이도록 설정을 한다.
					 */
					log.debug( ".execute_BlobMappingProcess() set switch file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "=>" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "."
							+ String.valueOf(i));
					File rename = new File(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
					File target = new File(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
					/*
					 * 다음 파일이 존재할 경우 삭제
					 */
					if( target.exists() ) {
						try {
							if(target.delete()) {
								log.debug("success delete-target-file");
							}
							else {
								log.debug("failed delete-target-file");
							}
						}
						catch(Exception e) {
							log.error(getName(), e);
						}
					}

					if( rename.renameTo(new File(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i))) ) {
						log.debug( "Rename Success");
					}
					else {
						log.debug( "Rename Fail");
					}

					/**
					 * 기 작업 파일을 옮겼고 같은 파일로 작업파일 지정
					 */
					log.debug( ".execute_BlobMappingProcess() set spool file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);
					openWriter(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME);

					log.debug( ".execute_BlobMappingProcess() set source file :" + this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
					openReader(this.BLOB_MAPPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
				}

				__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_BLOB_MAPPING_INFO.get(i);

				//[현대해상] eMs 커넥션 정보(out_db.properties)와 자동메일(EMS_AUTO_QUERY_INFO) 커넥션정보가 같은지 비교
				//같으면 EMS커넥션 POOL을 이용하여 커넥션을 가져온다.
				//EMS DB 부하 감소!!!!!!!!!!!!!!!!!!!!
				//====================== 로직 시작 ============================

				if(checkConnectionInfo(__TARGET_CONNECT_INFO__ )){
					__TARGET_CONNECTION__ = ConnectionPool.getConnection();
				}else{
					__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
				}

				//====================== 로직  끝  ============================



				log.debug( ".execute_BlobMappingProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
				log.debug( ".execute_BlobMappingProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
				log.debug( ".execute_BlobMappingProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());

				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = buffer.toString();

				boolean __QUERY_SECOND_MAPPING_FLAG__ = false;

				if( __EXEC_TARGET_QUERY__.indexOf("@{") > 0 ) {
					SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);
					__PS_TARGET_QUERY__ = new eMsPreparedStatement(__EXEC_TARGET_QUERY__, "@{", "}");
					__PS_TARGET_QUERY__.connectTo(__TARGET_CONNECTION__);
					__QUERY_SECOND_MAPPING_FLAG__ = true;
				}
				else {
					stmt = __TARGET_CONNECTION__.createStatement();
				}
				// 시작하면서 초기화 rs 정보
				__TMP_HEADER_STRING__ = null;
				//				int patch_count = 0;
				//				int colcount = 0;

				while (BUFFERED_READER.ready()) {
					__TMP_READ_LINE__ = BUFFERED_READER.readLine();

					if (log.isDebugEnabled())
						log.debug(" read => " + __TMP_READ_LINE__);

					// 공백 라인일경우에 스킵
					if( __TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 1 )
						continue;

					if( __QUERY_SECOND_MAPPING_FLAG__ ) {
						this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, __HEADER_MAP__);
						rs = __PS_TARGET_QUERY__.executeQuery(__TMP_SIMPLE_HASH__);
					}
					else {
						if (log.isDebugEnabled())
							log.debug("exec query", __EXEC_TARGET_QUERY__);
						rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
					}

					if( __TMP_HEADER_STRING__ == null ) {
						__TMP_HEADER_STRING__ = rs.getHeaderString();

						// 쿼리들의 헤더를 저장하는 .... 여러번 루틴을 돌기 때문에 한번만 진행을 함..
						buffer.setLength(0);
						buffer.append(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));

						buffer.append("|");
						buffer.append(__TMP_HEADER_STRING__);

						this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());

						if (log.isDebugEnabled())
							log.debug("HEADER SETTING : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
					}

					// colcount = rs.getColumnCount();


					if( rs.next() ) {
						do {
							try {
								buffer.setLength(0);
								DelimConvertor.encodeToBuffer(buffer, rs.getCharStreamAsString(1));
							}
							catch(Exception e) {
								log.error(getName(), e);
								continue;
							}

							BUFFERED_WRITER.write(__TMP_READ_LINE__);
							BUFFERED_WRITER.write("|");
							BUFFERED_WRITER.write(buffer.toString());
							BUFFERED_WRITER.newLine();
							BUFFERED_WRITER.flush();
						} while (rs.next());
						__APPEND_CHECK__ = true;
					}
				}
			}
			catch(Exception e) {
				log.error(getName(), __EXEC_TARGET_QUERY__);
				throw e;
			}
			finally {
				try {
					if( rs != null){
						rs.close();
					}
				}
				catch(Exception ignore) {
				}
				if( stmt != null ) {
					try {
						stmt.close();
					}
					catch(Exception ignore) {
					}
				}
				if( __PS_TARGET_QUERY__ != null ) {
					try {
						__PS_TARGET_QUERY__.close();
					}
					catch(Exception ignore) {
					}
				}

				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}

				if( !__APPEND_CHECK__ ) {
					if (log.isDebugEnabled())
						log.debug("NO MAPPING REAULT RECORD so skip => " + this.POST_ID);
					this.deleteWriter();
				}
				else {
					this.closeWriter();
					if (log.isDebugEnabled())
						log.debug("MAPPING STEP CLEAR => " + this.POST_ID);
				}

				this.closeReader();
			}

			if( !__APPEND_CHECK__ ) {
				throw new NoTargetListException("NO MAPPING REAULT RECORD so skip.. => " + this.POST_ID);
			}
		}
	}

	/**
	 * 기본 회원과 매핑 정보저장 파일을 참조하여 루핑 정보를 추가한 파일을 생성한다.
	 */
	protected void execute_LoopingProcess() throws Exception {
		int __QUERY_SIZE__ = this.VECTOR_QUERY_LOOP_MAPPING_INFO.size();

		if( __QUERY_SIZE__ < 1 ) {
			if (log.isDebugEnabled())
				log.debug("NO LOOPING QUERY INFO....");
			return;
		}

		String this_day = Cal.getDayDate();
		// 기본리스트 파일 저장 파일이름 결정
		this.LOOPING_INFO_ADDED_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".looping";

		/**
		 * 저장파일을 초기화 한다.
		 */
		log.debug( ".execute_LoopingProcess() set spool file :" + this.LOOPING_INFO_ADDED_FILE_NAME);
		openWriter(this.LOOPING_INFO_ADDED_FILE_NAME);

		log.debug( ".execute_LoopingProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
		openReader(this.NEXT_BASE_INFO_FILE_NAME);

		/**
		 * 다음 단계에서 사용할 소스파일을 지정한다.
		 */
		this.NEXT_BASE_INFO_FILE_NAME = this.LOOPING_INFO_ADDED_FILE_NAME;

		ConnectInfo __TARGET_CONNECT_INFO__ = null;
		String __EXEC_TARGET_QUERY__ = null;
		boolean __APPEND_CHECK__ = false;

		eMsConnection __TARGET_CONNECTION__ = null;

		eMsStatement stmt = null;
		eMsPreparedStatement __EMS_PS__ = null;

		eMsResultSet rs = null;

		String __TMP_HEADER_STRING__ = null;

		String __TMP_READ_LINE__ = null;

		StringBuffer buffer = new StringBuffer(1024);

		for (int i = 0; i < __QUERY_SIZE__; i++) {
			try {
				if( i > 0 ) {
					/*
					 * 한번 지나간것이라면 읽어오는 소스는 기존에 만들어 놓은 mapping 파일이어야 한다. 그래서 기존에 생성한 mapping 파일을 인덱스를 append한 파일로 옮기고 그 파일을 다시 읽어 들이도록 설정을 한다.
					 */
					log.debug( ".execute_LoopingProcess() set switch file :" + this.LOOPING_INFO_ADDED_FILE_NAME + "=>" + this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
					File rename = new File(this.LOOPING_INFO_ADDED_FILE_NAME);
					File target = new File(this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));

					/*
					 * 다음 파일이 존재할 경우 삭제
					 */
					if( target.exists() ) {
						try {
							if(target.delete()) {
								log.debug("success delete-target-file");
							}
							else {
								log.debug("failed delete-target-file");
							}
						}
						catch(Exception e) {
							log.error(getName(), e);
						}
					}

					if( rename.renameTo(new File(this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i))) ) {
						if (log.isDebugEnabled())
							log.debug("Rename Success");
					}
					else {
						if (log.isDebugEnabled())
							log.debug("Rename Fail");
					}

					/**
					 * 기 작업 파일을 옮겼고 같은 파일로 작업파일 지정
					 */
					log.debug( ".execute_LoopingProcess() set spool file :" + this.LOOPING_INFO_ADDED_FILE_NAME);
					openWriter(this.LOOPING_INFO_ADDED_FILE_NAME);

					log.debug( ".execute_LoopingProcess() set source file :" + this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
					openReader(this.LOOPING_INFO_ADDED_FILE_NAME + "." + String.valueOf(i));
				}

				__TARGET_CONNECT_INFO__ = this.VECTOR_QUERY_LOOP_MAPPING_INFO.get(i);

				//[현대해상] eMs 커넥션 정보(out_db.properties)와 자동메일(EMS_AUTO_QUERY_INFO) 커넥션정보가 같은지 비교
				//같으면 EMS커넥션 POOL을 이용하여 커넥션을 가져온다.
				//EMS DB 부하 감소!!!!!!!!!!!!!!!!!!!!
				//====================== 로직 시작 ============================

				if(checkConnectionInfo(__TARGET_CONNECT_INFO__ )){
					__TARGET_CONNECTION__ = ConnectionPool.getConnection();
				}else{
					__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);
				}

				//====================== 로직  끝  ============================



				//__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TARGET_CONNECT_INFO__);

				log.debug( ".execute_LoopingProcess() db url :" + __TARGET_CONNECT_INFO__.getDB_URL());
				log.debug( ".execute_LoopingProcess() db id :" + __TARGET_CONNECT_INFO__.getDB_UID());
				log.debug( ".execute_LoopingProcess() db pwd :" + __TARGET_CONNECT_INFO__.getDB_PASS());

				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __TARGET_CONNECT_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				__EXEC_TARGET_QUERY__ = buffer.toString();

				boolean __QUERY_SECOND_MAPPING_FLAG__ = false;

				if( __EXEC_TARGET_QUERY__.indexOf("@{") > 0 ) {
					SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);
					__EMS_PS__ = new eMsPreparedStatement(__EXEC_TARGET_QUERY__, "@{", "}");
					__EMS_PS__.connectTo(__TARGET_CONNECTION__);
					__QUERY_SECOND_MAPPING_FLAG__ = true;
				}
				else {
					stmt = __TARGET_CONNECTION__.createStatement();
				}
				// 시작하면서 초기화 rs 정보
				__TMP_HEADER_STRING__ = null;
				// int patch_count = 0;
				int colcount = 0;

				//
				boolean ONE_LINE_USE = false;
				String  BASE_REAL_ROW = "BASE_REAL_ROW";

				while (BUFFERED_READER.ready()) {
					__TMP_READ_LINE__ = BUFFERED_READER.readLine();

					if (log.isDebugEnabled())
						log.debug( " read => " + __TMP_READ_LINE__);

					// 공백 라인일경우에 스킵
					if( __TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 1 )
						continue;

					if( __QUERY_SECOND_MAPPING_FLAG__ ) {
						this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, __HEADER_MAP__);
						rs = __EMS_PS__.executeQuery(__TMP_SIMPLE_HASH__);
					}
					else {
						if (log.isDebugEnabled())
							log.debug(__EXEC_TARGET_QUERY__);

						rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));

					}

					if( __TMP_HEADER_STRING__ == null ) {
						__TMP_HEADER_STRING__ = rs.getHeaderString();

						//BASE_REAL_ROW 가 있다면 한줄로 가져오는 기능을 사용해야한다.
						if(__TMP_HEADER_STRING__.indexOf(BASE_REAL_ROW)>0){
							ONE_LINE_USE = true;
							log.debug("[ONE_LINE_USE]"+ONE_LINE_USE);
						}

						// 쿼리들의 헤더를 저장하는 .... 여러번 루틴을 돌기 때문에 한번만 진행을 함..
						buffer.setLength(0);
						buffer.append(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));

						buffer.append("[");

						buffer.append(__TMP_HEADER_STRING__);

						buffer.append("]");
						this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());

						if (log.isDebugEnabled())
							log.debug("HEADER SETTING : " + this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
					}

					colcount = rs.getColumnCount();

					//한줄로 가져와서 사용하는 기능을 써야한다.
					boolean isnull_flag = false;
					if(ONE_LINE_USE){
						if( rs.next() ) {
							BUFFERED_WRITER.write(__TMP_READ_LINE__);
							buffer.setLength(0);
							buffer.append("[");
							do {
								buffer.append("{");

								DelimConvertor.encodeToBuffer(buffer, rs.getString(BASE_REAL_ROW).trim());

								buffer.append("}");
							} while (rs.next());
							__APPEND_CHECK__ = true;

							buffer.append("]");

							BUFFERED_WRITER.write(buffer.toString().replaceAll("\\^%\\^", "|"));
//							BUFFERED_WRITER.write(buffer.toString());
							BUFFERED_WRITER.newLine();
							BUFFERED_WRITER.flush();
						}
						else{
							isnull_flag = true;
						}

					}else{

						if( rs.next() ) {
							BUFFERED_WRITER.write(__TMP_READ_LINE__);
							buffer.setLength(0);
							buffer.append("[");
							do {
								buffer.append("{");
								DelimConvertor.encodeToBuffer(buffer, rs.getString(1));
								for (int count = 2; count <= colcount; count++) {
									buffer.append("|");
									DelimConvertor.encodeToBuffer(buffer, rs.getString(count));
								}
								buffer.append("}");
							} while (rs.next());
							__APPEND_CHECK__ = true;

							buffer.append("]");
							BUFFERED_WRITER.write(buffer.toString());
							BUFFERED_WRITER.newLine();
							BUFFERED_WRITER.flush();
						}else{
							isnull_flag = true;
						}
					}

					if( isnull_flag && __TARGET_CONNECT_INFO__.isAPPEND_NULL() ) {
						BUFFERED_WRITER.write(__TMP_READ_LINE__);
						BUFFERED_WRITER.write("[");
						do {
							BUFFERED_WRITER.write("{");
							BUFFERED_WRITER.write(" ");
							for (int count = 2; count <= colcount; count++) {
								BUFFERED_WRITER.write("| ");
							}
							BUFFERED_WRITER.write("}");
						} while (rs.next());

						BUFFERED_WRITER.write("]");
						BUFFERED_WRITER.newLine();
						BUFFERED_WRITER.flush();
						__APPEND_CHECK__ = true;
					}

				}
			}
			catch(Exception e) {
				log.error(getName(), "==>" + __EXEC_TARGET_QUERY__);
				if( !__APPEND_CHECK__ ) {
					this.deleteWriter();
				}
				else {
					this.closeWriter();
					if (log.isDebugEnabled())
						log.debug("LOOPING STEP CLEAR => " + this.POST_ID);
				}
				throw e;
			}
			finally {
				try {
					if( rs != null){
						rs.close();
					}
				}
				catch(Exception ignore) {
				}
				if( stmt != null ) {
					try {
						stmt.close();
					}
					catch(Exception ignore) {
					}
				}
				if( __EMS_PS__ != null ) {
					try {
						__EMS_PS__.close();
					}
					catch(Exception ignore) {
					}
				}
				try {
					__TARGET_CONNECTION__.destroy();
				}
				catch(Exception ignore) {
				}

				this.closeReader();
			}

			if( !__APPEND_CHECK__ ) {
				this.deleteWriter();
				throw new NoTargetListException("NO LOOPING REAULT RECORD so skip.. => " + this.POST_ID);
			}
			this.closeWriter();
			if (log.isDebugEnabled())
				log.debug("LOOPING STEP CLEAR => " + this.POST_ID);
		}
	}

	/**
	 * 기본 회원과 매핑 정보저장 파일을 참조하여 루핑 정보를 추가한 파일을 생성한다. step : LOOP_OK 에서 실행 된다.
	 */
	protected void execute_DBInsertProcess() throws Exception {
		List<Map<String, String>> filterList = new ArrayList<Map<String, String>>();
		String workId = Cal.getSerialDate();
		this.SCHEDULE_INFO.setProperty("WORK_ID", workId);

		// 기본리스트 파일 저장 파일이름 결정
		this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, Cal.getDayDate()) + "/" + this.WORK_FILE_ID + ".infoadd";

		// 저장파일을 초기화 한다.
		if (log.isDebugEnabled()) {
			log.debug(".execute_DBInsertProcess() set spool file: {}", this.INFO_ADDED_FINAL_FILE_NAME);
		}

		openWriter(this.INFO_ADDED_FINAL_FILE_NAME);

		if (log.isDebugEnabled()) {
			log.debug(".execute_DBInsertProcess() set source file: {}", this.NEXT_BASE_INFO_FILE_NAME);
		}

		openReader(this.NEXT_BASE_INFO_FILE_NAME);

		// 다음 단계에서 사용할 소스파일을 지정한다.
		this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;

		eMsConnection emsConnection = null;

		eMsStatement stmtFatigueInfo = null;

		eMsPreparedStatement psFatigueInsertOrUpdateMonthList = null;
		eMsPreparedStatement psFatigueInsertOrUpdateDayList = null;
		eMsPreparedStatement psSendListInsert = null;
		eMsPreparedStatement psSelectNextSeq = null;

		eMsResultSet rsFatigueInfo = null;
		eMsResultSet rsNextSeq = null;

		String tmpReadLine = null;

		StringBuffer buffer = new StringBuffer(1024);

		log.debug(".execute_DBInsertProcess() in SCHEDULE_INFO: {}", SCHEDULE_INFO);

		try {

			emsConnection = ConnectionPool.getConnection();

			/*
			 * 피로도를 사용하는 수시발송건이 아닌지 체크
			 * 수시발송 피로도 체크는 배치에서 처리하도록 구성
			 * 나머지 발송유형에 대해서는 현재 로직에서 피로도 체크
			 */
			String channel = SCHEDULE_INFO.getProperty("CHANNEL_TYPE");
			if(channel == null || "".equals(channel) ){
				channel = SCHEDULE_INFO.getProperty("CHANNEL");
			}
			log.info("SCHEDULE_INFO : {}", SCHEDULE_INFO);
			String fatigueDayTableName = getFatigueListTableName(channel,"DAY");
			String fatigueMonthTableName = getFatigueListTableName(channel,"MONTH");
			boolean isFatigue = isUseFatigue();
			if ("Y".equals(FATIGUE_USE_YN)) {
				if (isFatigue) {
					stmtFatigueInfo = emsConnection.createStatement();

					buffer.setLength(0);
					StringConvertUtil.ConvertString(buffer, querySelectFatigueInfo, this.SCHEDULE_INFO, "${", "}", true, false);
					rsFatigueInfo = stmtFatigueInfo.executeQuery(buffer.toString());

					if (rsFatigueInfo.next()) {
						fatigueDayLimitCount = rsFatigueInfo.getInt("DAY_LIMIT");
						fatigueMonthLimitCount = rsFatigueInfo.getInt("MON_LIMIT");
					}

					buffer.setLength(0);
					StringConvertUtil.ConvertString(buffer, querySelectMemberFatigueCount.replace("${FATIGUE_DAY_TABLE}", fatigueDayTableName)
							.replace("${FATIGUE_MONTH_TABLE}", fatigueMonthTableName), this.SCHEDULE_INFO, "${", "}", true, false);

					psMemberFatigueCount = new eMsPreparedStatement(buffer.toString(), "@{", "}");
					psMemberFatigueCount.connectTo(emsConnection);
				}

				// 피로도 발송건수 처리
				if(!this.SCHEDULE_INFO.get("CYCLE_TYPE").equals("99")){
					buffer.setLength(0);
					this.SCHEDULE_INFO.setProperty("FATIGUE_DATE", this.SCHEDULE_INFO.getProperty("WORKDAY"));
					this.SCHEDULE_INFO.setProperty("FATIGUE_CNT",  String.valueOf(fatigueDayLimitCount));
					StringConvertUtil.ConvertString(buffer, queryInsertOrUpdateFatigueList.replace("${FATIGUE_TABLE}", fatigueDayTableName), this.SCHEDULE_INFO, "${", "}", true, false);
					psFatigueInsertOrUpdateDayList = new eMsPreparedStatement(buffer.toString(), "@{", "}");
					psFatigueInsertOrUpdateDayList.connectTo(emsConnection);
		
					// 피로도 발송건수 처리
					buffer.setLength(0);
					this.SCHEDULE_INFO.setProperty("FATIGUE_DATE", this.SCHEDULE_INFO.getProperty("WORKDAY").substring(0,6));
					this.SCHEDULE_INFO.setProperty("FATIGUE_CNT", String.valueOf(fatigueMonthLimitCount));
					StringConvertUtil.ConvertString(buffer, queryInsertOrUpdateFatigueList.replace("${FATIGUE_TABLE}", fatigueMonthTableName), this.SCHEDULE_INFO, "${", "}", true, false);
					psFatigueInsertOrUpdateMonthList = new eMsPreparedStatement(buffer.toString(), "@{", "}");
					psFatigueInsertOrUpdateMonthList.connectTo(emsConnection);

				}
			}

			
			// 발송 리스트 테이블에 저장하는 쿼리
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_INSERT_SCHEDULED_SEND_LIST, this.SCHEDULE_INFO, "${", "}", true, false);
			psSendListInsert = new eMsPreparedStatement(buffer.toString(), "@{", "}");
			psSendListInsert.connectTo(emsConnection);

			// 존재하는 멤버아이디가 있을때 다음 SEQ 값을 찾기 위한 쿼리
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE, this.SCHEDULE_INFO, "${", "}", true, false);
			psSelectNextSeq = new eMsPreparedStatement(buffer.toString(), "@{", "}");
			psSelectNextSeq.connectTo(emsConnection);

			SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);

			log.debug("Souce File Read Ready");
			boolean checkUpserFatigue = true;
			while (BUFFERED_READER.ready()) {
				tmpReadLine = BUFFERED_READER.readLine();

				if (log.isDebugEnabled()) {
					log.debug("read => {}", tmpReadLine);
				}

				if (tmpReadLine == null || tmpReadLine.trim().length() < 1) continue;

				try {
					this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, tmpReadLine, __HEADER_MAP__);
				} catch(Exception e) {
					log.error(getName() + " ID/NAME/EMAIL POPUP FAIL => " + tmpReadLine, e);
					continue;
				}

				String mapping = null;
				if (tmpReadLine.length() > MAPPING_LIMIT) {
					mapping = StoreLongMapping(this.WORKDAY, this.SEQNO, tmpReadLine);
				} else {
					mapping = tmpReadLine;
				}

				if (mapping == null) {
					log.error(getName() + " Mapping is null Or Store Filename is NULL.... so skip=>" + tmpReadLine);
					continue;
				}

				// 맵에 매핑 데이터 넣어야 한다.
				__TMP_SIMPLE_HASH__.put("MAPPING", mapping);
				if( !__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID_SEQ") ) {
					__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ", UniqueKey.getSerial());
				}

				// Work ID 추가
				__TMP_SIMPLE_HASH__.put("WORK_ID", workId);


				/*
				 * By jinkwon
				 *
				 * EMS에 EMS_M_ID, EMS_M_NAME, EMS_M_EMAIL
				 * TMS에 TMS_M_ID, TMS_M_NAME, TMS_M_TOKEN
				 *
				 * 추후 마이그레이션 시 혼동을 최소화하기 위해 이전 alias 도 처리 되도록 변경
				 */
				String channelType = this.SCHEDULE_INFO.getProperty(CommonColumn.CHANNEL_TYPE.getCode(), ChannelType.EMAIL.getCode());

				getMemberToken(channelType, __TMP_SIMPLE_HASH__);

				boolean noSend = false;


				String email = __TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode());
				if( ChannelType.EMAIL.getCode().equals(channelType) ){
					// 자동메일 암호화된 대상자정보 처리
					if( "Y".equals(this.VECTOR_QUERY_LIST_INFO.get(0).getENCRYPT_YN()) || email.indexOf('@') < 0 ){
						try {
							email = HumusonDecryptor.decrypt(__TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode()), encKey, false);
						} catch (Exception e) {
							log.error("email decrypt error [{}] msg:{}", email, e.getMessage());
						}
					}
					noSend = StringUtils.isEmailError(email);
				} else if( ChannelType.SMS.getCode().equals(channelType) ){
					// 자동문자 암호화된 대상자정보 처리
					if( "Y".equals(this.VECTOR_QUERY_LIST_INFO.get(0).getENCRYPT_YN())){
						try {
							email = HumusonDecryptor.decrypt(__TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode()), encKey, false);
						} catch (Exception e) {
							log.error("sms decrypt error [{}] msg:{}", email, e.getMessage());
						}
					}
				}

				__TMP_SIMPLE_HASH__.put("DOMAIN", StringUtils.getDomain(email) );


//				__TMP_SIMPLE_HASH__.put("DOMAIN", StringUtil.getDomain(__TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode())));

				// 이메일주소 seed 암호화 시작
				// 개인정보 암호화
				String oriVal = "";
				String encVal = "";
				try {

					// 고객정보(이메일/휴대전화번호)가 암호화 안되어있있고, SendConf 사용자암호화플래그 Y이고, 대상DB암호화여부 N일때 암호화 적용
					if (__TMP_SIMPLE_HASH__.containsKey(CommonColumn.TMS_M_TOKEN.getCode()) && "Y".equals(MEMBER_INFO_ENCRYPT_YN) && !"Y".equals(this.VECTOR_QUERY_LIST_INFO.get(0).getENCRYPT_YN()) ) {
						oriVal = __TMP_SIMPLE_HASH__.get(CommonColumn.TMS_M_TOKEN.getCode());

						if (oriVal != null && !"".equals(oriVal)) {
							encVal = CryptoUtil.enEmailAddr(oriVal.trim());
						}

						__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), encVal);
					}

				} catch(Exception e) {
					log.error(getName() + " email encrypt fail ==> " + oriVal, e);
				}

				// 리스트 테이블 입력시 기본값은 'NY'로 입력
				__TMP_SIMPLE_HASH__.put(CommonColumn.SEND_STATE.getCode(), "NY");

				// 피로도 필터링 대상자인지 체크
				if ("Y".equals(FATIGUE_USE_YN) && isFatigue && !this.SCHEDULE_INFO.getProperty("CYCLE_TYPE").equals("99")) {
					checkUpserFatigue = checkFatigue();
				}

				log.debug("__TMP_SIMPLE_HASH__... {}", __TMP_SIMPLE_HASH__);
				
				//푸시채널 전환 발송 체크일 경우 전화번호 암호화.
				if (ChannelType.PUSH.getCode().equals(SCHEDULE_INFO.getProperty("CHANNEL_TYPE"))) {
					String switchYn = this.SCHEDULE_INFO.getProperty("SWITCH_YN", "N");
					if (!"N".equals(switchYn) && !StringUtils.isNull(__TMP_SIMPLE_HASH__.get("TMS_M_PHONE"))) {
						String toNumber = __TMP_SIMPLE_HASH__.get("TMS_M_PHONE");
						if ("Y".equals(MEMBER_INFO_ENCRYPT_YN) && !"Y".equals(this.VECTOR_QUERY_LIST_INFO.get(0).getENCRYPT_YN())) {
							toNumber = HumusonEncryptor.encrypt(toNumber, encKey, false);
						}
						__TMP_SIMPLE_HASH__.put("TMS_M_PHONE", toNumber);
					}
				}
				int insertCnt = 0;
				try {
					if(noSend) {
						BUFFERED_WRITER.write("NO-EMAIL"); //PASS 된 것은 SEQ 입력없이 파일에 NO-EMAIL 기록
						log.error(getName(), "NO EMAIL PASS : " + email);
						
						//푸시 전환 발송일경우
						if (ChannelType.PUSH.getCode().equals(SCHEDULE_INFO.getProperty("CHANNEL_TYPE"))
								&&  !"N".equals(this.SCHEDULE_INFO.getProperty("SWITCH_YN", "N"))) {
							__TMP_SIMPLE_HASH__.put(CommonColumn.SEND_STATE.getCode(), "00");
							Map<String, String> map = new HashMap<String,String>();
							map.putAll(__TMP_SIMPLE_HASH__);
							filterList.add(map);	
						}
					} else {
						try {
							insertCnt = psSendListInsert.executeUpdate(__TMP_SIMPLE_HASH__);
							if (insertCnt < 1) {
								System.out.println("__TMP_SIMPLE_HASH__: " + __TMP_SIMPLE_HASH__.toString());
								log.error(getName(), "INSERT AFFECT 0");
							}
						} catch(SQLException dup) {
							// 키중복을 의심하고 TMS_M_ID_SEQ 를 다시 얻어 기록시도한다.
							String nextMemberSeq = "";
							try {

								rsNextSeq = psSelectNextSeq.executeQuery(__TMP_SIMPLE_HASH__);

								if (rsNextSeq.next()) {
									nextMemberSeq = rsNextSeq.getString(1) == null ? "" : rsNextSeq.getString(1);
								}

								if (!"".equals(nextMemberSeq)) {
									__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ", nextMemberSeq);
									insertCnt = psSendListInsert.executeUpdate(__TMP_SIMPLE_HASH__);
									if (insertCnt < 1) {
										log.error(getName(), "INSERT AFFECT 0");
									}
								}

							} catch(Exception e) {
								log.error(getName() + " MAX SEQ SELECT FAIL....so skip..", e);
							} finally {
								if (rsNextSeq != null) rsNextSeq.close();
							}
						}
						
						//푸시전환발송인경우 인서트된게 하나도 없으면. 결과 연동을위해 실패로 센드리스트에 인서트
						if (insertCnt < 1) {
							if (ChannelType.PUSH.getCode().equals(SCHEDULE_INFO.getProperty("CHANNEL_TYPE"))
									&&  !"N".equals(this.SCHEDULE_INFO.getProperty("SWITCH_YN", "N"))) {
								__TMP_SIMPLE_HASH__.put(CommonColumn.SEND_STATE.getCode(), "00");
								Map<String, String> map = new HashMap<String,String>();
								map.putAll(__TMP_SIMPLE_HASH__);
								filterList.add(map);	
							}
						}
						BUFFERED_WRITER.write(__TMP_SIMPLE_HASH__.get("TMS_M_ID_SEQ").toString());
					}

					//BUFFERED_WRITER.write(__TMP_SIMPLE_HASH__.get("TMS_M_ID_SEQ").toString());
					BUFFERED_WRITER.write("|");
					BUFFERED_WRITER.write(tmpReadLine);

					BUFFERED_WRITER.newLine();
					BUFFERED_WRITER.flush();

					// 수시발송 피로도를 사용하는 캠페인은 배치엔진에서 피로도 발송건수를 올려줌
					// => 자동은 모두 엔진에서 처리.
					// 나머지 캠페인 피로도 발송건수 올리기
//					if (!isOftenSendingFilter()) {
						// 리스트 테이블에도 정상적으로 넣고 파일에도 정상적으로 썼을 경우 피로도 발송건수 올리기
					log.debug("checkUpserFatigue : {}",checkUpserFatigue);
					
					if ("Y".equals(FATIGUE_USE_YN)) {
						if(checkUpserFatigue && !this.SCHEDULE_INFO.getProperty("CYCLE_TYPE").equals("99")){
							if (psFatigueInsertOrUpdateMonthList.executeUpdate(__TMP_SIMPLE_HASH__) < 1) {
								log.error(getName(), "TMS_FATIGUE_LIST not inserted or updated. [ " + __TMP_SIMPLE_HASH__ + " ]");
							}
							if (psFatigueInsertOrUpdateDayList.executeUpdate(__TMP_SIMPLE_HASH__) < 1) {
								log.error(getName(), "TMS_FATIGUE_LIST not inserted or updated. [ " + __TMP_SIMPLE_HASH__ + " ]");
							}
						}
					}

//					}
				} catch(Exception ignore) {
					log.error(getName(), "INSERT RETRY ERR.. so skip.", ignore);
					continue;
				}
			}

			if (filterList.size() > 0) {
				FilterUtils utils = new FilterUtils();
				List<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
				for (int i=0; i<filterList.size(); i++) {
					dataList.add(filterList.get(i));
					if (dataList.size() % 1000 == 0) {
						utils.procFilterResult(dataList, this.SCHEDULE_INFO);
						dataList.clear();
					}
				}
				if (dataList.size() > 0 ) {
					utils.procFilterResult(dataList, this.SCHEDULE_INFO);
					dataList.clear();
				}
				
				filterList.clear();
			}
			log.debug("Souce File Read Done");

		} catch(Exception e) {
			log.error(getName(), e);
			throw e;
		} finally {

			// 자원 해제
			if (rsFatigueInfo != null) rsFatigueInfo.close();
			if (stmtFatigueInfo != null) stmtFatigueInfo.close();
			if (psFatigueInsertOrUpdateMonthList != null) psFatigueInsertOrUpdateMonthList.close();
			if (psFatigueInsertOrUpdateDayList != null) psFatigueInsertOrUpdateDayList.close();
			if (psSelectNextSeq != null) psSelectNextSeq.close();
			if (psSendListInsert != null) psSendListInsert.close();
			if (emsConnection != null) emsConnection.recycle();

			if (BUFFERED_READER != null) try { BUFFERED_READER.close(); } catch(Exception e) {}

			if (BUFFERED_WRITER != null) {
				try {
					BUFFERED_WRITER.flush();
					BUFFERED_WRITER.close();
				} catch(Exception e) {}
			}

			log.debug("Exit Souce File Read Routine");
		}

		// 스케쥴 테이블에 건수 업데이트 처리
		exec_CountUpdate();
	}

	protected void exec_CountUpdate() throws Exception {
		// 구성된 리스트의 카운트를 업데이트 한다.
		eMsConnection emsConnection = null;
		eMsStatement emsStmt = null;
		eMsResultSet emsRs = null;

		StringBuffer buffer = new StringBuffer(512);

		try {
			emsConnection = ConnectionPool.getConnection();
			emsStmt = emsConnection.createStatement();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_SELECT_TARGET_CNT, this.SCHEDULE_INFO, "${", "}", true, false);
			emsRs = emsStmt.executeQuery(buffer.toString(), 3600);

			if (emsRs.next()) {
				emsRs.putToMap(this.SCHEDULE_INFO, false);
			} else {
				throw new RuntimeException("Target Cnt Select Error");
			}

			// 필터링된 건수 설정
			this.SCHEDULE_INFO.setProperty(CommonColumn.FILTER_CNT.getCode(), String.valueOf(fatigueFilteredCount));

			log.debug("exec_CountUpdate() in SCHEDULE_INFO: {}", SCHEDULE_INFO);

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE, this.SCHEDULE_INFO, "${", "}", true, false);

			log.debug("exec_CountUpdate() in QUERY_UPDATE_TARGET_CNT_TO_SCHEDULE_TABLE: {}", buffer.toString());

			emsStmt.executeUpdate(buffer.toString());
		} catch(Exception e) {
			throw e;
		} finally {
			if (emsRs != null) {
				emsRs.close();
			}
			if (emsConnection != null) {
				if (emsStmt != null) {
					emsConnection.recycleStatement(emsStmt);
				}
				emsConnection.recycle();
			}
		}
	}

	/**
	 * 업데이트 or 기타 실행 쿼리를 실행한다.
	 */
	protected void execute_FinalProcess() throws Exception {
		int updateQuerySize = this.VECTOR_QUERY_UPDATE_INFO.size();

		if (updateQuerySize < 1) {
			// 중복발송방지 추가 실시간검색일 경우 업데이트쿼리가 없을 경우 실패처리함.
			if (AutoSendType.SEARCH_OF_REALTIME.getCode().equals(this.SCHEDULE_INFO.getProperty(CommonColumn.CYCLE_TYPE.getCode(),""))) {
				updateErrorList(this.SCHEDULE_INFO);
			} else {
				// 위 작업이 오류 없이 완료되었을 때만 아래의 업데이트를 수행함으로써
				// 실제 각 리스트가 발송 가능상태가 된다.
				updateSendListStatus();
			}

			if (log.isDebugEnabled())
				log.debug("NO UPDATE QUERY INFO....");
			return;
		}

		eMsConnection emsConnection = null;
		eMsStatement emsStmt = null;
		eMsPreparedStatement emsPs = null;

		ConnectInfo targetConnectInfo = null;

		String targetQuery = null;
		String readLine = null;

		StringBuffer buffer = new StringBuffer(512);

		SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);

		for (int i = 0; i < updateQuerySize; i++) {
			try {

				log.debug(".execute_FinalProcess() set source file : {}", this.NEXT_BASE_INFO_FILE_NAME);

				openReader(this.NEXT_BASE_INFO_FILE_NAME);

				targetConnectInfo = this.VECTOR_QUERY_UPDATE_INFO.get(i);

				//[현대해상] eMs 커넥션 정보(out_db.properties)와 자동메일(EMS_AUTO_QUERY_INFO) 커넥션정보가 같은지 비교
				//같으면 EMS커넥션 POOL을 이용하여 커넥션을 가져온다.
				//EMS DB 부하 감소!!!!!!!!!!!!!!!!!!!!
				//====================== 로직 시작 ============================

				if (checkConnectionInfo(targetConnectInfo)) {
					emsConnection = ConnectionPool.getConnection();
				} else {
					emsConnection = ConnectionPool.getConnection(targetConnectInfo);
				}
				//====================== 로직  끝  ============================

				emsStmt = emsConnection.createStatement();

				log.debug(".execute_FinalProcess() db url: {}", targetConnectInfo.toString());

				// eMsPreparedStatement를 사용할때는 내부에서 전환을 하기때문에 여기서는 변환없이 원문을 보존한다.
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, targetConnectInfo.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
				targetQuery = buffer.toString();

				boolean isSecondMapping = false;

				if (targetQuery.indexOf("@{") > 0) {
					SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);
					emsPs = new eMsPreparedStatement(targetQuery, "@{", "}");
					emsPs.connectTo(emsConnection);

					isSecondMapping = true;
				} else {
					emsStmt = emsConnection.createStatement();
				}

				String mIdSeq = null;
				String mapping = null;

				int idx1 = 0;
				while (BUFFERED_READER.ready()) {
					readLine = BUFFERED_READER.readLine();

					if (log.isDebugEnabled())
						log.debug("read => {}", readLine);

					// 공백 라인일경우에 스킵
					if (readLine == null || readLine.trim().length() < 1) continue;

					// 회원 seq를 추출
					idx1 = readLine.indexOf("|");

					if (idx1 < 0) {
						if (log.isDebugEnabled())
							log.debug("invalid spool ... so skip => {}", readLine);
						continue;
					}

					mIdSeq = readLine.substring(0, idx1);
					mapping = readLine.substring(idx1 + 1);

					try {

						int update_count = -1;

						if (isSecondMapping) {
							this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, mapping, __HEADER_MAP__);
							// 기본정보를 세팅한다.

							__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ", mIdSeq);
							__TMP_SIMPLE_HASH__.put("WORKDAY", this.WORKDAY);
							__TMP_SIMPLE_HASH__.put("SEQNO", this.SEQNO);

							update_count = emsPs.executeUpdate(__TMP_SIMPLE_HASH__);
						} else {
							// @ 개인매핑이 없으니까 그냥 쿼리 날리기
							update_count = emsStmt.executeUpdate(emsConnection.encode(targetQuery));
						}

						if (update_count < 1) {
							if (log.isDebugEnabled())
								log.debug("Final Process Update fail => {}", readLine);

							updateErrorList(this.SCHEDULE_INFO);
						}
					} catch(Exception e) {
						log.error(getName() + " Final Process Fail sql =>" + targetQuery, e);

						// 이로써 Error List 를 업데이트하다가 Exception 이 떨어졌다면 재시도를 하고 역시, Exception 이
						// 난다면 상위로 Exception 을 올리게 된다.
						updateErrorList(this.SCHEDULE_INFO);

						// 업데이트에 대한 오류가 한건이라도 발생하면 기존과 다르게 상위로 Exception 을 올린다.
						throw e;
					}
				}
			} catch(Exception e) {
				log.error(getName() + " ==> " + targetQuery, e);

				// 타겟쿼리 자체가 잘못되었을경우 가져온녀석은 아예 발송하면 안된다.
				updateErrorList(this.SCHEDULE_INFO);

				throw e;
			} finally {
				if (emsStmt != null) try { emsStmt.close(); } catch(Exception ignore) {}
				if (emsPs != null) try { emsPs.close(); } catch(Exception ignore) {}

				try {
					if (emsConnection != null) {
						emsConnection.destroy();
					}
				} catch(Exception ignore) {}
			}
		}

		// 위 작업이 오류 없이 완료되었을 때만 아래의 업데이트를 수행함으로써
		// 실제 각 리스트가 발송 가능상태가 된다.
		updateSendListStatus();
	}

	/**
	 * 컬럼에 너무 큰값은 안들어가기 때문에... 파일로 저장하는 곳.
	 */
	protected String StoreLongMapping(String __WORKDAY__, String __SEQNO__, String __MAPPING__) throws Exception {
		if( __INNER_LONG_MAPPING_SPOOLER__ == null ) {
			__INNER_LONG_MAPPING_SPOOLER__ = new LongMappingSpooler(__WORKDAY__.concat("_").concat(__SEQNO__).concat(".mapping"));
		}

		return __INNER_LONG_MAPPING_SPOOLER__.put(__MAPPING__);
	}

	@Override
	public Object getTargetList() {
		throw new RuntimeException("Not Implements");
	}

	@Override
	public String getMAPPING_HEADER() {
		return this.MAPPING_HEADER;
	}

	// AUTO 100의 WORKDAY + SEQNO 를 return 한다.
	@Override
	public String getID() {
		return (this.WORKDAY == null) ? null : (this.WORKDAY + "_" + this.SEQNO);
	}

	protected void deleteCurrentList() throws Exception {
		eMsConnection emsConnection = null;
		eMsStatement emsStmt = null;

		StringBuffer buffer = new StringBuffer(512);

		try {

			emsConnection = ConnectionPool.getConnection();
			emsStmt = emsConnection.createStatement();

			StringConvertUtil.ConvertString(buffer, QUERY_DELETE_CURRENT_LIST, this.SCHEDULE_INFO, "${", "}", true, false);
			/**
			 * 리스트를 데이터 베이스에 전송하기전 기존 리스트를 삭제한다.
			 */
			log.debug("DELETE CURRENT LIST START exec query => {}", buffer.toString());

			emsStmt.executeUpdate(buffer.toString(), -1);
		} catch(Exception e) {
			log.error(getName(), e);
			throw e;
		} finally {
			if (emsConnection != null) {
				if (emsStmt != null) {
					emsConnection.recycleStatement(emsStmt);
				}
				emsConnection.recycle();
			}
		}
	}

	protected void updateTaskState(String state) throws Exception {
		// 상태값 업데이트
		synchronized (this.composer.getLock()) {

			this.composer.setProperty(LOG_SEND_TYPE, "SYSTEM");
			this.composer.setProperty(LOG_T_TYPE, "41");
			this.composer.setProperty(LOG_T_CODE, state);
			this.composer.setProperty(LOG_MAIL_ID, this.POST_ID);
			this.composer.setProperty(LOG_MEMBER_ID, "noid");
			this.composer.setProperty(LOG_STEP, "0");
			this.composer.setProperty(LOG_T_DATE, Cal.getDate());
			this.composer.setProperty(LOG_MX_RECORD, "");
			this.composer.setProperty(LOG_DELAY, "");
			this.composer.setProperty(LOG_TOKEN_ID, "noemail");
			this.composer.setProperty(LOG_DOMAIN, "");
			this.composer.setProperty(LOG_WORKER, getName());
			this.composer.setProperty(LOG_ETC_LOG, "MakeInfoStart");
			this.composer.setProperty(LOG_LIST_TABLE, "n");

			SmtpLogger.put(this.composer);
		}

		this.SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", state);

		eMsConnection emsConnection = null;
		eMsStatement emsStmt = null;

		StringBuffer buffer = new StringBuffer(512);

		try {

			emsConnection = ConnectionPool.getConnection();
			emsStmt = emsConnection.createStatement();

			// StringConvertUtil을사용하는 로직으로 변경 2004.11.02
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_STATE_INFO, this.SCHEDULE_INFO, "${", "}", true, false);

			if (log.isDebugEnabled())
				log.debug("exec => {}", buffer.toString());

			emsStmt.executeUpdate(buffer.toString());
		} catch(Exception ignore) {
			log.error(getName(), ignore);
			throw ignore;
		} finally {
			if (emsConnection != null) {
				if (emsStmt != null) {
					emsConnection.recycleStatement(emsStmt);
				}
				emsConnection.recycle();
			}
		}
	}

	protected void updateSendListStatus() throws Exception {

		eMsConnection emsConnection = null;
		eMsStatement emsStmt = null;

		StringBuffer buffer = new StringBuffer(512);

		try {

			emsConnection = ConnectionPool.getConnection();
			emsStmt = emsConnection.createStatement();

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_SCHEDULED_SEND_LIST, this.SCHEDULE_INFO, "${", "}", true, false);

			if (log.isDebugEnabled())
				log.debug("QUERY_UPDATE_SCHEDULED_SEND_LIST => {}", buffer.toString());

			emsStmt.executeUpdate(buffer.toString());
		} catch(Exception ignore) {
			log.error(getName(), ignore);
			throw ignore;
		} finally {
			if (emsConnection != null) {
				if (emsStmt != null) {
					emsConnection.recycleStatement(emsStmt);
				}
				emsConnection.recycle();
			}
		}
	}

	@Override
	protected void releaseResource() {

		if (psMemberFatigueCount != null) psMemberFatigueCount.close();

		super.releaseResource();
		destroy();
	}

	// 자동메일에 등록된 쿼리의 커넥션 정보와 ems 커넥션 정보가 같은지 비교한다.
	// 같으면 true , 다르면 false 를 리턴한다.
	protected boolean checkConnectionInfo(ConnectInfo targetConnInfo) throws Exception {
		if (EMS_DB_URL.equals(targetConnInfo.getDB_URL())
				&& EMS_DB_ID.equals(targetConnInfo.getDB_UID())
				&& EMS_DB_PWD.equals(targetConnInfo.getDB_PASS())) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * 리스트 생성중에 임시로 만든 파일등을 정리하는 로직
	 */
	@Override
	public void destroy() {
		if (this.AUTO_KEY_VALUE_PARSER != null) {
			this.AUTO_KEY_VALUE_PARSER.destroy();
			this.AUTO_KEY_VALUE_PARSER = null;
		}
	}

	@Override
	protected void finalize() throws Throwable {
		destroy();
	}

	protected void updateErrorList(Properties scheduleInfo) throws Exception {
		// 하위클래스에서 구현한다.
		eMsConnection emsConnection = null;
		eMsStatement emsStmt = null;

		try {

			emsConnection = ConnectionPool.getConnection();
			emsStmt = emsConnection.createStatement();

			StringBuffer buffer = new StringBuffer(512);
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_SCHEDULED_ERROR, scheduleInfo, "${", "}", true, false );
			emsStmt.executeUpdate(buffer.toString());

			//실시간일때에만 해당종에 대해 사용여부 F로 변경
			if (AutoSendType.SEARCH_OF_REALTIME.getCode().equals(scheduleInfo.getProperty(CommonColumn.CYCLE_TYPE.getCode(),""))) {
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_MSG_ERROR, scheduleInfo, "${", "}", true, false);
				emsStmt.executeUpdate(buffer.toString());
			}
		} finally {
			if (emsConnection != null) {
				if (emsStmt != null) {
					emsConnection.recycleStatement(emsStmt);
				}
				emsConnection.recycle();
			}
		}
	}

	protected void updateAllErrorList() throws Exception {
		// 하위클래스에서 구현한다.
	}

	// 발송 채널에 따라 입력되는 필수 항목에 대해 공통 처리 로직 추가
	private void getMemberToken(String channelType, Map<String, String> tmpSimpleHash) throws Exception {
		if (ChannelType.EMAIL.getCode().equals(channelType)) {
			if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_EMAIL.getCode())) {
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_EMAIL.getCode()));
			} else if (tmpSimpleHash.containsKey(CommonColumn.TMS_M_EMAIL.getCode())) {
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.TMS_M_EMAIL.getCode()));
			} //TMS_M_TOKEN 인 경우는 동일 값으로 들어오기 때문에 제외
		} else if (ChannelType.SMS.getCode().equals(channelType)
				|| ChannelType.SMART_SMS.getCode().equals(channelType)
				|| ChannelType.KAKAO.getCode().equals(channelType)) {
			if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_PHONE.getCode())) {
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_PHONE.getCode()));
			} else if (tmpSimpleHash.containsKey(CommonColumn.TMS_M_PHONE.getCode())) {
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.TMS_M_PHONE.getCode()));
			}
		} else if (ChannelType.PUSH.getCode().equals(channelType)) {
			if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_TOKEN.getCode())) {
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_TOKEN.getCode()));
			} else if (tmpSimpleHash.containsKey(CommonColumn.EMS_M_PUSH.getCode())) {
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_PUSH.getCode()));
			}
		} else {
			if(tmpSimpleHash.containsKey(CommonColumn.EMS_M_TOKEN.getCode())){
				this.__TMP_SIMPLE_HASH__.put(CommonColumn.TMS_M_TOKEN.getCode(), tmpSimpleHash.get(CommonColumn.EMS_M_TOKEN.getCode()));
			}
		}
	}

	// 수시 발송 피로도 체크는 배치쪽에서 처리
	private boolean isOftenSendingFilter() {
		return "Y".equals(this.SCHEDULE_INFO.getProperty(CommonColumn.FILTER_USE_YN.getCode(),"N"))
				&& AutoSendType.OFTEN_SENDING.getCode().equals(this.SCHEDULE_INFO.getProperty(CommonColumn.CYCLE_TYPE.getCode(),""));
	}

	// 수시발송을 제외한 발송유형 중 피로도 체크 여부 판단
	private boolean isUseFatigue() throws Exception {
		return "Y".equals(this.SCHEDULE_INFO.getProperty(CommonColumn.FILTER_USE_YN.getCode(),"N"));
//		&& !AutoSendType.OFTEN_SENDING.getCode().equals(this.SCHEDULE_INFO.getProperty(CommonColumn.CYCLE_TYPE.getCode(),"")
	}

	// 발송 대상자가 피로도에 필터되는 대상자인지 체크
	private boolean checkFatigue() {
		boolean checkFatigue = true;
		int fatigueDaySentCount = 0;
		int fatigueMonthSentCount = 0;

		eMsResultSet rsMemberFatigueCount = null;

		try {

			rsMemberFatigueCount = psMemberFatigueCount.executeQuery(__TMP_SIMPLE_HASH__);
			if (rsMemberFatigueCount.next()) {
				fatigueDaySentCount = rsMemberFatigueCount.getInt("DAY_CNT");
				fatigueMonthSentCount = rsMemberFatigueCount.getInt("MONTH_CNT");
			}
			if (fatigueDaySentCount > fatigueDayLimitCount
					|| fatigueMonthSentCount > fatigueMonthLimitCount) {
				__TMP_SIMPLE_HASH__.put(CommonColumn.SEND_STATE.getCode(), ErrorCode.FATIGUE_FILTER.getCode());
				fatigueFilteredCount++;
				checkFatigue = false;
			}

		} catch(Exception e) {
			log.error("[ERROR] Get Fatigue Sent Count", e);
		} finally {
			if (rsMemberFatigueCount != null) rsMemberFatigueCount.close();
		}
		return checkFatigue;
	}

	protected String getFatigueListTableName(String ChannelType , String dateType){
		String targetFatigueListTable = "";
		log.info("ChannelType {} , dateType {}", ChannelType, dateType  );
		switch (ChannelType) {
		case "EM":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_EMAIL_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_EMAIL_MONTH_LIST";
			}
			break;
		case "SM":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_SMS_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_SMS_MONTH_LIST";
			}
			break;
		case "KA":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_KAKAO_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_KAKAO_MONTH_LIST";
			}
			break;
		case "PU":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_PUSH_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_PUSH_MONTH_LIST";
			}
			break;

		default:
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_MONTH_LIST";
			}
			break;
		}
		return targetFatigueListTable;
	}
}
