package jupiter.auto.actor;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.log.Composer;
import pluto.util.Cal;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class AutoTestListMaker extends BasicListMaker {

	

	protected String				LIST_TABLE	= null;
	
	//삼성생명 전용으로 추가한 부분임.
	protected String PA     = "PWD";
	protected String PWD_STR = "1111111";
	
	/** Creates a new instance of TestListMaker */
	public AutoTestListMaker() {
		super();
	}

	@Override
	protected void inner_init(Properties prop) throws Exception {
		this.SCHEDULE_INFO = prop;

		// 로그 조립 인스턴스 초기화
		this.composer = Composer.getComposerInstance();

		// 스풀 헤쉬파서 초기화
		this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");

		//Prop에 이미 POST_ID가 들어 있다...
		this.POST_ID = prop.getProperty("POST_ID");
		
		this.LIST_TABLE = prop.getProperty("LIST_TABLE");

		setName(this.POST_ID + "'s TestListMaker");

		this.WORK_FILE_ID = this.POST_ID + "_test_" + System.currentTimeMillis();

		this.WORKDAY = null;
		this.SEQNO = null;
	}

	protected List<String>	TEST_MSG_LIST	= new LinkedList<String>();

	/**
	 * CLOB DATA 를 가져오기 위한 함수
	 * @param reader
	 * @return
	 * @throws IOException
	 */
	public static String readClobData(Reader reader) throws IOException {
        StringBuffer data = new StringBuffer();
        char[] buf = new char[1024];
        int cnt = 0;
        if (null != reader) {
            while ( (cnt = reader.read(buf)) != -1) {
                data.append(buf, 0, cnt);
            }
        }
        return data.toString();
    }
	
	/**
	 * 여기서 TMS_AUTO_SAMPLING 테이블에서 SPOOL_FLAG = N 이라면, SPOOL 파일 받은 것을 그대로 써주게 하고, 그렇지 않다면 기존 로직 그대로 INFO 파일을  생성하게 한다.
	 * TODO [JOO][TFT][CARE] auto test list : 필요있는 함수인지 확인해야함
	 * @return
	 */
	protected String getSpoolData(){
		String spool_data = "";
		String lobGetQuery = "";
		String sample_id = "";
		sample_id = this.SCHEDULE_INFO.getProperty("ID");
			
		lobGetQuery = "SELECT SPOOL_DATA FROM EMS_AUTO_SAMPLING WHERE ID='"+ sample_id +"'";
		
		eMsConnection con = null;

		try {
			con = ConnectionPool.getConnection();
		} catch (Exception e1) {
			log.error("connection error", e1);
		}
		PreparedStatement psmt = null;
		ResultSet rs = null;
		try {
			if(con != null) {
				psmt = con.prepareStatement(lobGetQuery);
				rs = psmt.executeQuery();
				
				if(rs.next()){
					String clobData = readClobData(rs.getCharacterStream("SPOOL_DATA"));
					spool_data = new String(clobData.getBytes( eMsLocale.FILE_SYSTEM_IN_CHAR_SET ), eMsLocale.FILE_SYSTEM_OUT_CHAR_SET );
				}	
			}
		} catch (Exception e) {
			log.error("error", e);
		} finally{
			if(rs != null){
				try {
					rs.close();
				} catch (Exception e) { }
			}
			if( psmt != null){
				try {
					psmt.close();
				} catch (Exception e) { }
			}
			if( con!= null ){
				con.recycle();
			}
		}
		return spool_data;
	}
	
	/**
	 * 
	 */
	@Override
	protected synchronized void execute_BasicInfoProcess() throws Exception {

		String        testMsgTo  = this.SCHEDULE_INFO.getProperty("SEND_LIST");

		String[] testList = testMsgTo.split(":");
		
		for(int i=0; i<testList.length; i++){
			TEST_MSG_LIST.add(testList[i]);
		}
		
		if( !TEST_MSG_LIST.isEmpty()) {
			throw new NoTargetListException("NO TARGET LIST => " + this.SCHEDULE_INFO.getProperty("SEND_LIST"));
		}
		
		execute_BasicInfoProcess_basic();
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	protected synchronized void execute_BasicInfoProcess_basic() throws Exception {
		String today = Cal.getDayDate();		
		
		// 기본리스트 파일 저장 파일이름 결정
		this.LIST_STORE_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, today) + "/" + this.WORK_FILE_ID + ".base";
		
		/**
		 * 저장파일을 초기화 한다.
		 */
		openWriter(this.LIST_STORE_FILE_NAME);
		
		this.NEXT_BASE_INFO_FILE_NAME = this.LIST_STORE_FILE_NAME;
		
		String targetQuery = null;
		
		eMsConnection targetCon = null;
		eMsStatement  stmt      = null;
		eMsResultSet  rs        = null;

		/* 시작 전에 헤더 스트링을 초기화하고 시작한다. */
		this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", "");
		ConnectInfo tmpConnectionInfo = (ConnectInfo) this.VECTOR_QUERY_LIST_INFO.get(0);
		StringBuffer buffer = new StringBuffer(1024);
		
		try {
			
			//지정된테스트 쿼리를 이용해서 테스트 진행
			targetQuery = this.SCHEDULE_INFO.getProperty("TEST_QUERY");
			targetCon   = ConnectionPool.getConnection(tmpConnectionInfo);
			
			if (log.isDebugEnabled()) {
				log.debug(".execute_BasicInfoProcess() db url :"+ tmpConnectionInfo.getDB_URL());
				log.debug(".execute_BasicInfoProcess() db id :" + tmpConnectionInfo.getDB_UID());
				log.debug(".execute_BasicInfoProcess() db pwd :"+ tmpConnectionInfo.getDB_PASS());
			}

			stmt = targetCon.createStatement();
			if (log.isDebugEnabled()) {
				log.debug(".execute_BasicInfoProcess() exe test_query:"+ targetQuery);
			}
			rs = stmt.executeQuery(targetCon.encode(targetQuery));
			if (log.isDebugEnabled()) {
				log.debug(".execute_BasicInfoProcess() exe query:[OK]");
			}
			
			
			//////////////////////////////////////////////////////////////////////////////////////
			String [] header_list = StringUtil.split(rs.getHeaderString(), "|");
			buffer.setLength(0);
			
			//액션 인덱스
			int pwd_index = 0;
			String tempHeader = "";
			
			for(int i=1; i<=header_list.length; i++) {
				tempHeader = header_list[i-1];
				
				//테스트 발송은 1111111 로 페스워드를 세팅한다.
				if(tempHeader.equals(PA)){
					pwd_index = i;
				}
				
				//헤더를 다시 만들어줌
				if(i!=1){
					buffer.append("|");
				}
				buffer.append(tempHeader);
			}
			
			this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
			log.info("TARGET MAPPINGHEADER : "+ this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));
			
			////////////////////////////////////////////////////////////////////////////////////

			// int patch_count = 0;
			int colcount        = rs.getColumnCount();
			boolean appendCheck = false;
			String temp         = "";

			while (rs.next()) {
				buffer.setLength(0);
				temp = rs.getString(1);
				
				//테스트 발송은 1111111 로 페스워드를 세팅한다. 
				if(pwd_index==1 ){
					temp = PWD_STR;
				}else{
					temp = rs.getString(1);
				}
				
				DelimConvertor.encodeToBuffer(buffer, (temp == null ? "" : temp.trim()));
				// BUFFERED_WRITER.write( DelimConvertor.encode_( rs.getString(1) ) );

				for (int count = 2; count <= colcount; count++) {
					buffer.append("|");
					
					//테스트 발송은 1111111 로 페스워드를 세팅한다.
					if(pwd_index==count ){
						temp = PWD_STR;
					}else{
						temp = rs.getString(count);
					}
					
					DelimConvertor.encodeToBuffer(buffer, (temp == null ? "": temp.trim()));
				}
				
				BUFFERED_WRITER.write(buffer.toString());
				BUFFERED_WRITER.newLine();
				BUFFERED_WRITER.flush();
				
				appendCheck = true;
				log.debug("LINE CREATE....");
			}

			//리스트가 하나도 없다면 Exception을 날린다.
			if (!appendCheck) {
				throw new NoTargetListException("NO TARGET LIST => " + this.POST_ID);
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(rs != null){
					rs.close();
				}
			}
			catch(Exception ignore) {
			}
			try {
				if(stmt != null){
					stmt.close();
				}
			}
			catch(Exception ignore) {
			}
			try {
				if(targetCon != null){
					targetCon.destroy();
				}
			}
			catch(Exception ignore) {
			}
			try {
				BUFFERED_WRITER.flush();
			}
			catch(Exception ignore) {
			}
			try {
				if(BUFFERED_WRITER != null){
					BUFFERED_WRITER.close();
				}
			}
			catch(Exception ignore) {
			}
		}
	}
	

	/**
	 * 통합 스풀 패턴으로 전환하여 마지막 파일을 만들어야 한다.
	 */
	@Override
	protected synchronized void execute_DBInsertProcess() throws Exception {
		String this_day = Cal.getDayDate();
		// 기본리스트 파일 저장 파일이름 결정
		this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".infoadd";

		// 저장파일을 초기화 한다.
		if (log.isDebugEnabled()) {
			log.debug(".execute_DBInsertProcess() set spool file :" + this.INFO_ADDED_FINAL_FILE_NAME);
		}
		openWriter(this.INFO_ADDED_FINAL_FILE_NAME);

		if (log.isDebugEnabled()) {
			log.debug(".execute_DBInsertProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
		}
		openReader(this.NEXT_BASE_INFO_FILE_NAME);
		
		// 다음 단계에서 사용할 소스파일을 지정한다.
		this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;

		// 스풀에 적을 기본적인 사항을 세팅한다.
		SpoolAnalyzer spoolAnalyzer = SpoolAnalyzer.getSpoolAnalyzer();

		spoolAnalyzer.setSendType("AUTOTEST");// one to one
		spoolAnalyzer.setNextSpoolGenerate("N");// spool attach
		spoolAnalyzer.setLimitDate("19000000");
		spoolAnalyzer.setPostID(this.POST_ID);
		spoolAnalyzer.setListTable("NOTABLE");

		spoolAnalyzer.setStep(0);

		Map<String, String> headerMap = new HashMap<String, String>();
		String tmpReadLine  = null;

		try {
			SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", headerMap);
			log.info(" Source File Read Ready ");
			
			String engineChannel = this.SCHEDULE_INFO.getProperty("ENGINE_CHANNEL");

			while (BUFFERED_READER.ready()) {
				tmpReadLine = BUFFERED_READER.readLine();

				if (log.isDebugEnabled()) {
					log.debug("engine => "+engineChannel+ ", read => " + tmpReadLine);
				}

				// 공백 라인일경우에 스킵
				if( tmpReadLine == null || tmpReadLine.trim().length() < 5 ){
					continue;
				}

				try {
					this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, tmpReadLine, headerMap);

					if( !__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID") || !__TMP_SIMPLE_HASH__.containsKey("TMS_M_NAME") ) {
						continue;
					}
					
					log.info(" Source==> "+TEST_MSG_LIST.size());
					
					int idx = 1;
					for (Iterator<String> iter = TEST_MSG_LIST.iterator(); iter.hasNext();) {
						/**
						 * 미리 만들어놓은 이메일리스트를 쭉! 넣어 준다.
						 */
						spoolAnalyzer.setTokenID(iter.next().toString()); // EMS_M_MSGTO //주요
						
						spoolAnalyzer.setMemberID(__TMP_SIMPLE_HASH__.get("TMS_M_ID").toString().concat("_"+idx));
						spoolAnalyzer.setMemberName(__TMP_SIMPLE_HASH__.get("TMS_M_NAME").toString());
						spoolAnalyzer.setMapping(tmpReadLine);
						
						//spoolAnalyzer.setEngineChannel( engineChannel );// EMAIL, SMS, LMS, MMS, PUSH
						
						BUFFERED_WRITER.write(spoolAnalyzer.composeSingleRcptSend());
						log.info(" Source==> "+spoolAnalyzer.composeSingleRcptSend());
						BUFFERED_WRITER.newLine();
						BUFFERED_WRITER.flush();
						idx++;
					}
				}
				catch(Exception e) {
					log.error("TEST ID/NAME/MSGTO POPUP FAIL", e);
					continue;
				}
			}

			log.info(" Souce File Read Done ");
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(BUFFERED_READER != null){
					BUFFERED_READER.close();
				}
			}
			catch(Exception e) {
			}
			try {
				BUFFERED_WRITER.flush();
			}
			catch(Exception e) {
			}
			try {
				if(BUFFERED_WRITER != null){
					BUFFERED_WRITER.close();
				}
			}
			catch(Exception e) {
			}
			log.info(" Exit Souce File Read Routine ");
		}
	}
	
	@Override
	protected synchronized void execute_FinalProcess() throws Exception {
		// do nothing
	}

	@Override
	public Object getTargetList() {
		return this.NEXT_BASE_INFO_FILE_NAME;
	}

	@Override
	protected void updateTaskState(String state) throws Exception {
		//do nothing
	}

	@Override
	protected void deleteCurrentList() throws Exception {
		//do nothing
	}

	@Override
	public String getID() {

		return (this.POST_ID == null) ? null : (this.POST_ID);
	}
}
