/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.mass.basic.MassBasicDefaultMappingGenerator;
import venus.spool.parallel.task.AbstractDbSpoolTask;

public class SingleTestSpoolTask
extends AbstractDbSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(SingleTestSpoolTask.class);
    public static String QUERY_TEST_LIST_SAMPLING_QUERY = null;
    public static String QUERY_UPDATE_TEST_SPOOL_CONF = null;
    private String seq = null;

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.setTaskID(this.POST_ID.concat(String.valueOf(System.currentTimeMillis())));
        this.setName(this.POST_ID + "_SingleTestSpoolTask");
        this.setSeq(this.TASK_PROPERTY.getProperty("SEQ"));
        this.WORK_FILE_ID = this.POST_ID.concat("_real_test_").concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setSendType("MTEST");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("N");
        this.SPOOL_ANALYZER.setLimitDate("19000101");
        this.SPOOL_ANALYZER.setPostID(this.POST_ID);
        this.SPOOL_ANALYZER.setListTable(this.LIST_TABLE);
        this.SPOOL_ANALYZER.setStep(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeSpoolFile() throws Exception {
        block15: {
            String this_day = Cal.getDayDate();
            String __WORK_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + "_test.spool";
            if (log.isDebugEnabled()) {
                log.debug("spool filename:" + __WORK_FILE_NAME__);
            }
            this.openSpooler(__WORK_FILE_NAME__);
            eMsStatement __EMS_EXEC_STATEMENT__ = null;
            eMsResultSet base_rs = null;
            Exception ex = null;
            try {
                __EMS_EXEC_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                this.TMP_STRING_BUFFER.setLength(0);
                StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_TEST_LIST_SAMPLING_QUERY, this.TASK_PROPERTY, "${", "}", true, false);
                base_rs = __EMS_EXEC_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
                Properties prop = new Properties();
                if (!base_rs.next()) {
                    throw new RuntimeException("NO SAMPLE LIST...");
                }
                base_rs.putToMap(prop, true);
                String __TMP_SAMPLING_STRING__ = prop.getProperty("TOTAL_SPOOL_LINE");
                List __TARGET_LIST__ = StringUtil.toStringList(this.TASK_PROPERTY.getProperty("TEST_LIST"), ":", new LinkedList());
                if (__TARGET_LIST__ == null || __TARGET_LIST__.size() < 1) {
                    throw new RuntimeException("NO TEST LIST...");
                }
                Iterator iter = __TARGET_LIST__.iterator();
                while (iter.hasNext()) {
                    String _TARGET_TOKEN_ = iter.next().toString();
                    if (StringUtil.isError(_TARGET_TOKEN_)) continue;
                    this.SPOOL_ANALYZER.setTokenID(_TARGET_TOKEN_);
                    this.SPOOL_ANALYZER.setMemberID(prop.getProperty("TMS_M_ID"));
                    this.SPOOL_ANALYZER.setMemberName(prop.getProperty("TMS_M_NAME"));
                    this.SPOOL_ANALYZER.setMapping(__TMP_SAMPLING_STRING__);
                    this.appendSpooler(this.SPOOL_ANALYZER.composeSingleRcptSend());
                }
            }
            catch (Exception e) {
                ex = e;
            }
            finally {
                try {
                    base_rs.close();
                }
                catch (Exception exception) {}
                this.EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
                this.closeSpooler();
                if (ex == null) break block15;
                throw ex;
            }
        }
    }

    @Override
    protected void addSpool(Properties prop) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_Finish(boolean success) throws Exception {
        super.execute_Finish(success);
        if (success) {
            eMsStatement stmt = null;
            try {
                stmt = this.EMS_CONNECTION.createStatement();
                Properties prop = new Properties();
                prop.setProperty("SEQ", this.getSeq());
                prop.setProperty("SPOOL_CONF", SpoolInfoManager.getSpoolInfo(this.POST_ID).getSpoolInfoPath());
                this.TMP_STRING_BUFFER.setLength(0);
                StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_TEST_SPOOL_CONF, prop, "${", "}", true, false);
                stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
                success = false;
            }
            finally {
                this.EMS_CONNECTION.recycleStatement(stmt);
            }
        }
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String string) {
        this.seq = string;
    }

    @Override
    protected void makeSpoolInfo() throws Exception {
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.TASK_PROPERTY.getProperty("POST_ID"));
        this.mailSpoolInfo.setSendState(this.TASK_PROPERTY.getProperty("SEND_STATE"));
        this.mailSpoolInfo.setMappingHeader(this.getMappingHeader());
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_URL_LIST);
        log.debug("=================START test content ===================");
        MassBasicDefaultMappingGenerator KEYVALUE_MAPPING_GENERATOR = new MassBasicDefaultMappingGenerator();
        KEYVALUE_MAPPING_GENERATOR.process(this.TASK_PROPERTY);
        this.mailSpoolInfo.setDefaultMapping(KEYVALUE_MAPPING_GENERATOR.getMapOfDefaultMapping());
        log.debug("========================END===========================");
        String file_name = this.TASK_PROPERTY.getProperty("POST_ID") + "_TEST_" + this.TASK_PROPERTY.getProperty("SEQ");
        SpoolInfoManager.registSpoolInfo(this.mailSpoolInfo, file_name);
    }

    static {
        try {
            QUERY_TEST_LIST_SAMPLING_QUERY = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_TEST_LIST_SAMPLING_QUERY");
            QUERY_UPDATE_TEST_SPOOL_CONF = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_UPDATE_TEST_SPOOL_CONF");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

