/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.mass.task;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.parallel.task.AbstractDbSpoolTask;

public class SingleBaseSpoolTask
extends AbstractDbSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(SingleBaseSpoolTask.class);
    protected static List QUERY_UPDATE_STATE_INFO = null;
    protected static String QUERY_SELECT_ONE_TO_ONE_LIST = null;
    protected static String QUERY_CHECK_STOP_FLAG = null;
    protected static String QUERY_UPDATE_SPOOL_CONF = null;
    protected static String QUERY_CHECK_STATUS = null;
    protected static String QUERY_UPDATE_PARALLEL_SPOOL_CONF = null;
    protected String INSTANCE_QUERY_CHECK_STOP_FLAG = null;
    protected List INSTANCE_QUERY_UPDATE_STATE_INFO = null;
    protected String startTaskState = "91";
    protected String endSuccessTaskState = "30";
    protected String endFailTaskState = "96";

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = prop.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = prop.getProperty("LIST_TABLE");
        this.AB_ID = prop.getProperty("AB_ID");
        this.REAL_POST_ID = prop.getProperty("REAL_POST_ID");
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_SingleBaseSpoolTask");
        this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_ONE_TO_ONE_LIST;
        this.UPDATE_TARGET_LIST_QUERY = null;
        this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
        this.APPEND_TOTAL_SPOOL = true;
        this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
        this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDate());
        this.SPOOL_ANALYZER.setSendType("MASS");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("Y");
        this.SPOOL_ANALYZER.setLimitDate(prop.getProperty("QUE_CLOSE_DATE", Cal.getAddDayDate(1)));
        this.SPOOL_ANALYZER.setPostID(this.POST_ID);
        this.SPOOL_ANALYZER.setListTable(this.LIST_TABLE);
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    protected void addSpool(Properties prop) throws Exception {
        this.SPOOL_ANALYZER.setTokenID(prop.getProperty("TMS_M_TOKEN"));
        this.SPOOL_ANALYZER.setMemberID(prop.getProperty("TMS_M_ID"));
        this.SPOOL_ANALYZER.setMemberName(prop.getProperty("TMS_M_NAME"));
        this.SPOOL_ANALYZER.setMapping(prop.getProperty("TOTAL_SPOOL_LINE"));
        this.appendSpooler(this.SPOOL_ANALYZER.composeSingleRcptSend());
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    protected void updateTaskState(String __TYPE__, String __STATE__) {
        this.updateTaskState(__TYPE__, __STATE__, "StateUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {
        this.TASK_PROPERTY.setProperty("UPDATE_JOB_STATUS", __STATE__);
        eMsConnection emsConnection = null;
        eMsStatement stmt = null;
        try {
            emsConnection = ConnectionPool.getConnection();
            stmt = emsConnection.createStatement();
            List list = this.INSTANCE_QUERY_UPDATE_STATE_INFO;
            synchronized (list) {
                Iterator iter = this.INSTANCE_QUERY_UPDATE_STATE_INFO.iterator();
                while (iter.hasNext()) {
                    String query = iter.next().toString();
                    this.TMP_STRING_BUFFER.setLength(0);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, query, this.TASK_PROPERTY, "${", "}", true, false);
                    stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
                }
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
        }
        finally {
            emsConnection.recycleStatement(stmt);
            emsConnection.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_Startup() throws Exception {
        eMsStatement stmt = null;
        eMsResultSet rs = null;
        boolean check = false;
        String status = "";
        try {
            stmt = this.EMS_CONNECTION.createStatement();
            Properties prop = new Properties();
            prop.setProperty("POST_ID", this.POST_ID);
            prop.setProperty("LIST_TABLE", this.LIST_TABLE);
            prop.setProperty("REAL_POST_ID", this.REAL_POST_ID);
            prop.setProperty("AB_ID", this.AB_ID);
            this.TMP_STRING_BUFFER.setLength(0);
            StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_CHECK_STATUS, prop, "${", "}", true, false);
            rs = stmt.executeQuery(this.TMP_STRING_BUFFER.toString());
            if (rs.next()) {
                status = rs.getString("JOB_STATUS");
                check = status.equals(this.startTaskState);
                try {
                    this.__TARGET_CNT = Integer.parseInt(rs.getString("TARGET_CNT"));
                }
                catch (Exception ee) {
                    this.__TARGET_CNT = 0;
                }
            } else {
                check = false;
            }
        }
        catch (Exception e) {
            log.error(this.getName(), (Throwable)e);
            check = false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            this.EMS_CONNECTION.recycleStatement(stmt);
        }
        if (!check) {
            throw new Exception(" INVALID TYPE [" + status + "], NOT STARTED! ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_Finish(boolean success) throws Exception {
        super.execute_Finish(success);
        if (success) {
            eMsStatement stmt = null;
            try {
                stmt = this.EMS_CONNECTION.createStatement();
                Properties prop = new Properties();
                prop.setProperty("POST_ID", this.POST_ID);
                prop.setProperty("AB_ID", this.AB_ID);
                prop.setProperty("REAL_POST_ID", this.REAL_POST_ID);
                if (this.PARALLEL_FLAG) {
                    String tmpSvrNm = "";
                    for (int i = 0; i < this.PARALLEL_SERVER_NAME_LIST.size(); ++i) {
                        this.TMP_STRING_BUFFER.setLength(0);
                        tmpSvrNm = (String)this.PARALLEL_SERVER_NAME_LIST.get(i);
                        prop.setProperty("SERVER_ID", tmpSvrNm);
                        prop.setProperty("SPOOL_CONF", SpoolInfoManager.getParallelSvrSpoolInfo(this.POST_ID + "|" + tmpSvrNm));
                        StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_PARALLEL_SPOOL_CONF, prop, "${", "}", true, false);
                        stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
                    }
                } else {
                    this.TMP_STRING_BUFFER.setLength(0);
                    prop.setProperty("SERVER_ID", "01");
                    prop.setProperty("SPOOL_CONF", SpoolInfoManager.getSpoolInfo(this.POST_ID).getSpoolInfoPath());
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_PARALLEL_SPOOL_CONF, prop, "${", "}", true, false);
                    stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
                }
                prop.setProperty("SPOOL_CONF", SpoolInfoManager.getSpoolInfo(this.POST_ID).getSpoolInfoPath());
                this.TMP_STRING_BUFFER.setLength(0);
                StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_SPOOL_CONF, prop, "${", "}", true, false);
                stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
            }
            catch (Exception e) {
                log.error(this.getName(), (Throwable)e);
                success = false;
            }
            finally {
                this.EMS_CONNECTION.recycleStatement(stmt);
            }
        }
        if (success) {
            this.updateTaskState("", this.endSuccessTaskState);
        } else {
            this.updateTaskState("", this.endFailTaskState);
        }
    }

    static {
        try {
            QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("WINDFORCE_COMMON", "QUERY_UPDATE_STATE_INFO");
            QUERY_SELECT_ONE_TO_ONE_LIST = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_SELECT_ONE_TO_ONE_LIST");
            QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_CHECK_STOP_FLAG");
            QUERY_UPDATE_SPOOL_CONF = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_UPDATE_SPOOL_CONF");
            QUERY_CHECK_STATUS = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_CHECK_STATUS");
            QUERY_UPDATE_PARALLEL_SPOOL_CONF = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_UPDATE_PARALLEL_SPOOL_CONF");
        }
        catch (Exception ignore) {
            log.error(ignore.getMessage());
        }
    }
}

