/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.task;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.StringConvertUtil;
import venus.spool.common.task.SpoolControlTask;

public abstract class AbstractDbSpoolTask
extends SpoolControlTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbSpoolTask.class);
    protected final int COMMIT_INTEVER = 1000;
    protected final int UPDATE_ADDBATCH_CNT = 1000;
    protected String LIST_TABLE = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected StringBuffer TMP_STRING_BUFFER = null;
    protected String SELECT_TARGET_LIST_QUERY = null;
    protected String SELECT_DIVIDE_TARGET_LIST_QUERY = null;
    protected String UPDATE_MKT_N_FILTER = null;
    protected String UPDATE_FATIGUE_N_FILTER = null;
    protected String UPSERT_FATIGUE_LIST_TABLE = null;
    protected String UPDATE_SCHD_FILTERED_TARGET = null;
    protected String UPDATE_TARGET_LIST_QUERY = null;
    protected String UPSERT_FATIGUE_LIST_QUERY = null;
    protected String SELECT_TARGET_FATIGUE_LIST_QUERY = null;
    private List<String> FILTER_TARGET_LIST = null;
    private List<String> UPSERT_DAY_TARGET_LIST = null;
    private List<String> UPSERT_MONTH_TARGET_LIST = null;
    private boolean FILTER_UPDATE_SCHD_FLAG = false;

    public AbstractDbSpoolTask() throws Exception {
        super((short)1, 60000L);
    }

    public AbstractDbSpoolTask(short type) throws Exception {
        super(type, 60000L);
    }

    public AbstractDbSpoolTask(short type, long interval) throws Exception {
        super(type, interval);
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        if (log.isDebugEnabled()) {
            log.debug(" Request Connection");
        }
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        if (log.isDebugEnabled()) {
            log.debug(" Get-Connetion " + this.EMS_CONNECTION.getName());
        }
        this.TMP_STRING_BUFFER = new StringBuffer(1024);
        this.FILTER_TARGET_LIST = new ArrayList<String>();
        this.UPSERT_MONTH_TARGET_LIST = new ArrayList<String>();
        this.UPSERT_DAY_TARGET_LIST = new ArrayList<String>();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycle();
        }
        this.TMP_STRING_BUFFER = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute_ListLoad(Properties TARGET_PROPERTIES) throws Exception {
        block40: {
            String postId = TARGET_PROPERTIES.getProperty("POST_ID");
            String send_state = TARGET_PROPERTIES.getProperty("SEND_STATE", "TEST");
            log.info("spool make start [postId:{}]", (Object)postId);
            eMsStatement __SELECT_STATEMENT__ = null;
            eMsStatement __SELECT_FATIGUE_STATEMENT__ = null;
            eMsStatement __UPDATE_STATEMENT__ = null;
            eMsResultSet rs = null;
            eMsResultSet fatigueResultSet = null;
            Exception ex = null;
            eMsPreparedStatement PS_SELECT_SEND_LIMIT_VALUE = null;
            eMsPreparedStatement PS_UPDATE_SEND_RESULT = null;
            eMsPreparedStatement PS_INSERT_SEND_LIMIT_VALUE = null;
            eMsPreparedStatement PS_UPDATE_SEND_LIMIT_VALUE = null;
            try {
                Properties UPDATE_INFO;
                String pkIndexName;
                __SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                __SELECT_FATIGUE_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                __UPDATE_STATEMENT__ = this.EMS_CONNECTION.createStatement();
                int spoolLimit = Integer.parseInt(TARGET_PROPERTIES.getProperty("DIVIDE_CNT", "-1"));
                if (spoolLimit == -1 || "N".equals(TARGET_PROPERTIES.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
                    spoolLimit = SPOOL_LIMIT;
                }
                this.TMP_STRING_BUFFER.setLength(0);
                log.info("TARGET_PROPERTIES : {}", (Object)TARGET_PROPERTIES);
                log.info("TARGET_PROPERTIES_TEST : {}", (Object)this.TASK_PROPERTY);
                if ("Y".equals(FATIGUE_USE_YN) && "Y".equals(TARGET_PROPERTIES.getProperty("FILTER_USE_YN", "N")) && !send_state.equals("TEST")) {
                    log.info("SELECT_TARGET_FATIGUE_LIST_QUERY : {}", (Object)this.SELECT_TARGET_FATIGUE_LIST_QUERY);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_TARGET_FATIGUE_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
                    log.info("fatigueQuery {}", (Object)this.TMP_STRING_BUFFER);
                    fatigueResultSet = __SELECT_FATIGUE_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
                    while (fatigueResultSet.next()) {
                        TARGET_PROPERTIES.setProperty("DAY_LIMIT", fatigueResultSet.getString("FATIGUE_DAY_LIMIT"));
                        TARGET_PROPERTIES.setProperty("MONTH_LIMIT", fatigueResultSet.getString("FATIGUE_MONTH_LIMIT"));
                    }
                    this.TMP_STRING_BUFFER.setLength(0);
                }
                if (postId != null && !send_state.equals("TEST")) {
                    TARGET_PROPERTIES.setProperty("FATIGUE_DAY_TABLE", this.getFatigueListTableName(this.CHANNEL_TYPE, "DAY"));
                    TARGET_PROPERTIES.setProperty("FATIGUE_MONTH_TABLE", this.getFatigueListTableName(this.CHANNEL_TYPE, "MONTH"));
                }
                if ("Y".equals(TARGET_PROPERTIES.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
                    pkIndexName = "PK_" + TARGET_PROPERTIES.getProperty("LIST_TABLE").substring(4);
                    TARGET_PROPERTIES.setProperty("PK_INDEX", pkIndexName);
                    TARGET_PROPERTIES.setProperty("SPOOL_LIMIT", String.valueOf(spoolLimit));
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_DIVIDE_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
                } else {
                    pkIndexName = "PK_" + TARGET_PROPERTIES.getProperty("LIST_TABLE").substring(4);
                    TARGET_PROPERTIES.setProperty("PK_INDEX", pkIndexName);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.SELECT_TARGET_LIST_QUERY, TARGET_PROPERTIES, "${", "}", true, false);
                }
                log.info("TARGET_PROPERTIES : {}", (Object)TARGET_PROPERTIES);
                log.info("SELECT_TARGET_LIST_QUERY : {} ", (Object)this.TMP_STRING_BUFFER.toString());
                rs = __SELECT_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());
                Properties TARGET_INFO = new Properties();
                boolean isCamp = false;
                isCamp = "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("CAMP_YN", "N"));
                int filterCnt = 0;
                ArrayList<String> filteredMemberId = new ArrayList<String>();
                while (rs.next()) {
                    String memberId;
                    if (isCamp && "N".equalsIgnoreCase(rs.getString("MKT_FLAG")) && "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("MKT_YN"))) {
                        filteredMemberId.add(rs.getString("TMS_M_ID"));
                        continue;
                    }
                    if ("Y".equals(FATIGUE_USE_YN) && !send_state.equals("TEST") && "Y".equalsIgnoreCase(TARGET_PROPERTIES.getProperty("FILTER_USE_YN", "N")) && (Integer.parseInt(rs.getString("DAY_CNT")) >= Integer.parseInt(TARGET_PROPERTIES.getProperty("DAY_LIMIT", "0")) || Integer.parseInt(rs.getString("MONTH_CNT")) >= Integer.parseInt(TARGET_PROPERTIES.getProperty("MONTH_LIMIT", "0")))) {
                        memberId = rs.getString("TMS_M_ID");
                        filterCnt += this.updateFatigueList(memberId, this.UPDATE_FATIGUE_N_FILTER, false, TARGET_PROPERTIES.getProperty("SITE_ID"));
                        continue;
                    }
                    memberId = "";
                    memberId = rs.getString("TMS_M_ID").indexOf("_") > 0 ? rs.getString("TMS_M_ID").split("_")[0] : rs.getString("TMS_M_ID");
                    if ("Y".equals(FATIGUE_USE_YN) && postId != null && !send_state.equals("TEST")) {
                        this.upsertFatigueList(this.UPSERT_DAY_TARGET_LIST, memberId, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "DAY", true, false);
                        this.upsertFatigueList(this.UPSERT_MONTH_TARGET_LIST, memberId, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "MONTH", true, false);
                    }
                    TARGET_INFO.clear();
                    rs.putToMap(TARGET_INFO, this.APPEND_TOTAL_SPOOL);
                    if (this.UPDATE_TARGET_LIST_QUERY != null) {
                        this.TMP_STRING_BUFFER.setLength(0);
                        StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_TARGET_LIST_QUERY, TARGET_INFO, "${", "}", true, false);
                        if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                            log.error("list update fail");
                            continue;
                        }
                    }
                    ++this.addSpoolCount;
                    if (this.SPOOL_ATTACH_COUNT++ > spoolLimit) {
                        this.SPOOL_ATTACH_COUNT = 0;
                        String nextSpoolFileName = this.openNextSpooler();
                        log.debug("SWITCH SPOOL", (Object)nextSpoolFileName);
                    }
                    this.addSpool(TARGET_INFO);
                    this.LIST_APPEND_FLAG = true;
                }
                if (TARGET_INFO != null) {
                    this.lastSpoolMemberId = TARGET_INFO.getProperty("TMS_M_ID", "0");
                }
                log.info("make spool end [lastMemberId:" + this.lastSpoolMemberId + ", addSpoolCount:" + this.addSpoolCount + "]");
                this.FILTER_UPDATE_SCHD_FLAG = true;
                if (!filteredMemberId.isEmpty()) {
                    UPDATE_INFO = new Properties();
                    UPDATE_INFO.setProperty("LIST_TABLE", this.LIST_TABLE);
                    UPDATE_INFO.setProperty("POST_ID", this.POST_ID);
                    for (String memberId : filteredMemberId) {
                        UPDATE_INFO.setProperty("MEMBER_ID", memberId);
                        this.TMP_STRING_BUFFER.setLength(0);
                        StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_MKT_N_FILTER, UPDATE_INFO, "${", "}", true, false);
                        if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) >= 1) continue;
                        log.error("MKT_FLAG Y=>N Changed Target User Filter Update Fail / MemberId : " + memberId);
                    }
                    UPDATE_INFO.setProperty("FILTER_CNT", filteredMemberId.size() + "");
                    this.TMP_STRING_BUFFER.setLength(0);
                    StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_SCHD_FILTERED_TARGET, UPDATE_INFO, "${", "}", true, false);
                    if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                        log.error("CAMP SCHD FILTER CNT UPDATE FAIL / FILTER_CNT :  " + filteredMemberId.size());
                    }
                }
                if ("Y".equals(FATIGUE_USE_YN)) {
                    if (!this.UPSERT_DAY_TARGET_LIST.isEmpty()) {
                        this.upsertFatigueList(this.UPSERT_DAY_TARGET_LIST, null, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "DAY", true, true);
                    }
                    if (!this.UPSERT_MONTH_TARGET_LIST.isEmpty()) {
                        this.upsertFatigueList(this.UPSERT_MONTH_TARGET_LIST, null, TARGET_PROPERTIES.getProperty("SITE_ID"), this.UPSERT_FATIGUE_LIST_QUERY, "MONTH", true, true);
                    }
                    if (!this.FILTER_TARGET_LIST.isEmpty()) {
                        filterCnt += this.updateFatigueList(null, this.UPDATE_FATIGUE_N_FILTER, true, TARGET_PROPERTIES.getProperty("SITE_ID"));
                    }
                    if (this.FILTER_UPDATE_SCHD_FLAG && postId != null && !send_state.equals("TEST")) {
                        log.info("FATIGUE FILTER START");
                        UPDATE_INFO = new Properties();
                        UPDATE_INFO.setProperty("LIST_TABLE", this.LIST_TABLE);
                        UPDATE_INFO.setProperty("POST_ID", this.POST_ID);
                        UPDATE_INFO.setProperty("CHANNEL_TYPE", this.CHANNEL_TYPE);
                        UPDATE_INFO.setProperty("WORKDAY", TARGET_PROPERTIES.getProperty("WORKDAY", "0"));
                        UPDATE_INFO.setProperty("SEQNO", TARGET_PROPERTIES.getProperty("SEQNO", "0"));
                        UPDATE_INFO.setProperty("FILTER_CNT", filterCnt + "");
                        this.TMP_STRING_BUFFER.setLength(0);
                        StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, this.UPDATE_SCHD_FILTERED_TARGET, UPDATE_INFO, "${", "}", true, false);
                        log.info("FILTER_UPDATE_SCHD_FLAG!!! {}", (Object)this.TMP_STRING_BUFFER.toString());
                        if (__UPDATE_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString()) < 1) {
                            log.error("CAMP SCHD FILTER CNT UPDATE FAIL / FILTER_CNT :  {} ", (Object)filterCnt);
                        }
                        log.info("FATIGUE FILTER END (update filterCnt : {})", (Object)filterCnt);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info(e.toString());
                ex = e;
            }
            finally {
                log.info("spool make end [postId:{}" + TARGET_PROPERTIES.getProperty("POST_ID") + "]");
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (fatigueResultSet != null) {
                        fatigueResultSet.close();
                    }
                }
                catch (Exception exception) {}
                if (PS_SELECT_SEND_LIMIT_VALUE != null) {
                    PS_SELECT_SEND_LIMIT_VALUE.close();
                    PS_SELECT_SEND_LIMIT_VALUE = null;
                }
                if (PS_UPDATE_SEND_RESULT != null) {
                    PS_UPDATE_SEND_RESULT.close();
                    PS_UPDATE_SEND_RESULT = null;
                }
                if (PS_INSERT_SEND_LIMIT_VALUE != null) {
                    PS_INSERT_SEND_LIMIT_VALUE.close();
                    PS_INSERT_SEND_LIMIT_VALUE = null;
                }
                if (PS_UPDATE_SEND_LIMIT_VALUE != null) {
                    PS_UPDATE_SEND_LIMIT_VALUE.close();
                    PS_UPDATE_SEND_LIMIT_VALUE = null;
                }
                this.EMS_CONNECTION.recycleStatement(__UPDATE_STATEMENT__);
                this.EMS_CONNECTION.recycleStatement(__SELECT_FATIGUE_STATEMENT__);
                this.EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
                if (ex == null) break block40;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateFatigueList(String memberId, String query, boolean lastFlag, String SiteId) throws SQLException {
        int filterCnt = 0;
        if (memberId != null) {
            this.FILTER_TARGET_LIST.add(memberId);
        }
        if (this.FILTER_TARGET_LIST.size() >= 1000 || lastFlag) {
            eMsConnection con = null;
            eMsPreparedStatement psUpdateFatigueList = null;
            Properties prop = new Properties();
            prop.clear();
            prop.setProperty("POST_ID", this.POST_ID);
            prop.setProperty("SITE_ID", SiteId);
            prop.setProperty("CHANNEL_TYPE", this.CHANNEL_TYPE);
            query = query.replace("${LIST_TABLE}", this.LIST_TABLE);
            boolean commitCnt = false;
            try {
                con = ConnectionPool.getConnection();
                psUpdateFatigueList = con.prepareStatement(query, "${", "}");
                con.setAutoCommit(false);
                for (String targetMemberId : this.FILTER_TARGET_LIST) {
                    prop.setProperty("MEMBER_ID", targetMemberId);
                    psUpdateFatigueList.addBatch(prop);
                    ++filterCnt;
                }
                psUpdateFatigueList.executeBatch();
            }
            catch (Exception e) {
                con.rollback();
                filterCnt = 0;
                log.debug(e.toString());
                log.debug("CATCH LOGIC!!!! START :  {}", (Object)filterCnt);
                for (String targetMemberId : this.FILTER_TARGET_LIST) {
                    prop.setProperty("MEMBER_ID", targetMemberId);
                    try {
                        filterCnt += psUpdateFatigueList.executeUpdate(prop);
                        con.commit();
                    }
                    catch (Exception e2) {
                        log.info(e2.toString());
                    }
                }
                log.info("CATCH LOGIC!!!! END :  {}", (Object)filterCnt);
            }
            finally {
                if (psUpdateFatigueList != null) {
                    psUpdateFatigueList.close();
                }
                if (con != null) {
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            this.FILTER_TARGET_LIST.clear();
            log.debug("FATIGUE TARGET UPDATE SEND_LIST CNT : {}", (Object)filterCnt);
        }
        return filterCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int upsertFatigueList(List<String> targetList, String memberId, String SiteId, String query, String dateType, boolean useYn, boolean lastYn) throws SQLException {
        int filterCnt = 0;
        if (useYn) {
            if (memberId != null) {
                targetList.add(memberId);
            }
            if (targetList.size() >= 1000 || lastYn) {
                eMsConnection con = null;
                eMsPreparedStatement sUpsertFatigueList = null;
                Properties prop = new Properties();
                prop.clear();
                prop.setProperty("CHANNEL_TYPE", this.CHANNEL_TYPE);
                prop.setProperty("SITE_ID", SiteId);
                if (dateType.equals("DAY")) {
                    prop.setProperty("FATIGUE_DATE", this.POST_ID.substring(0, 8));
                } else if (dateType.equals("MONTH")) {
                    prop.setProperty("FATIGUE_DATE", this.POST_ID.substring(0, 6));
                }
                query = query.replace("${FATIGUE_TABLE}", this.getFatigueListTableName(this.CHANNEL_TYPE, dateType));
                try {
                    con = ConnectionPool.getConnection();
                    sUpsertFatigueList = con.prepareStatement(query, "${", "}");
                    con.setAutoCommit(false);
                    for (String targetMemberId : targetList) {
                        prop.setProperty("MEMBER_ID", targetMemberId);
                        sUpsertFatigueList.addBatch(prop);
                        ++filterCnt;
                    }
                    sUpsertFatigueList.executeBatch();
                }
                catch (Exception e) {
                    con.rollback();
                    filterCnt = 0;
                    log.debug(e.toString());
                    log.debug("CATCH LOGIC!!!! START :  {}", (Object)filterCnt);
                    for (String targetMemberId : targetList) {
                        try {
                            prop.setProperty("MEMBER_ID", targetMemberId);
                            filterCnt += sUpsertFatigueList.executeUpdate(prop);
                            con.commit();
                        }
                        catch (Exception ex) {
                            log.info("error :  {}", (Object)ex.toString());
                        }
                    }
                    log.debug("CATCH LOGIC!!!! END :  {}", (Object)filterCnt);
                }
                finally {
                    con.commit();
                    con.setAutoCommit(true);
                    con.recycleStatement(sUpsertFatigueList);
                    con.recycle();
                }
                targetList.clear();
                log.info("FATIGUE LIST UPSERT CNT : {}", (Object)filterCnt);
            }
        }
        return filterCnt;
    }

    protected String getFatigueListTableName(String ChannelType, String dateType) {
        String targetFatigueListTable = "";
        log.info("ChannelType {} , dateType {}", (Object)ChannelType, (Object)dateType);
        switch (ChannelType) {
            case "EM": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_EMAIL_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_EMAIL_MONTH_LIST";
                break;
            }
            case "SM": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_SMS_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_SMS_MONTH_LIST";
                break;
            }
            case "KA": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_KAKAO_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_KAKAO_MONTH_LIST";
                break;
            }
            case "PU": {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_PUSH_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_PUSH_MONTH_LIST";
                break;
            }
            default: {
                if (dateType.equals("DAY")) {
                    targetFatigueListTable = "TMS_FATIGUE_DAY_LIST";
                    break;
                }
                if (!dateType.equals("MONTH")) break;
                targetFatigueListTable = "TMS_FATIGUE_MONTH_LIST";
            }
        }
        return targetFatigueListTable;
    }
}

