/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.parser.SpoolAnalyzer;

public class StandardSpoolAnalyzer
extends SpoolAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(StandardSpoolAnalyzer.class);
    protected StringBuffer __INNER_BUFFER__ = new StringBuffer(1024);

    public StandardSpoolAnalyzer() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public synchronized String compose() throws Exception {
        return this.isNextSpoolValid() ? this.composeSingleRcptSend() : null;
    }

    @Override
    public synchronized String composeMultiRcptSend() throws Exception {
        StringBuffer buffer = new StringBuffer(1024);
        String email_str = this.getProperty("TOKEN_ENCRYPT");
        if (email_str == null) {
            email_str = this.getProperty("TOKEN_ID");
        }
        DelimConvertor.encodeToBuffer(buffer, email_str);
        buffer.append("|");
        buffer.append(this.getProperty("STYPE"));
        buffer.append("|");
        buffer.append(this.getProperty("NEXT_GEN"));
        buffer.append("|");
        buffer.append(this.getProperty("LIMIT_DATE"));
        buffer.append("|");
        buffer.append(this.getProperty("STEP"));
        buffer.append("|");
        buffer.append(this.getProperty("POST_ID"));
        buffer.append("|");
        buffer.append(this.getProperty("LIST_TABLE"));
        buffer.append("|");
        buffer.append(this.getProperty("SECURE_FLAG"));
        buffer.append("|");
        buffer.append(this.getProperty("ADDITIONAL_INFO"));
        buffer.append("|");
        buffer.append(this.getProperty("ROW_ID"));
        buffer.append("|");
        buffer.append(this.getProperty("OS"));
        buffer.append("|");
        buffer.append(this.getProperty("NOTI_FLAG"));
        buffer.append("|");
        DelimConvertor.encodeToBuffer(buffer, this.getProperty("M_ID"));
        return buffer.toString();
    }

    @Override
    public synchronized String composeSingleRcptSend() throws Exception {
        StringBuffer buffer = new StringBuffer(1024);
        String email_str = this.getProperty("TOKEN_ENCRYPT");
        if (email_str == null) {
            email_str = this.getProperty("TOKEN_ID");
        }
        DelimConvertor.encodeToBuffer(buffer, email_str);
        buffer.append("|");
        buffer.append(this.getProperty("STYPE"));
        buffer.append("|");
        buffer.append(this.getProperty("NEXT_GEN"));
        buffer.append("|");
        buffer.append(this.getProperty("LIMIT_DATE"));
        buffer.append("|");
        buffer.append(this.getProperty("STEP"));
        buffer.append("|");
        buffer.append(this.getProperty("POST_ID"));
        buffer.append("|");
        buffer.append(this.getProperty("LIST_TABLE"));
        buffer.append("|");
        buffer.append(this.getProperty("SECURE_FLAG"));
        buffer.append("|");
        buffer.append(this.getProperty("ADDITIONAL_INFO"));
        buffer.append("|");
        buffer.append(this.getProperty("ROW_ID"));
        buffer.append("|");
        buffer.append(this.getProperty("OS"));
        buffer.append("|");
        buffer.append(this.getProperty("NOTI_FLAG"));
        buffer.append("|");
        DelimConvertor.encodeToBuffer(buffer, this.getProperty("M_ID"));
        buffer.append("|");
        DelimConvertor.encodeToBuffer(buffer, this.getProperty("M_NAME"));
        buffer.append("|");
        buffer.append(this.getProperty("MAPPING"));
        return buffer.toString();
    }

    @Override
    public String pickupDomain(String spool) throws Exception {
        if (spool == null) {
            return null;
        }
        int idx1 = spool.indexOf("|");
        if (idx1 < 0) {
            return null;
        }
        String email = spool.substring(0, idx1);
        if (StringUtil.isError(email)) {
            return null;
        }
        return StringUtil.getDomain(email);
    }

    public void setEmailID(String value) {
        String email = null;
        String email_encrypt = null;
        int decyper_tag_len = "<TMS_DECRYPT>".length();
        int decyper_idx = value.indexOf("<TMS_DECRYPT>");
        if (decyper_idx >= 0) {
            email = value.substring(decyper_idx + decyper_tag_len);
            email_encrypt = value.substring(0, decyper_idx);
        } else {
            email = value;
            email_encrypt = value;
        }
        this.setProperty("TOKEN_ID", email);
        this.setProperty("DOMAIN", StringUtil.getDomain(email));
        this.setProperty("TOKEN_ENCRYPT", email_encrypt);
    }

    public static void main(String[] args) {
        StandardSpoolAnalyzer test = new StandardSpoolAnalyzer();
        String value = "xdfasdfasdfasdfasdfasdf<EMAIL_SSLIFE>leejc297@nate.com";
        test.setEmailID(value);
        log.debug(test.getTokenID() + "/" + test.getProperty("TOKEN_ID") + "/" + test.getDomain() + "/" + test.getProperty("DOMAIN"));
    }

    @Override
    public SpoolAnalyzer parse(String spool) throws Exception {
        int idx1 = 0;
        int idx2 = 0;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        this.setEmailID(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setSendType(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setNextSpoolGenerate(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setLimitDate(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setStep(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setPostID(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setListTable(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setSecureFlag(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setAdditionalValue(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setRowid(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setOs(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        super.setNotiflag(spool.substring(idx1, idx2));
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        StringBuffer buffer = new StringBuffer(1024);
        if (idx2 < 0) {
            buffer.setLength(0);
            DelimConvertor.decodeToBuffer(buffer, spool.substring(idx1));
            super.setMemberID(buffer.toString());
            return this;
        }
        buffer.setLength(0);
        DelimConvertor.decodeToBuffer(buffer, spool.substring(idx1, idx2));
        super.setMemberID(buffer.toString());
        idx1 = idx2 + 1;
        idx2 = spool.indexOf("|", idx1);
        if (idx2 < 0) {
            return null;
        }
        buffer.setLength(0);
        DelimConvertor.decodeToBuffer(buffer, spool.substring(idx1, idx2));
        super.setMemberName(buffer.toString());
        super.setMapping(spool.substring(idx2 + 1));
        return this;
    }
}

