/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.parser;

import freemarker20.template.SimpleHash;
import freemarker20.template.TemplateModel;
import freemarker20.tm.TemplateHashModelData;
import freemarker20.tm.TemplateHashModelListTM;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.convert.DelimConvertor;
import pluto.util.eMsStringTokenizer;

public class SpoolHashParser {
    private static final Logger log = LoggerFactory.getLogger(SpoolHashParser.class);
    protected eMsStringTokenizer STR_TOKEN = null;
    protected StringBuffer TMP_BUFFER = null;
    private static String StartOfLoop = null;
    private static String EndOfLoop = null;
    private static String StartOfElement = null;
    private static String EndOfElement = null;
    private String delim;

    public SpoolHashParser() {
        this("|");
    }

    public SpoolHashParser(String de) {
        this.delim = de;
        this.STR_TOKEN = new eMsStringTokenizer();
        this.TMP_BUFFER = new StringBuffer(1024);
    }

    public synchronized void setDelim(String de) {
        this.delim = de;
    }

    public synchronized void parse(SimpleHash HASH, String src) throws Exception {
        this.parse(HASH, src, null, null);
    }

    public synchronized void parse(SimpleHash HASH, String src, Map key) throws Exception {
        this.parse(HASH, src, key, null);
    }

    public synchronized void parse(SimpleHash HASH, String src, Map key, Object default_value) throws Exception {
        int StartOfLoopMapping;
        HASH.clear();
        if (src == null) {
            src = " ";
        }
        if ((StartOfLoopMapping = src.indexOf(StartOfLoop)) < 0) {
            this.parseSimpleElement(HASH, src, key);
        } else {
            this.parseSimpleElement(HASH, src.substring(0, StartOfLoopMapping), key);
        }
        if (default_value != null) {
            SpoolHashParser.putDefaultToMainHash(this.TMP_BUFFER, HASH, default_value);
        }
        if (StartOfLoopMapping < 0) {
            return;
        }
        int loop_idx = 1;
        int EndOfLoopMapping = src.indexOf(EndOfLoop, StartOfLoopMapping + StartOfLoop.length());
        while (EndOfLoopMapping >= 0) {
            String looping_key = "rap_" + String.valueOf(loop_idx++);
            String targetString = src.substring(StartOfLoopMapping + StartOfLoop.length(), EndOfLoopMapping);
            TemplateHashModelListTM sub_map = this.parseLooping(HASH, targetString, key == null ? null : (Map)key.get(looping_key));
            HASH.put(looping_key, (TemplateModel)sub_map);
            StartOfLoopMapping = src.indexOf(StartOfLoop, EndOfLoopMapping + EndOfLoop.length());
            if (StartOfLoopMapping < 0) {
                return;
            }
            EndOfLoopMapping = src.indexOf(EndOfLoop, StartOfLoopMapping);
        }
        return;
    }

    public synchronized void parseSerialMapping(SimpleHash HASH, String src, String __DELIM__) {
        if (src == null) {
            return;
        }
        this.STR_TOKEN.parse(src, __DELIM__);
        int idx = 0;
        StringBuffer buffer = new StringBuffer(256);
        while (this.STR_TOKEN.hasMoreTokens()) {
            ++idx;
            String __NEXT_ELM__ = this.STR_TOKEN.nextToken();
            buffer.setLength(0);
            DelimConvertor.decodeToBuffer(buffer, __NEXT_ELM__);
            __NEXT_ELM__ = buffer.toString();
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, __NEXT_ELM__, HASH, "${", "}", false, false);
            if (log.isDebugEnabled()) {
                log.debug("KeyValueParser:map_" + String.valueOf(idx) + "=>" + buffer.toString());
            }
            HASH.put("map_" + String.valueOf(idx), buffer.toString());
        }
    }

    public synchronized void parseSimple(Map HASH, String src, Map key) {
        if (key == null) {
            throw new NullPointerException("KEY MAP IS NULL");
        }
        if (src == null) {
            throw new NullPointerException("PARSING SRC IS NULL");
        }
        int delim_idx = src.indexOf("[");
        this.STR_TOKEN.parse(delim_idx > 0 ? src.substring(0, delim_idx) : src, this.delim);
        int idx = 0;
        StringBuffer buffer = new StringBuffer(256);
        while (this.STR_TOKEN.hasMoreTokens()) {
            ++idx;
            String sDummy = this.STR_TOKEN.nextToken();
            buffer.setLength(0);
            DelimConvertor.decodeToBuffer(buffer, sDummy);
            if (eMsLocale.HASH_SEND_MAP_PROCESS) {
                sDummy = buffer.toString();
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, sDummy, HASH, "${", "}", false, false);
            }
            if (log.isDebugEnabled()) {
                log.debug("KeyValueParser:" + (String)key.get("map_" + String.valueOf(idx)) + "=>" + buffer.toString());
            }
            HASH.put(key.get("map_" + String.valueOf(idx)), buffer.toString());
        }
    }

    private synchronized void parseSimpleElement(SimpleHash HASH, String src, Map key) {
        this.STR_TOKEN.parse(src, this.delim);
        StringBuffer buffer = new StringBuffer(256);
        int idx = 0;
        while (this.STR_TOKEN.hasMoreTokens()) {
            ++idx;
            String sDummy = this.STR_TOKEN.nextToken();
            buffer.setLength(0);
            DelimConvertor.decodeToBuffer(buffer, sDummy);
            if (eMsLocale.HASH_SEND_MAP_PROCESS) {
                sDummy = buffer.toString();
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, sDummy, HASH, "${", "}", false, false);
            }
            if (key == null) {
                if (log.isDebugEnabled()) {
                    log.debug("KeyValueParser:map_" + String.valueOf(idx) + "=>" + buffer.toString());
                }
                HASH.put("map_" + String.valueOf(idx), buffer.toString());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("KeyValueParser:" + (String)key.get("map_" + String.valueOf(idx)) + "=>" + buffer.toString());
            }
            HASH.put((String)key.get("map_" + String.valueOf(idx)), buffer.toString());
        }
    }

    private TemplateHashModelListTM parseLooping(SimpleHash HASH, String src, Map key) {
        int idx1 = 0;
        int idx2 = 0;
        TemplateHashModelListTM returnValue = new TemplateHashModelListTM();
        StringBuffer buffer = new StringBuffer(256);
        while ((idx1 = src.indexOf(StartOfElement, idx2)) >= 0 && (idx2 = src.indexOf(EndOfElement, idx1)) >= 0) {
            this.STR_TOKEN.parse(src.substring(idx1 + StartOfElement.length(), idx2), this.delim);
            int idx = 0;
            TemplateHashModelData myMapping = new TemplateHashModelData();
            while (this.STR_TOKEN.hasMoreTokens()) {
                ++idx;
                String sDummy = this.STR_TOKEN.nextToken();
                buffer.setLength(0);
                DelimConvertor.decodeToBuffer(buffer, sDummy);
                if (eMsLocale.HASH_SEND_MAP_PROCESS) {
                    sDummy = buffer.toString();
                    buffer.setLength(0);
                    StringConvertUtil.ConvertString(buffer, sDummy, HASH, "${", "}", false, false);
                }
                if (key == null) {
                    myMapping.put("rap_" + String.valueOf(idx), buffer.toString());
                    continue;
                }
                myMapping.put((String)key.get("rap_" + String.valueOf(idx)), buffer.toString());
            }
            returnValue.addEntry((Object)myMapping);
            idx2 += EndOfElement.length();
        }
        return returnValue;
    }

    protected void finalize() throws Throwable {
        this.TMP_BUFFER = null;
    }

    public void destroy() {
        try {
            this.finalize();
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    private static final void putDefaultToMainHash(StringBuffer buffer, SimpleHash HASH, Object map) throws Exception {
        if (!eMsLocale.HASH_SEND_MAP_PROCESS) {
            if (map instanceof Map) {
                HASH.putAll((Map)map);
            } else if (map instanceof SimpleHash) {
                HASH.putAll((Map)((SimpleHash)map).getAsHashmap());
            } else {
                throw new RuntimeException("Invalid Default Map Objet Type:" + map.getClass().getName());
            }
        }
        Map mapDefaultMap = null;
        if (map instanceof Map) {
            mapDefaultMap = (Map)map;
        } else if (map instanceof SimpleHash) {
            mapDefaultMap = ((SimpleHash)map).getAsHashmap();
        } else {
            throw new RuntimeException("Invalid Default Map Objet Type:" + map.getClass().getName());
        }
        for (Object key : mapDefaultMap.keySet()) {
            Object value = mapDefaultMap.get(key);
            if (value instanceof TemplateHashModelListTM) {
                SpoolHashParser.putDefaultListMapToMainHash(buffer, HASH, key.toString(), (TemplateHashModelListTM)value);
                continue;
            }
            buffer.setLength(0);
            StringConvertUtil.ConvertString(buffer, value.toString(), HASH, "${", "}", false, false);
            HASH.put(key.toString(), buffer.toString());
        }
    }

    private static final void putDefaultListMapToMainHash(StringBuffer buffer, SimpleHash HASH, String key, TemplateHashModelListTM map) throws Exception {
        int size = map.size();
        TemplateHashModelListTM dummyList = new TemplateHashModelListTM();
        for (int i = 0; i < size; ++i) {
            Map dummy = ((TemplateHashModelData)map.get(i)).getAsMap();
            TemplateHashModelData dummyHash = new TemplateHashModelData();
            for (Object oKey : dummy.keySet()) {
                Object oValue = dummy.get(oKey);
                buffer.setLength(0);
                StringConvertUtil.ConvertString(buffer, oValue.toString(), HASH, "${", "}", false, false);
                dummyHash.put(oKey.toString(), buffer.toString());
            }
            dummyList.addEntry((Object)dummyHash);
        }
        HASH.put(key, (TemplateModel)dummyList);
    }

    static {
        StartOfLoop = eMsSystem.getProperty("auto.loop.start", "[");
        EndOfLoop = eMsSystem.getProperty("auto.loop.end", "]");
        StartOfElement = eMsSystem.getProperty("auto.element.start", "{");
        EndOfElement = eMsSystem.getProperty("auto.element.end", "}");
    }
}

