/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.parser;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.log.Log;
import pluto.util.Cal;
import pluto.util.StringUtil;

public abstract class SpoolAnalyzer
extends Properties
implements Log {
    private static final Logger log = LoggerFactory.getLogger(SpoolAnalyzer.class);
    public static final String DEFAULT_ANALYZER_CLASS_NAME = "venus.spool.common.parser.StandardSpoolAnalyzer";
    public static int DEFAULT_RECYCLE = 3;
    protected static Class TARGET_CLASS;
    protected static String TARGET_CLASS_NAME;

    protected SpoolAnalyzer() {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    public static final synchronized void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        TARGET_CLASS_NAME = prop.getProperty("target.class");
        TARGET_CLASS = Class.forName(TARGET_CLASS_NAME);
    }

    public static final SpoolAnalyzer getSpoolAnalyzer() throws Exception {
        if (TARGET_CLASS == null) {
            TARGET_CLASS = Class.forName(DEFAULT_ANALYZER_CLASS_NAME);
        }
        return (SpoolAnalyzer)TARGET_CLASS.newInstance();
    }

    @Override
    public Object setProperty(String key, String value) {
        return super.setProperty(key, value == null ? "" : value);
    }

    public void setLimitDate(String value) {
        this.setProperty("LIMIT_DATE", value);
    }

    public String getLimitDate() {
        return this.getProperty("LIMIT_DATE");
    }

    public void setNextSpoolGenerate(String value) {
        this.setProperty("NEXT_GEN", value);
    }

    public String getNextSpoolGenerate() {
        return this.getProperty("NEXT_GEN");
    }

    public void setSendType(String value) {
        this.setProperty("STYPE", value);
    }

    public String getSendType() {
        return this.getProperty("STYPE");
    }

    public void setPostID(String value) {
        this.setProperty("POST_ID", value);
    }

    public String getPostID() {
        return this.getProperty("POST_ID", "no post id");
    }

    public void setListTable(String value) {
        this.setProperty("LIST_TABLE", value);
    }

    public String getListTable() {
        return this.getProperty("LIST_TABLE");
    }

    public void setMemberID(String value) {
        this.setProperty("M_ID", value);
    }

    public String getMemberID() {
        return this.getProperty("M_ID", "no member id");
    }

    public void setMemberName(String value) {
        this.setProperty("M_NAME", value);
    }

    public String getMemberName() {
        return this.getProperty("M_NAME", "no member name");
    }

    public void setTokenID(String value) {
        this.setProperty("TOKEN_ID", value);
        this.setProperty("DOMAIN", StringUtil.getDomain(value));
    }

    public String getTokenID() {
        return this.getProperty("TOKEN_ID");
    }

    public String getDomain() {
        return this.getProperty("DOMAIN");
    }

    public void setMapping(String value) {
        this.setProperty("MAPPING", value);
    }

    public String getMapping() {
        return this.getProperty("MAPPING");
    }

    public void setStep(String value) {
        this.setProperty("STEP", value);
    }

    public void setStep(int value) {
        this.setProperty("STEP", String.valueOf(value));
    }

    public String getStep() {
        return this.getProperty("STEP");
    }

    public int getIntStep() {
        return Integer.parseInt(this.getProperty("STEP"));
    }

    public void setSecureFlag(String value) {
        this.setProperty("SECURE_FLAG", value);
    }

    public String getSecureFlag() {
        return this.getProperty("SECURE_FLAG");
    }

    public void setAdditionalValue(String value) {
        this.setProperty("ADDITIONAL_INFO", value);
    }

    public String getAdditionalValue() {
        return this.getProperty("ADDITIONAL_INFO");
    }

    public void setRowid(String _rowid) {
        this.setProperty("ROW_ID", _rowid);
    }

    public String getRowid() {
        return this.getProperty("ROW_ID");
    }

    public void setOs(String os) {
        this.setProperty("OS", os);
    }

    public String getOs() {
        return this.getProperty("OS");
    }

    public void setNotiflag(String noti_flag) {
        this.setProperty("NOTI_FLAG", noti_flag);
    }

    public String getNotiflag() {
        return this.getProperty("NOTI_FLAG");
    }

    public void setPriority(String Priority) {
        this.setProperty("PRIORITY", Priority);
    }

    public String getPriority() {
        return this.getProperty("PRIORITY");
    }

    public synchronized boolean isNextSpoolValid() {
        return this.isNextSpoolValid(DEFAULT_RECYCLE);
    }

    public boolean isNextSpoolValid(int step) {
        if (this.getNextSpoolGenerate().equals("N")) {
            return false;
        }
        int limitDate = Integer.parseInt(this.getProperty("LIMIT_DATE", "19001010"));
        int nowDate = Integer.parseInt(Cal.getDayDate());
        return nowDate <= limitDate && step > this.getIntStep();
    }

    public abstract SpoolAnalyzer parse(String var1) throws Exception;

    public abstract String pickupDomain(String var1) throws Exception;

    public abstract String compose() throws Exception;

    public abstract String composeSingleRcptSend() throws Exception;

    public abstract String composeMultiRcptSend() throws Exception;

    static {
        try {
            DEFAULT_RECYCLE = Integer.parseInt(eMsSystem.getProperty("recycle.limit", "3"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            System.exit(1);
        }
        TARGET_CLASS = null;
        TARGET_CLASS_NAME = null;
    }
}

