/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.basic;

import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.schedule.ScheduledMonitor;
import venus.spool.common.handler.Spooler;

public class SpoolingManager
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(SpoolingManager.class);
    private static Spooler spooler_class = null;
    private static SpoolingManager innerManager = null;

    private SpoolingManager(int cycle) {
        super(cycle);
    }

    public static synchronized void init(Object prop) throws Exception {
        Properties tmp = (Properties)prop;
        Class<?> TargetClass = null;
        Method TargetMethod = null;
        Class[] method_args = new Class[]{Object.class};
        Object[] target_arg = new Object[1];
        String ClassName = tmp.getProperty("spooler.class");
        TargetClass = Class.forName(ClassName);
        TargetMethod = TargetClass.getDeclaredMethod("init", method_args);
        target_arg[0] = prop;
        TargetMethod.invoke(null, target_arg);
        spooler_class = (Spooler)TargetClass.newInstance();
        ClassName = tmp.getProperty("resend.class");
        TargetClass = Class.forName(ClassName);
        TargetMethod = TargetClass.getDeclaredMethod("init", method_args);
        target_arg[0] = prop;
        TargetMethod.invoke(null, target_arg);
        int cycle_int_value = 3600000;
        try {
            cycle_int_value = Integer.parseInt(tmp.getProperty("next.check.recycle")) * 60 * 1000;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug("CHECK INTERVAL:" + cycle_int_value);
        }
        innerManager = new SpoolingManager(cycle_int_value);
        innerManager.start();
    }

    public static synchronized void registSpool(Object spool) throws Exception {
        if (spooler_class != null) {
            spooler_class.addSpool(spool);
        } else {
            log.error("Spooler is not regist");
        }
    }

    @Override
    protected void check() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("CHECK NEXT SPOOL");
            }
            if (spooler_class.storeNext()) {
                if (log.isDebugEnabled()) {
                    log.debug("BINGO~~~!!!!!");
                }
                spooler_class.switchSpool();
            }
        }
        catch (Exception e) {
            log.error("SpoolingManager Spooler Check Error : ", (Throwable)e);
        }
    }

    public static void destroy() {
        innerManager.close();
    }
}

