/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.common.basic;

import freemarker20.template.SimpleHash;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pluto.io.eMsFileWriter;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;
import pluto.util.xml.XMLWriter;
import venus.spool.common.parser.SpoolHeaderParser;

public class SpoolInfo
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(SpoolInfo.class);
    public static final long NO_END_DURATION = 600000L;
    private static String DTD_LOCATION = null;
    private static String XML_ENC_TYPE = null;
    private static XMLWriter XML_WRITER_INSTANCE = null;
    private String spoolInfoPath = "";
    private String ID = "";
    private String sendState = "";
    private long startTime;
    private Map defaultMapping;
    private Vector spoolFilesInfo;
    private Properties spoolParallelFilesInfo;
    private String mappingHeader = "";
    private long exec_time = System.currentTimeMillis();
    private Map defaultHashMapping;
    private Map HEADER_KEY_MAP = null;
    private String spoolDelimit = null;
    private String serialDelimit = null;
    private SimpleHash DEFAULT_HASH_MAPPING_INFO = null;
    private int spoolDivideScheduleSeq = 0;
    private String startMemberId = null;
    private String lastMemberId = null;
    private int spoolSize = 0;

    protected synchronized Document getXmlDocument() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("default_hashmapping : {}", (Object)this.defaultHashMapping);
        }
        if (log.isDebugEnabled()) {
            log.debug("default_mapping : {}", (Object)this.defaultMapping);
        }
        Document returnValue = DOMParser.getEmptyDocument();
        Element spoolElements = returnValue.createElement("SPOOL");
        Element postIdElements = returnValue.createElement("POSTID");
        postIdElements.setAttribute("value", this.ID);
        spoolElements.appendChild(postIdElements);
        Element infoElements = returnValue.createElement("INFO");
        Element sendStateElements = returnValue.createElement("SENDSTATE");
        sendStateElements.setAttribute("value", this.sendState);
        infoElements.appendChild(sendStateElements);
        Element spoolSizeElement = returnValue.createElement("SIZE");
        spoolSizeElement.setAttribute("value", String.valueOf(this.spoolSize));
        spoolElements.appendChild(spoolSizeElement);
        Element divideElements = returnValue.createElement("DIVIDE");
        Element startMemberIdElement = returnValue.createElement("START_MEMBER_ID");
        startMemberIdElement.setAttribute("value", this.startMemberId);
        divideElements.appendChild(startMemberIdElement);
        Element lastMemberIdElement = returnValue.createElement("LAST_MEMBER_ID");
        lastMemberIdElement.setAttribute("value", this.lastMemberId);
        divideElements.appendChild(lastMemberIdElement);
        Element divideScheduleSeqNoElement = returnValue.createElement("SEQNO");
        divideScheduleSeqNoElement.setAttribute("value", String.valueOf(this.spoolDivideScheduleSeq));
        divideElements.appendChild(divideScheduleSeqNoElement);
        spoolElements.appendChild(divideElements);
        for (int i = 0; i < this.spoolFilesInfo.size(); ++i) {
            String key = "file" + i;
            String value = (String)this.spoolFilesInfo.get(i);
            Element varElements = returnValue.createElement("var");
            varElements.setAttribute("name", key);
            varElements.setAttribute("value", value);
            infoElements.appendChild(varElements);
        }
        spoolElements.appendChild(infoElements);
        Element mappingElements = returnValue.createElement("MAPPING");
        Element delimElements = returnValue.createElement("DELIM");
        delimElements.setAttribute("value", this.spoolDelimit);
        mappingElements.appendChild(delimElements);
        Element headerElements = returnValue.createElement("HEADER");
        headerElements.setAttribute("value", this.mappingHeader);
        mappingElements.appendChild(headerElements);
        Element commonElements = returnValue.createElement("COMMON");
        if (this.defaultMapping != null) {
            for (String key : this.defaultMapping.keySet()) {
                String value = (String)this.defaultMapping.get(key);
                Element varElements = returnValue.createElement("elm");
                varElements.setAttribute("name", key);
                CDATASection originalSection = returnValue.createCDATASection("VALUE");
                originalSection.setData(value);
                varElements.appendChild(originalSection);
                commonElements.appendChild(varElements);
            }
        }
        mappingElements.appendChild(commonElements);
        Element hashElements = returnValue.createElement("HASH");
        if (this.defaultHashMapping != null) {
            for (String key : this.defaultHashMapping.keySet()) {
                Object value = this.defaultHashMapping.get(key);
                if (value instanceof String) {
                    Element varElements = returnValue.createElement("elm");
                    varElements.setAttribute("name", key);
                    CDATASection originalSection = returnValue.createCDATASection("VALUE");
                    originalSection.setData(value.toString());
                    varElements.appendChild(originalSection);
                    hashElements.appendChild(varElements);
                    continue;
                }
                if (value instanceof List) {
                    Element listElements = returnValue.createElement("list");
                    listElements.setAttribute("name", key);
                    for (Map subMap : (List)value) {
                        Element subLoopElements = returnValue.createElement("loop");
                        if (log.isDebugEnabled()) {
                            log.debug("new loop", (Object)"start....");
                        }
                        for (String subkey : subMap.keySet()) {
                            String subvalue = (String)subMap.get(subkey);
                            Element sub_VAR_ELEMENTS = returnValue.createElement("lelm");
                            sub_VAR_ELEMENTS.setAttribute("name", subkey);
                            CDATASection ORIGINAL_SECTION = returnValue.createCDATASection("VALUE");
                            ORIGINAL_SECTION.setData(subvalue);
                            sub_VAR_ELEMENTS.appendChild(ORIGINAL_SECTION);
                            if (log.isDebugEnabled()) {
                                log.debug(subkey, (Object)subvalue);
                            }
                            subLoopElements.appendChild(sub_VAR_ELEMENTS);
                        }
                        listElements.appendChild(subLoopElements);
                    }
                    hashElements.appendChild(listElements);
                    continue;
                }
                log.error("UNKNOWN CONTENT INFO TYPE", (Object)value.getClass().toString());
            }
        }
        mappingElements.appendChild(hashElements);
        spoolElements.appendChild(mappingElements);
        returnValue.appendChild(spoolElements);
        return returnValue;
    }

    protected synchronized Document getParallelXmlDocument(String curSvrName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("default_hashmapping : {}", (Object)this.defaultHashMapping);
        }
        if (log.isDebugEnabled()) {
            log.debug("default_mapping : {}", (Object)this.defaultMapping);
        }
        Document returnValue = DOMParser.getEmptyDocument();
        Element spoolElements = returnValue.createElement("SPOOL");
        Element postIdElements = returnValue.createElement("POSTID");
        postIdElements.setAttribute("value", this.ID);
        spoolElements.appendChild(postIdElements);
        Element infoElements = returnValue.createElement("INFO");
        Element sendStateElements = returnValue.createElement("SENDSTATE");
        sendStateElements.setAttribute("value", this.sendState);
        infoElements.appendChild(sendStateElements);
        Element spoolSizeElement = returnValue.createElement("SIZE");
        spoolSizeElement.setAttribute("value", String.valueOf(this.spoolSize));
        spoolElements.appendChild(spoolSizeElement);
        Element divideElements = returnValue.createElement("DIVIDE");
        Element startMemberIdElement = returnValue.createElement("START_MEMBER_ID");
        startMemberIdElement.setAttribute("value", this.startMemberId);
        divideElements.appendChild(startMemberIdElement);
        Element lastMemberIdElement = returnValue.createElement("LAST_MEMBER_ID");
        lastMemberIdElement.setAttribute("value", this.lastMemberId);
        divideElements.appendChild(lastMemberIdElement);
        Element divideScheduleSeqNoElement = returnValue.createElement("SEQNO");
        divideScheduleSeqNoElement.setAttribute("value", String.valueOf(this.spoolDivideScheduleSeq));
        divideElements.appendChild(divideScheduleSeqNoElement);
        spoolElements.appendChild(divideElements);
        Enumeration<?> parallelSvrNms = this.spoolParallelFilesInfo.propertyNames();
        int i = 0;
        String svrKeyOrg = "";
        String svrKey = "";
        while (parallelSvrNms.hasMoreElements()) {
            svrKeyOrg = (String)parallelSvrNms.nextElement();
            if (svrKeyOrg != null) {
                svrKey = svrKeyOrg.substring(0, svrKeyOrg.indexOf("|"));
            }
            if (curSvrName == null || !curSvrName.equals(svrKey)) continue;
            String key = "file" + i++;
            String value = this.spoolParallelFilesInfo.getProperty(svrKeyOrg);
            Element varElements = returnValue.createElement("var");
            varElements.setAttribute("name", key);
            varElements.setAttribute("value", value);
            infoElements.appendChild(varElements);
        }
        spoolElements.appendChild(infoElements);
        Element mappingElements = returnValue.createElement("MAPPING");
        Element delimElements = returnValue.createElement("DELIM");
        delimElements.setAttribute("value", this.spoolDelimit);
        mappingElements.appendChild(delimElements);
        Element headerElements = returnValue.createElement("HEADER");
        headerElements.setAttribute("value", this.mappingHeader);
        mappingElements.appendChild(headerElements);
        Element commonElements = returnValue.createElement("COMMON");
        if (this.defaultMapping != null) {
            for (String key : this.defaultMapping.keySet()) {
                String value = (String)this.defaultMapping.get(key);
                Element varElements = returnValue.createElement("elm");
                varElements.setAttribute("name", key);
                CDATASection originalSection = returnValue.createCDATASection("VALUE");
                originalSection.setData(value);
                varElements.appendChild(originalSection);
                commonElements.appendChild(varElements);
            }
        }
        mappingElements.appendChild(commonElements);
        Element hashElements = returnValue.createElement("HASH");
        if (this.defaultHashMapping != null) {
            for (String key : this.defaultHashMapping.keySet()) {
                Object value = this.defaultHashMapping.get(key);
                if (value instanceof String) {
                    Element varElements = returnValue.createElement("elm");
                    varElements.setAttribute("name", key);
                    CDATASection originalSection = returnValue.createCDATASection("VALUE");
                    originalSection.setData(value.toString());
                    varElements.appendChild(originalSection);
                    hashElements.appendChild(varElements);
                    continue;
                }
                if (value instanceof List) {
                    Element listElements = returnValue.createElement("list");
                    listElements.setAttribute("name", key);
                    for (Map subMap : (List)value) {
                        Element subLoopElements = returnValue.createElement("loop");
                        if (log.isDebugEnabled()) {
                            log.debug("new loop", (Object)"start....");
                        }
                        for (String subkey : subMap.keySet()) {
                            String subvalue = (String)subMap.get(subkey);
                            Element sub_VAR_ELEMENTS = returnValue.createElement("lelm");
                            sub_VAR_ELEMENTS.setAttribute("name", subkey);
                            CDATASection ORIGINAL_SECTION = returnValue.createCDATASection("VALUE");
                            ORIGINAL_SECTION.setData(subvalue);
                            sub_VAR_ELEMENTS.appendChild(ORIGINAL_SECTION);
                            if (log.isDebugEnabled()) {
                                log.debug(subkey, (Object)subvalue);
                            }
                            subLoopElements.appendChild(sub_VAR_ELEMENTS);
                        }
                        listElements.appendChild(subLoopElements);
                    }
                    hashElements.appendChild(listElements);
                    continue;
                }
                log.error("UNKNOWN CONTENT INFO TYPE", (Object)value.getClass().toString());
            }
        }
        mappingElements.appendChild(hashElements);
        spoolElements.appendChild(mappingElements);
        returnValue.appendChild(spoolElements);
        return returnValue;
    }

    public static synchronized void toXmlFile(String out_file, SpoolInfo info) throws Exception {
        eMsFileWriter out = new eMsFileWriter(out_file);
        try {
            XML_WRITER_INSTANCE.setEncoding(XML_ENC_TYPE);
            XML_WRITER_INSTANCE.outResult(out, info.getXmlDocument(), DTD_LOCATION);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized void toXmlParallelFile(String out_file, SpoolInfo info, String curSvrName) throws Exception {
        eMsFileWriter out = new eMsFileWriter(out_file);
        try {
            XML_WRITER_INSTANCE.setEncoding(XML_ENC_TYPE);
            XML_WRITER_INSTANCE.outResult(out, info.getParallelXmlDocument(curSvrName), DTD_LOCATION);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized SpoolInfo XmlToSpoolInfo(String url) throws Exception {
        int i;
        Document DOCUMENT = DOMParser.getDocumentFromUrl(url);
        SpoolInfo returnValue = new SpoolInfo();
        Element spoolElements = (Element)DOCUMENT.getElementsByTagName("SPOOL").item(0);
        Element postIdElements = (Element)spoolElements.getElementsByTagName("POSTID").item(0);
        returnValue.setID(postIdElements.getAttribute("value"));
        Element infoElements = (Element)spoolElements.getElementsByTagName("INFO").item(0);
        Element sendStateElements = (Element)infoElements.getElementsByTagName("SENDSTATE").item(0);
        returnValue.setSendState(sendStateElements.getAttribute("value"));
        Element divideElements = (Element)spoolElements.getElementsByTagName("DIVIDE").item(0);
        Element spoolSizeElement = (Element)spoolElements.getElementsByTagName("SIZE").item(0);
        returnValue.setSpoolSize(Integer.parseInt(spoolSizeElement.getAttribute("value")));
        Element startMemberIdElements = (Element)divideElements.getElementsByTagName("START_MEMBER_ID").item(0);
        Element lastMemberIdElements = (Element)divideElements.getElementsByTagName("LAST_MEMBER_ID").item(0);
        Element seqNoElements = (Element)divideElements.getElementsByTagName("SEQNO").item(0);
        returnValue.setStartMemberId(startMemberIdElements.getAttribute("value"));
        returnValue.setSpoolDivideScheduleSeq(Integer.parseInt(seqNoElements.getAttribute("value")));
        returnValue.setLastMemberId(lastMemberIdElements.getAttribute("value"));
        NodeList propertyNodes = infoElements.getElementsByTagName("var");
        Vector<String> spoolFiles = new Vector<String>();
        for (int i2 = 0; i2 < propertyNodes.getLength(); ++i2) {
            Element varElements = (Element)propertyNodes.item(i2);
            spoolFiles.addElement(varElements.getAttribute("value"));
        }
        returnValue.setSpoolFilesInfo(spoolFiles);
        Element mappingElements = (Element)spoolElements.getElementsByTagName("MAPPING").item(0);
        Element headerDelimElements = (Element)mappingElements.getElementsByTagName("DELIM").item(0);
        returnValue.setSpoolDelimit(headerDelimElements.getAttribute("value"));
        Element headerElements = (Element)mappingElements.getElementsByTagName("HEADER").item(0);
        returnValue.setMappingHeader(headerElements.getAttribute("value"));
        Element commonElements = (Element)mappingElements.getElementsByTagName("COMMON").item(0);
        propertyNodes = commonElements.getElementsByTagName("elm");
        Properties commonMappingInfo = new Properties();
        for (int i3 = 0; i3 < propertyNodes.getLength(); ++i3) {
            Element varElements = (Element)propertyNodes.item(i3);
            commonMappingInfo.setProperty(varElements.getAttribute("name"), XMLUtil.getCDATA_SECTION(varElements, " "));
        }
        returnValue.setDefaultMapping(commonMappingInfo);
        Element hashElements = (Element)mappingElements.getElementsByTagName("HASH").item(0);
        propertyNodes = hashElements.getElementsByTagName("elm");
        Hashtable<String, Object> hashMappingInfo = new Hashtable<String, Object>();
        for (i = 0; i < propertyNodes.getLength(); ++i) {
            Element varElements = (Element)propertyNodes.item(i);
            hashMappingInfo.put(varElements.getAttribute("name"), XMLUtil.getCDATA_SECTION(varElements, " "));
        }
        propertyNodes = hashElements.getElementsByTagName("list");
        for (i = 0; i < propertyNodes.getLength(); ++i) {
            LinkedList<Properties> defaultHashList = new LinkedList<Properties>();
            Element listElements = (Element)propertyNodes.item(i);
            NodeList subLoopPropertyNodes = listElements.getElementsByTagName("loop");
            for (int sub_loop = 0; sub_loop < subLoopPropertyNodes.getLength(); ++sub_loop) {
                Element subLoopElements = (Element)subLoopPropertyNodes.item(sub_loop);
                NodeList subListPropertyNodes = subLoopElements.getElementsByTagName("lelm");
                Properties subListProperty = new Properties();
                for (int sub_i = 0; sub_i < subListPropertyNodes.getLength(); ++sub_i) {
                    Element varElements = (Element)subListPropertyNodes.item(sub_i);
                    subListProperty.setProperty(varElements.getAttribute("name"), XMLUtil.getCDATA_SECTION(varElements, " "));
                }
                defaultHashList.addLast(subListProperty);
            }
            hashMappingInfo.put(listElements.getAttribute("name"), defaultHashList);
        }
        returnValue.setDefaultHashMapping(hashMappingInfo);
        return returnValue;
    }

    public boolean expire() {
        return System.currentTimeMillis() - this.exec_time > 600000L;
    }

    public void execute() {
        this.exec_time = System.currentTimeMillis();
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getSendState() {
        return this.sendState;
    }

    public void setSendState(String sendState) {
        this.sendState = sendState;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Map getDefaultMapping() {
        return this.defaultMapping;
    }

    public void setDefaultMapping(Map defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public Vector getSpoolFilesInfo() {
        return this.spoolFilesInfo;
    }

    public void setSpoolFilesInfo(Vector prop) {
        this.spoolFilesInfo = prop;
    }

    public Properties getSpoolParallelFilesInfo() {
        return this.spoolParallelFilesInfo;
    }

    public void setSpoolParallelFilesInfo(Properties prop) {
        this.spoolParallelFilesInfo = prop;
    }

    public String getMappingHeader() {
        return this.mappingHeader;
    }

    public void setMappingHeader(String mappingHeader) {
        this.mappingHeader = mappingHeader;
    }

    public Map getDefaultHashMapping() {
        return this.defaultHashMapping;
    }

    public synchronized SimpleHash getDefaultSimpleHashMapping() {
        if (this.DEFAULT_HASH_MAPPING_INFO == null) {
            this.DEFAULT_HASH_MAPPING_INFO = SimpleHash.MapToSimpleHash((Map)this.defaultHashMapping);
        }
        return this.DEFAULT_HASH_MAPPING_INFO;
    }

    public void setDefaultHashMapping(Map defaultHashMapping) {
        this.defaultHashMapping = defaultHashMapping;
    }

    public String getSpoolDelimit() {
        return this.spoolDelimit;
    }

    public void setSpoolDelimit(String spoolDelimit) {
        this.spoolDelimit = spoolDelimit;
    }

    public String getSerialDelimit() {
        return this.serialDelimit;
    }

    public void setSerialDelimit(String serialDelimit) {
        this.serialDelimit = serialDelimit;
    }

    public SpoolInfo getClone() throws Exception {
        return (SpoolInfo)this.clone();
    }

    public synchronized Map getHEADER_KEY_MAP(String delim) {
        if (this.mappingHeader == null || this.mappingHeader.length() < 10) {
            return null;
        }
        if (this.HEADER_KEY_MAP == null) {
            this.HEADER_KEY_MAP = SpoolHeaderParser.parse(this.mappingHeader, delim);
        }
        return this.HEADER_KEY_MAP;
    }

    public static synchronized void setDTDLocation(String location) throws Exception {
        DTD_LOCATION = location;
    }

    public static synchronized void setEncoding(String enc) throws Exception {
        XML_ENC_TYPE = enc;
    }

    public static synchronized void setFileEncoding(String enc) throws Exception {
    }

    public String getSpoolInfoPath() {
        return this.spoolInfoPath;
    }

    public void setSpoolInfoPath(String string) {
        this.spoolInfoPath = string;
    }

    public int getSpoolDivideScheduleSeq() {
        return this.spoolDivideScheduleSeq;
    }

    public int getNextSpoolDivideScheduleSeq() {
        return this.spoolDivideScheduleSeq + 1;
    }

    public void setSpoolDivideScheduleSeq(int spoolDivideScheduleSeq) {
        this.spoolDivideScheduleSeq = spoolDivideScheduleSeq;
    }

    public String getStartMemberId() {
        return this.startMemberId;
    }

    public void setStartMemberId(String startMemberId) {
        this.startMemberId = startMemberId;
    }

    public String getLastMemberId() {
        return this.lastMemberId;
    }

    public void setLastMemberId(String lastMemberId) {
        this.lastMemberId = lastMemberId;
    }

    public int getSpoolSize() {
        return this.spoolSize;
    }

    public void setSpoolSize(int spoolSize) {
        this.spoolSize = spoolSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id:").append(this.ID).append(",").append("lastMemberId:").append(this.lastMemberId).append(",").append("sendState:").append(this.sendState).append(",").append("spoolSize:").append(this.spoolSize).append(",").append("spoolDivideScheduleSeq:").append(this.spoolDivideScheduleSeq).append(",").append("startMemberId:").append(this.startMemberId);
        return sb.toString();
    }

    static {
        try {
            XML_WRITER_INSTANCE = new XMLWriter();
        }
        catch (Throwable th) {
            log.error(th.getMessage());
            System.exit(1);
        }
    }
}

