/*
 * Decompiled with CFR 0.152.
 */
package venus.spool.auto.task;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.util.Cal;
import venus.spool.auto.basic.BasicDefaultMappingGenerator;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.AbstractDbSpoolTask;

public class RealTimeSpoolTask
extends AbstractDbSpoolTask {
    private static final Logger log = LoggerFactory.getLogger(RealTimeSpoolTask.class);
    public static String QUERY_SELECT_REALTIME_SCHEDULE_INFO = null;
    public static String QUERY_SELECT_LIST_LOAD_QUERY = null;
    public static String QUERY_UPDATE_LIST_STATE_QUERY = null;
    protected static String QUERY_SELECT_REALTIME_TABLE_INFO = null;
    protected static String QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO = null;
    public static String QUERY_UPDATE_SCHD_FILTERED_TARGET = null;
    public static String QUERY_UPDATE_FATIGUE_N_FILTER = null;
    public static String QUERY_SELECT_FATIGUE_LIST = null;
    public static String QUERY_UPSERT_FATIGUE_LIST = null;
    protected String instance_QUERY_TARGET_TABLE_INFO = null;

    public RealTimeSpoolTask() throws Exception {
        super((short)2, 1L);
        this.setName("RealTimeSpoolTask");
        this.setTaskID("RealTimeSpoolTask");
    }

    public static void init(Object tmp) throws Exception {
    }

    @Override
    public void setTaskProperty(Properties send_info) {
        if (this.TASK_PROPERTY == null) {
            this.TASK_PROPERTY = new Properties();
        }
        if (send_info != null) {
            this.TASK_PROPERTY.putAll((Map<?, ?>)send_info);
        }
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.rowid = this.TASK_PROPERTY.getProperty("ROW_ID");
        this.os = this.TASK_PROPERTY.getProperty("OS");
        this.notiflag = this.TASK_PROPERTY.getProperty("NOTI_FLAG");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat(Cal.getSerialDateMilli());
        this.setTaskID(this.POST_ID);
        this.setName(this.POST_ID + "_RealTimeSpoolTask");
        this.SELECT_TARGET_LIST_QUERY = QUERY_SELECT_LIST_LOAD_QUERY;
        this.UPDATE_TARGET_LIST_QUERY = QUERY_UPDATE_LIST_STATE_QUERY;
        this.instance_QUERY_TARGET_TABLE_INFO = QUERY_SELECT_REALTIME_TABLE_INFO;
        this.UPDATE_FATIGUE_N_FILTER = QUERY_UPDATE_FATIGUE_N_FILTER;
        this.UPSERT_FATIGUE_LIST_QUERY = QUERY_UPSERT_FATIGUE_LIST;
        this.SELECT_TARGET_FATIGUE_LIST_QUERY = QUERY_SELECT_FATIGUE_LIST;
        this.UPDATE_SCHD_FILTERED_TARGET = QUERY_UPDATE_SCHD_FILTERED_TARGET;
        this.SPOOL_ANALYZER.setSendType("AUTO");
        this.SPOOL_ANALYZER.setNextSpoolGenerate("Y");
        this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    public void execute_initiate() throws Exception {
        super.execute_initiate();
        this.WORK_FILE_ID = "realtime_".concat(this.POST_ID + "_").concat(Cal.getSerialDateMilli());
        this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
        this.SPOOL_ANALYZER.setStep(0);
    }

    @Override
    public void makeSpoolFile() throws Exception {
        eMsStatement __EMS_EXEC_STATEMENT__ = null;
        eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
        LinkedList<Properties> TARGET_TABLE_LIST = new LinkedList<Properties>();
        if (log.isDebugEnabled()) {
            log.debug("CALL GET TARGET TABLE LIST SQL");
        }
        try {
            __EMS_EXEC_STATEMENT__ = this.EMS_CONNECTION.createStatement();
            RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery(this.instance_QUERY_TARGET_TABLE_INFO);
            while (RS_SELECTED_SCHEDULE_INFO.next()) {
                Properties prop = new Properties();
                RS_SELECTED_SCHEDULE_INFO.putToMap(prop, false);
                TARGET_TABLE_LIST.addLast(prop);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw e;
        }
        finally {
            try {
                RS_SELECTED_SCHEDULE_INFO.close();
            }
            catch (Exception exception) {}
            this.EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
        }
        String this_day = Cal.getDayDate();
        String __SPOOL_FILE_NAME__ = FileElement.CheckSubDirectory(SPOOL_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".spool";
        this.SPOOL_FILE_LIST.clear();
        this.LIST_APPEND_FLAG = false;
        try {
            this.openSpooler(__SPOOL_FILE_NAME__);
            for (Properties prop : TARGET_TABLE_LIST) {
                prop.setProperty("WORKDAY", this.TASK_PROPERTY.getProperty("WORKDAY"));
                prop.setProperty("SEQNO", this.TASK_PROPERTY.getProperty("SEQNO"));
                this.execute_ListLoad(prop);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            throw e;
        }
        finally {
            this.closeSpooler();
            if (!this.LIST_APPEND_FLAG) {
                this.deleteSpooler();
                if (log.isDebugEnabled()) {
                    log.debug(this.getName() + "NO APPEND LIST FILE");
                }
            }
        }
    }

    @Override
    protected void makeSpoolInfo() throws Exception {
        String mapheader;
        this.mailSpoolInfo = new SpoolInfo();
        this.mailSpoolInfo.setID(this.POST_ID);
        this.mailSpoolInfo.setSendState("REAL");
        String string = mapheader = this.MAPPING_HEADER_INFO == null ? this.TASK_PROPERTY.getProperty("MAPPINGHEADER") : this.MAPPING_HEADER_INFO.getProperty(this.POST_ID);
        if (mapheader == null) {
            mapheader = "map_";
        }
        this.mailSpoolInfo.setMappingHeader(mapheader == null ? this.getMappingHeader() : mapheader);
        this.mailSpoolInfo.setSpoolDelimit(eMsSystem.getProperty("spool.delimit", "|"));
        String value = this.TASK_PROPERTY.getProperty("SERIAL_DELIM");
        this.mailSpoolInfo.setSerialDelimit(value == null ? "|" : value);
        this.mailSpoolInfo.setSpoolFilesInfo(this.SPOOL_FILE_LIST);
        BasicDefaultMappingGenerator __DEFAULT_MAPPING_GENERATOR__ = new BasicDefaultMappingGenerator();
        __DEFAULT_MAPPING_GENERATOR__.process(this.TASK_PROPERTY);
        this.mailSpoolInfo.setDefaultMapping(__DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultMapping());
        this.mailSpoolInfo.setDefaultHashMapping(__DEFAULT_MAPPING_GENERATOR__.getMapOfDefaultHashMapping());
        SpoolInfoManager.registSpoolInfo(this.mailSpoolInfo);
    }

    @Override
    protected void addSpool(Properties prop) throws Exception {
        this.SPOOL_ANALYZER.setRowid(prop.getProperty("ROW_ID"));
        this.SPOOL_ANALYZER.setOs(prop.getProperty("OS"));
        this.SPOOL_ANALYZER.setNotiflag(prop.getProperty("NOTI_FLAG"));
        this.SPOOL_ANALYZER.setPostID(prop.getProperty("POST_ID"));
        this.SPOOL_ANALYZER.setListTable(prop.getProperty("LIST_TABLE"));
        this.SPOOL_ANALYZER.setTokenID(prop.getProperty("TMS_M_TOKEN"));
        this.SPOOL_ANALYZER.setMemberID(prop.getProperty("TMS_M_ID"));
        this.SPOOL_ANALYZER.setMemberName(prop.getProperty("TMS_M_NAME"));
        this.SPOOL_ANALYZER.setSecureFlag(prop.getProperty("SECURE_FLAG"));
        this.SPOOL_ANALYZER.setAdditionalValue(prop.getProperty("ADDITIONAL_INFO"));
        this.SPOOL_ANALYZER.setMapping(prop.getProperty("MAPPING"));
        this.appendSpooler(this.SPOOL_ANALYZER.composeSingleRcptSend());
    }

    protected boolean execute_StopCheck() {
        log.info("CHECK STOP SIGNAL");
        return false;
    }

    protected void processSyntaxErrorSpool(String spool) throws Exception {
    }

    static {
        try {
            QUERY_SELECT_REALTIME_SCHEDULE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_SCHEDULE_INFO");
            QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("COMMON", "QUERY_SELECT_LIST_LOAD_QUERY");
            QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("COMMON", "QUERY_UPDATE_LIST_STATE_QUERY");
            QUERY_SELECT_REALTIME_TABLE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_TABLE_INFO");
            QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO");
            QUERY_UPDATE_FATIGUE_N_FILTER = SqlManager.getQuery("FATIGUE", "QUERY_UPDATE_FATIGUE_N_FILTER");
            QUERY_SELECT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_SELECT_FILTER_USEYN");
            QUERY_UPSERT_FATIGUE_LIST = SqlManager.getQuery("FATIGUE", "QUERY_UPSERT_FATIGUE_LIST");
            QUERY_UPDATE_SCHD_FILTERED_TARGET = SqlManager.getQuery("FATIGUE", "QUERY_UPDATE_SCHD_FILTERED_TARGET");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

