/*
 * Decompiled with CFR 0.152.
 */
package pluto.util.convert;

public class HtmlTableFilter {
    public static final String[] INDEX_PLUS = new String[]{"<table", "<tr", "<td", "<body"};
    public static final String[] INDEX_MINUS = new String[]{"</table", "</tr", "</td", "</body"};
    public static final String[] INDEX_NO_INDENT = new String[]{"<if", "<list", "</if", "</list", "<comment", "<compress", "</compress"};
    public static final String Start = "<";
    public static final int len_Start = "<".length();
    public static final String End = ">";
    public static final int len_End = ">".length();
    private int indent_idx = 0;
    private String original = null;
    private String convert = null;
    private String open_tag = null;
    private String close_tag = null;

    public HtmlTableFilter(String src) {
        this.original = src;
        this.convert = src.toLowerCase();
    }

    public String parse() {
        StringBuffer tmpBuffer = new StringBuffer();
        int idx1 = 0;
        int idx2 = 0;
        this.indent_idx = 0;
        while ((idx1 = this.convert.indexOf(Start, idx2)) >= 0) {
            int i;
            tmpBuffer.append(this.original.substring(idx2, idx1).trim());
            idx2 = this.convert.indexOf(End, idx1 + len_Start);
            if (idx2 < 0) break;
            String tag = this.convert.substring(idx1, idx2 += len_End);
            if (this.isPlus(tag)) {
                tmpBuffer.append("\r\n");
                for (i = 0; i < this.indent_idx; ++i) {
                    tmpBuffer.append("\t");
                }
                ++this.indent_idx;
            } else if (this.isMinus(tag)) {
                --this.indent_idx;
                if (!this.open_tag.equals("<td") || !this.close_tag.equals("</td")) {
                    tmpBuffer.append("\r\n");
                    for (i = 0; i < this.indent_idx; ++i) {
                        tmpBuffer.append("\t");
                    }
                }
                this.open_tag = "none";
            } else if (this.isIndent(tag)) {
                tmpBuffer.append("\r\n");
            } else {
                tmpBuffer.append("\r\n");
                for (i = 0; i < this.indent_idx; ++i) {
                    tmpBuffer.append("\t");
                }
            }
            tmpBuffer.append(this.original.substring(idx1, idx2));
        }
        if (idx1 < 0) {
            tmpBuffer.append(this.original.substring(idx2));
        } else {
            tmpBuffer.append(this.original.substring(idx1));
        }
        return tmpBuffer.toString();
    }

    private boolean isPlus(String src) {
        if (src == null) {
            return false;
        }
        for (int i = 0; i < INDEX_PLUS.length; ++i) {
            if (!src.startsWith(INDEX_PLUS[i])) continue;
            this.open_tag = INDEX_PLUS[i];
            return true;
        }
        return false;
    }

    private boolean isMinus(String src) {
        if (src == null) {
            return false;
        }
        for (int i = 0; i < INDEX_MINUS.length; ++i) {
            if (!src.startsWith(INDEX_MINUS[i])) continue;
            this.close_tag = INDEX_MINUS[i];
            return true;
        }
        return false;
    }

    private boolean isIndent(String src) {
        if (src == null) {
            return false;
        }
        for (int i = 0; i < INDEX_NO_INDENT.length; ++i) {
            if (!src.startsWith(INDEX_NO_INDENT[i])) continue;
            return true;
        }
        return false;
    }
}

