/*
 * Decompiled with CFR 0.152.
 */
package pluto.util;

import java.util.NoSuchElementException;

public class FIFOBuffer {
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private int MAXIMUM_SIZE = -1;

    public FIFOBuffer(int max) {
        this.header.next = this.header.previous = this.header;
        this.MAXIMUM_SIZE = max;
    }

    public synchronized void reSize(int max) {
        this.MAXIMUM_SIZE = max;
    }

    public synchronized boolean contains(Object o) {
        return this.indexOf(o) > 0;
    }

    public synchronized boolean push(Object o) {
        if (o == null) {
            throw new NullPointerException("CAN NOT INSERT NULL");
        }
        if (this.MAXIMUM_SIZE > 0 && this.size >= this.MAXIMUM_SIZE) {
            return false;
        }
        this.addBefore(o, this.header);
        return true;
    }

    public synchronized Object pop() {
        if (this.size == 0) {
            return null;
        }
        Object first = this.header.next.element;
        this.remove(this.header.next);
        return first;
    }

    private void addBefore(Object o, Entry e) {
        Entry newEntry;
        newEntry.previous.next = newEntry = new Entry(o, e, e.previous);
        newEntry.next.previous = newEntry;
        ++this.size;
    }

    public synchronized boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Entry e = this.header.next;
        while (e != this.header) {
            if (o.equals(e.element)) {
                this.remove(e);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    private void remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
    }

    private int indexOf(Object o) {
        int index = 1;
        if (o == null) {
            return -1;
        }
        Entry e = this.header.next;
        while (e != this.header) {
            if (o.equals(e.element)) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    public int size() {
        return this.size;
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }
}

