/*
 * Decompiled with CFR 0.152.
 */
package pluto.secure.crypto;

import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.eMsSystem;
import pluto.lang.Tracer;
import pluto.util.StringUtil;

public class CryptoUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);
    public static final String TMS_DECRYPT_TAG = "<TMS_DECRYPT>";
    public static final String SOCIAL_ID = "RRN_ENCR";
    public static final String CARD_NUM = "CRDT_CARD_NO_ENCR";
    public static final String ACCOUNT_NUM = "ACCN_NO_ENCR";
    public static final String TEL_NUM = "TELNO_ENCR";
    public static final String DETAIL_ADDR = "DTLAD_ENCR";
    public static final String EMAIL_ADDR = "EMAIL_ADDR_ENCR";
    public static final String SYSTEM_INFO = "SYSTM_DSMT_INFO_ENCR";
    private static String ENC_PA;
    private static String SAFEDB_USERID;
    private static String SAFEDB_TABLENAME;
    private static String SAFEDB_CHARSET;

    public static String encrypt_test(String str, String colname) {
        if (StringUtil.isNull(str)) {
            return str;
        }
        String test_str = "";
        test_str = new StringBuffer(str).reverse().toString();
        if (log.isDebugEnabled()) {
            Tracer.debug("COLUMN[" + colname + "], PLAIN[" + str + "], ENCRYPT[" + test_str + "]");
        }
        return test_str;
    }

    public static String encrypt(String str, String colname) {
        if (StringUtil.isNull(str)) {
            return str;
        }
        String enc_str = "";
        enc_str = HumusonEncryptor.encrypt((String)str, (String)ENC_PA, (boolean)false);
        if (log.isDebugEnabled()) {
            Tracer.debug("COLUMN[" + colname + "], PLAIN[" + str + "], ENCRYPT[" + enc_str + "]");
        }
        return enc_str;
    }

    public static String decrypt_test(String str, String colname) {
        if (StringUtil.isNull(str)) {
            return str;
        }
        String test_str = "";
        test_str = new StringBuffer(str).reverse().toString();
        if (log.isDebugEnabled()) {
            Tracer.debug("COLUMN[" + colname + "], ENCRYPT[" + str + "], DECRYPT[" + test_str + "]");
        }
        return test_str;
    }

    public static String decrypt(String str, String colname) {
        return CryptoUtil.decrypt(str, colname, ENC_PA);
    }

    public static String decrypt(String str, String colname, String encPa) {
        if (StringUtil.isNull(str)) {
            return str;
        }
        String dec_str = "";
        try {
            dec_str = HumusonDecryptor.decrypt((String)str, (String)encPa, (boolean)false);
            if (log.isDebugEnabled()) {
                Tracer.debug("COLUMN[" + colname + "], PLAIN[" + str + "], ENCRYPT[" + dec_str + "]");
            }
            return dec_str;
        }
        catch (Exception e) {
            Tracer.error("Decrypt error", e);
            return dec_str;
        }
    }

    public static void main(String[] args) {
        String a = null;
        try {
            a = "ru/p3uUZcx5Sa0N7dU//PiH9nuR+x+yXhXT+K7YXSls=";
            a = CryptoUtil.deEmailAddr(a);
            System.out.println(a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            a = "iyYPtx0Z77YeWZ9pqHcdk5yVavDBjuABL/BOBJuyJb0=";
            a = CryptoUtil.deEmailAddr(a);
            System.out.println(a);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String deSocialId(String str) {
        return CryptoUtil.decrypt(str, SOCIAL_ID);
    }

    public static String enSocialId(String str) {
        return CryptoUtil.encrypt(str, SOCIAL_ID);
    }

    public static String deCardNum(String str) {
        return CryptoUtil.decrypt(str, CARD_NUM);
    }

    public static String enCardNum(String str) {
        return CryptoUtil.encrypt(str, CARD_NUM);
    }

    public static String deAccuntNum(String str) {
        return CryptoUtil.decrypt(str, ACCOUNT_NUM);
    }

    public static String enAccuntNum(String str) {
        return CryptoUtil.encrypt(str, ACCOUNT_NUM);
    }

    public static String deTelNum(String str) {
        return CryptoUtil.decrypt(str, TEL_NUM);
    }

    public static String enTelNum(String str) {
        return CryptoUtil.encrypt(str, TEL_NUM);
    }

    public static String deDetailAddr(String str) {
        return CryptoUtil.decrypt(str, DETAIL_ADDR);
    }

    public static String enDetailAddr(String str) {
        return CryptoUtil.encrypt(str, DETAIL_ADDR);
    }

    public static String deEmailAddr(String str) {
        return CryptoUtil.decrypt(str, EMAIL_ADDR);
    }

    public static String enEmailAddr(String str) {
        return CryptoUtil.encrypt(str, EMAIL_ADDR);
    }

    public static String deSystemInfo(String str) {
        return CryptoUtil.decrypt(str, SYSTEM_INFO);
    }

    public static String enSystemInfo(String str) {
        return CryptoUtil.encrypt(str, SYSTEM_INFO);
    }

    static {
        SAFEDB_USERID = "";
        SAFEDB_TABLENAME = "";
        SAFEDB_CHARSET = "";
        try {
            ENC_PA = eMsSystem.getProperty("member.info.encrypt.key", "amail0722!@");
            SAFEDB_USERID = eMsSystem.getProperty("safedb.userid", "SAFEPOLICY");
            SAFEDB_TABLENAME = eMsSystem.getProperty("safedb.tablename", "POLICY.POLICY_TB");
            SAFEDB_CHARSET = eMsSystem.getProperty("safedb.charset", "EUC-KR");
        }
        catch (Exception e) {
            Tracer.error("INIT ERROR", e);
        }
    }
}

