/*
 * Decompiled with CFR 0.152.
 */
package pluto.schedule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.Name;

public abstract class ScheduledMonitor
extends Name
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ScheduledMonitor.class);
    private Object lockOfScheduledMonitor = null;
    protected Thread internal_thread = null;
    protected boolean internal_thread_alive = true;
    private long INTERNAL_THREAD_CHECK_INTERVAL = 60000L;

    protected ScheduledMonitor() {
        this(60000L);
    }

    protected ScheduledMonitor(long size) {
        this(size, null);
    }

    protected ScheduledMonitor(String name) {
        this(60000L, name);
    }

    protected ScheduledMonitor(long size, String name) {
        this.INTERNAL_THREAD_CHECK_INTERVAL = size;
        this.setName(name);
    }

    public void start() {
        this.lockOfScheduledMonitor = new Object();
        this.internal_thread = this.getName() == null ? new Thread(this) : new Thread((Runnable)this, this.getName());
        this.internal_thread.setPriority(5);
        this.internal_thread.start();
    }

    public void close() {
        this.internal_thread_alive = false;
        try {
            this.internal_thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void interruptInnerThread() {
        try {
            this.internal_thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.internal_thread_alive) {
            try {
                Thread.sleep(this.INTERNAL_THREAD_CHECK_INTERVAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = this.lockOfScheduledMonitor;
            synchronized (object) {
                try {
                    this.check();
                }
                catch (Exception e) {
                    log.error(this.getName(), (Throwable)e);
                }
            }
        }
    }

    protected abstract void check() throws Exception;
}

