/*
 * Decompiled with CFR 0.152.
 */
package pluto.panopticon.monitor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class MailSendDomainFilter {
    private static final Logger log = LoggerFactory.getLogger(MailSendDomainFilter.class);
    private static Hashtable DOMAIN_HASH = null;
    private static boolean INIT_FLAG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        if (log.isDebugEnabled()) {
            log.debug("[MailSendDomainFilter]...[init]");
        }
        eMsConnection EMS_CONNECTION = null;
        eMsStatement EMS_STATEMENT = null;
        eMsResultSet rs = null;
        boolean use_flag = false;
        String QUERY_DOMAIN_FILTER_LIST = SqlManager.getQuery("SEND_DOMAIN_FILTER", "QUERY_DOMAIN_FILTER_LIST");
        String QUERY_DOMAIN_FILTER_YN = SqlManager.getQuery("SEND_DOMAIN_FILTER", "QUERY_DOMAIN_FILTER_YN");
        Properties ppt = new Properties();
        ppt.setProperty("NOWTIME_LONG", "" + System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug("[NOWTIME_LONG]..." + System.currentTimeMillis());
        }
        StringBuffer TMP_STRING_BUFFER = new StringBuffer(1024);
        StringConvertUtil.ConvertString(TMP_STRING_BUFFER, QUERY_DOMAIN_FILTER_LIST, ppt, "${", "}", true, false);
        try {
            EMS_CONNECTION = ConnectionPool.getConnection();
            EMS_STATEMENT = EMS_CONNECTION.createStatement();
            rs = EMS_STATEMENT.executeQuery(TMP_STRING_BUFFER.toString());
            while (rs.next()) {
                MailSendDomainFilter.registeFilteringDomain(rs.getString("LIMIT_TIME"), rs.getString("DOMAIN"));
                log.info("[LIMIT_TIME]" + rs.getString("LIMIT_TIME") + " [DOMAIN]" + rs.getString("DOMAIN"));
            }
            rs = EMS_STATEMENT.executeQuery(QUERY_DOMAIN_FILTER_YN);
            if (rs.next()) {
                log.info("[USE_YN]..." + rs.getString("USE_YN"));
                if (rs.getString("USE_YN").equals("Y")) {
                    INIT_FLAG = true;
                }
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            EMS_CONNECTION.recycleStatement(EMS_STATEMENT);
            EMS_CONNECTION.recycle();
        }
    }

    public static boolean isFilterPresent() {
        return INIT_FLAG;
    }

    public static void setINIT_FLAG(boolean init_flag) {
        INIT_FLAG = init_flag;
    }

    public static synchronized boolean isTargetDomain(String domain) {
        LongDateValue limittime = (LongDateValue)DOMAIN_HASH.get(domain.toLowerCase());
        if (limittime == null) {
            if (log.isDebugEnabled()) {
                log.debug("[limittime]...[null : return false]");
            }
            return false;
        }
        if (limittime.getValue() < System.currentTimeMillis()) {
            DOMAIN_HASH.remove(domain.toLowerCase());
            if (log.isDebugEnabled()) {
                log.debug("[limittime]...[time over : return false]");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[limittime]...[return true]");
        }
        return true;
    }

    public static synchronized void registeFilteringDomain(String domain) {
        LongDateValue limittime = (LongDateValue)DOMAIN_HASH.get(domain);
        if (limittime == null) {
            DOMAIN_HASH.put(domain.toLowerCase(), new LongDateValue(System.currentTimeMillis() + 86400000L));
        } else {
            limittime.setValue(System.currentTimeMillis() + 86400000L);
        }
    }

    public static synchronized void registeFilteringDomain(String act_time, String domain) {
        long atime = Long.parseLong(act_time);
        LongDateValue limittime = (LongDateValue)DOMAIN_HASH.get(domain);
        if (limittime == null) {
            DOMAIN_HASH.put(domain.toLowerCase(), new LongDateValue(atime));
        } else {
            limittime.setValue(atime);
        }
    }

    public static synchronized void deRegisterFilteringDomain(String domain) {
        DOMAIN_HASH.remove(domain.toLowerCase());
    }

    public static synchronized String getInfo() {
        StringBuffer buffer = new StringBuffer(512);
        Enumeration eNum = DOMAIN_HASH.keys();
        while (eNum.hasMoreElements()) {
            Object key = eNum.nextElement();
            LongDateValue limittime = (LongDateValue)DOMAIN_HASH.get(key);
            if (limittime.getValue() < System.currentTimeMillis()) {
                DOMAIN_HASH.remove(key);
                continue;
            }
            buffer.append(key.toString());
            buffer.append("=");
            buffer.append(limittime.toString());
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static void main(String[] arg) throws Exception {
        System.out.println(System.currentTimeMillis());
        MailSendDomainFilter.init(null);
        MailSendDomainFilter.registeFilteringDomain("amail.co.kr");
        MailSendDomainFilter.registeFilteringDomain("bmail.co.kr");
        System.out.println(MailSendDomainFilter.getInfo());
        Thread.sleep(1000L);
        MailSendDomainFilter.registeFilteringDomain("amail.co.kr");
        System.out.println(MailSendDomainFilter.getInfo());
        MailSendDomainFilter.deRegisterFilteringDomain("amail.co.kr");
        System.out.println(MailSendDomainFilter.getInfo());
    }

    static {
        DOMAIN_HASH = new Hashtable();
        INIT_FLAG = false;
    }

    static class LongDateValue {
        long value = 0L;

        LongDateValue(long a) {
            this.setValue(a);
        }

        long getValue() {
            return this.value;
        }

        void setValue(long a) {
            this.value = a;
        }

        public String toString() {
            return Cal.getDate(this.value);
        }
    }
}

