/*
 * Decompiled with CFR 0.152.
 */
package pluto.nio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import pluto.io.eMsFileWriter;
import pluto.lang.eMsLocale;

public class FileInstanceFactory {
    public static final eMsFileWriter geteMsFileWriter(OutputStream stream, String charset) throws IOException {
        eMsFileWriter pw = new eMsFileWriter(stream, charset);
        return pw;
    }

    public static final eMsFileWriter geteMsFileWriter(File file, String charset) throws IOException {
        return FileInstanceFactory.geteMsFileWriter(new FileOutputStream(file), charset);
    }

    public static final eMsFileWriter geteMsFileWriter(String filename, String charset) throws IOException {
        return FileInstanceFactory.geteMsFileWriter(new File(filename), charset);
    }

    public static final eMsFileWriter geteMsFileWriter(String filename) throws IOException {
        return FileInstanceFactory.geteMsFileWriter(new File(filename), eMsLocale.FILE_SYSTEM_OUT_CHAR_SET);
    }

    public static final BufferedReader getBufferedReader(String filename) throws IOException {
        return FileInstanceFactory.getBufferedReader(new File(filename));
    }

    public static final BufferedReader getBufferedReader(File file) throws IOException {
        return FileInstanceFactory.getBufferedReader(new FileInputStream(file));
    }

    public static final BufferedReader getBufferedReader(InputStream file) throws IOException {
        return new BufferedReader(new InputStreamReader(file, eMsLocale.FILE_SYSTEM_IN_CHAR_SET));
    }
}

