/*
 * Decompiled with CFR 0.152.
 */
package pluto.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import pluto.nio.LimitSizeExceedException;

public class ByteLineReader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private InputStream in;
    private byte[] cb;
    private int nChars;
    private int nextChar;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private static int defaultByteBufferSize = 8192;

    public ByteLineReader(InputStream in, int sz) {
        this.in = in;
        this.cb = new byte[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public ByteLineReader(InputStream in) {
        this(in, defaultByteBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    byte[] ncb = new byte[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.available() > 0) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == 10) {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.available() > 0;
        }
    }

    public void writeLineToStream(OutputStream buffer, int limit) throws IOException {
        boolean omitLF = this.skipLF;
        int iAppendSize = 0;
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            this.ensureOpen();
            while (true) {
                int i;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return;
                }
                boolean eol = false;
                byte c = 0;
                if (!omitLF || this.cb[this.nextChar] == 10) {
                    // empty if block
                }
                this.skipLF = false;
                omitLF = false;
                for (i = ++this.nextChar; i < this.nChars; ++i) {
                    c = this.cb[i];
                    if (c != 10 && c != 13) continue;
                    eol = true;
                    break;
                }
                int startChar = this.nextChar;
                this.nextChar = i;
                if (eol) {
                    if (limit > 0 && (iAppendSize += i - startChar) > limit) {
                        throw new LimitSizeExceedException("LINE LIMIT OVERFLOW:" + String.valueOf(iAppendSize) + " LIMIT:" + limit);
                    }
                    buffer.write(this.cb, startChar, i - startChar);
                    ++this.nextChar;
                    if (c == 13) {
                        this.skipLF = true;
                    }
                    return;
                }
                if (limit > 0 && (iAppendSize += i - startChar) > limit) {
                    throw new LimitSizeExceedException("LINE LIMIT OVERFLOW:" + String.valueOf(iAppendSize) + " LIMIT:" + limit);
                }
                buffer.write(this.cb, startChar, i - startChar);
            }
        }
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.in = null;
    }
}

