/*
 * Decompiled with CFR 0.152.
 */
package pluto.net.communicator;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.net.communicator.MQConsumer;

public class ActiveMQServerActivator
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQServerActivator.class);
    protected static boolean DEBUG_FLAG = true;
    protected static String BROKER_URL = "";
    protected static String BROKER_ID = "";
    protected static String BROKER_PASSWD = "";
    protected static String RESPONSE_MQ_NAME = "";
    protected static int CONSUMER_SIZE = 0;
    protected static Properties PROP = null;
    protected static String ENG_TYPE = "";

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        BROKER_URL = prop.getProperty("activemq.broker.url");
        RESPONSE_MQ_NAME = prop.getProperty("response.activemq.que.name");
        CONSUMER_SIZE = Integer.parseInt(prop.getProperty("consumer.size", "5"));
        ActiveMQServerActivator.infoReport(prop);
    }

    @Override
    public void run() {
        int consumerCnt = 0;
        log.debug("========= MQ start() START =========");
        for (int k = 0; k < CONSUMER_SIZE; ++k) {
            ++consumerCnt;
            Properties prp = new Properties();
            prp.setProperty("BROKER_URL", BROKER_URL);
            prp.setProperty("RESPONSE_MQ_NAME", RESPONSE_MQ_NAME);
            MQConsumer CONSUMER = new MQConsumer(prp);
            try {
                CONSUMER.start();
                Thread.currentThread();
                Thread.sleep(200L);
                continue;
            }
            catch (Exception e) {
                log.error("Error MqConsumer  Start :{} ", (Throwable)e);
                CONSUMER.release();
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        log.debug("========= MQ start() END =========");
        log.debug("MQ CONSUMER SIZE...." + consumerCnt);
    }

    public static void infoReport(Properties prop) {
        log.debug("activemq.broker.url : {}", (Object)prop.getProperty("activemq.broker.url"));
        log.debug("response.activemq.name : {}", (Object)prop.getProperty("response.activemq.name"));
        log.debug("consumer.size: {}", (Object)prop.getProperty("consumer.size", "5"));
    }
}

