/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.TelnetOutputStream;
import pluto.ioutil.FileUtil;
import pluto.net.SocketAgent;

public class SocketReaderAgent
extends SocketAgent {
    private static final Logger log = LoggerFactory.getLogger(SocketReaderAgent.class);
    protected BufferedReader SMTP_STRING_READER = null;
    protected TelnetOutputStream SMTP_BINARY_OUTSTREAM = null;

    public SocketReaderAgent() {
        super(false);
    }

    public SocketReaderAgent(boolean regist) {
        super(regist);
    }

    @Override
    protected void openConnection() throws IOException {
        this.SMTP_STRING_READER = new BufferedReader(new InputStreamReader(this.CONNECTED_SOCKET.getInputStream()));
        this.SMTP_BINARY_OUTSTREAM = new TelnetOutputStream(this.CONNECTED_SOCKET.getOutputStream());
    }

    @Override
    public void killSession() {
        FileUtil.close(this.SMTP_STRING_READER);
        FileUtil.close(this.SMTP_BINARY_OUTSTREAM);
        super.killSession();
    }

    @Override
    protected void send(String source) throws IOException {
        if (source == null) {
            return;
        }
        if (source.length() == 0) {
            this.SMTP_BINARY_OUTSTREAM.writeln();
        } else {
            if (log.isDebugEnabled()) {
                log.debug(source);
            }
            this.SMTP_BINARY_OUTSTREAM.write(source);
            this.SMTP_BINARY_OUTSTREAM.writeln();
        }
    }

    @Override
    protected void send(byte[] source) throws IOException {
        if (source == null) {
            return;
        }
        if (source.length == 0) {
            this.SMTP_BINARY_OUTSTREAM.writeln();
        } else {
            if (log.isDebugEnabled()) {
                log.debug(new String(source));
            }
            this.SMTP_BINARY_OUTSTREAM.write(source);
            this.SMTP_BINARY_OUTSTREAM.writeln();
        }
    }

    protected String receive() throws IOException {
        String readLIne = this.SMTP_STRING_READER.readLine();
        if (log.isDebugEnabled()) {
            log.debug(readLIne);
        }
        return readLIne;
    }
}

