/*
 * Decompiled with CFR 0.152.
 */
package pluto.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.ByteArrayContainer;
import pluto.lang.Name;
import pluto.mail.mx.LookupUtil;
import pluto.net.NetworkMonitorable;

public class MonitorableSocket
extends Name
implements NetworkMonitorable {
    private static final Logger log = LoggerFactory.getLogger(MonitorableSocket.class);
    private static final int BYTE_CR = 13;
    private static final int BYTE_LF = 10;
    private int TIME_OUT = 0;
    private boolean IN_COMM = false;
    private long COMM_START_TIME = 0L;
    protected Socket CONNECTED_SOCKET = null;
    private InputStream SOCKET_INPUT_STREAM = null;
    private OutputStream SOCKET_OUTPUT_STREAM = null;
    private String CHAR_SET = null;
    protected String CONNECT_HOST;

    public MonitorableSocket(String charset) {
        try {
            "abc".getBytes(charset);
            this.CHAR_SET = charset;
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            this.CHAR_SET = null;
        }
    }

    @Override
    public String getConnectHost() {
        return this.CONNECT_HOST;
    }

    @Override
    public boolean isIdle() {
        return this.IN_COMM && System.currentTimeMillis() - this.COMM_START_TIME > (long)this.TIME_OUT;
    }

    @Override
    public void killSession() {
        if (this.CONNECTED_SOCKET != null) {
            try {
                this.CONNECTED_SOCKET.shutdownInput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.CONNECTED_SOCKET.shutdownOutput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.CONNECTED_SOCKET.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.IN_COMM = false;
            this.CONNECTED_SOCKET = null;
        }
    }

    public void close() {
        this.killSession();
        this.CONNECT_HOST = null;
        this.COMM_START_TIME = -1L;
    }

    protected final void connect(String host, int iIP, int port) throws IOException {
        this.COMM_START_TIME = System.currentTimeMillis();
        this.IN_COMM = false;
        this.CONNECT_HOST = null;
        InetAddress address = LookupUtil.getInetAddress(iIP);
        this.CONNECTED_SOCKET = new Socket(address, port);
        this.CONNECT_HOST = host.concat("[").concat(address.getHostAddress()).concat("]");
        this.IN_COMM = true;
        this.SOCKET_INPUT_STREAM = this.CONNECTED_SOCKET.getInputStream();
        this.SOCKET_OUTPUT_STREAM = this.CONNECTED_SOCKET.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveLine() throws IOException {
        eMsByteArrayOutputStream out = null;
        byte[] buffer = null;
        try {
            out = eMsByteArrayOutputStream.getInstance();
            buffer = ByteArrayContainer.getInstance();
            this.SOCKET_INPUT_STREAM.read(buffer);
            String string = this.CHAR_SET == null ? out.toString() : out.toString(this.CHAR_SET);
            return string;
        }
        finally {
            eMsByteArrayOutputStream.recycleInstance(out);
            ByteArrayContainer.recycleInstance(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] sendBytes, boolean flagTelnet) throws IOException {
        if (flagTelnet) {
            byte[] transfer = null;
            int count = 0;
            int lastb = 0;
            try {
                transfer = ByteArrayContainer.getInstance();
                for (int i = 0; i < sendBytes.length; ++i) {
                    if (sendBytes[i] == 13) {
                        if (count > 0) {
                            this.SOCKET_OUTPUT_STREAM.write(transfer, 0, count);
                            count = 0;
                        }
                        this.SOCKET_OUTPUT_STREAM.write(13);
                        this.SOCKET_OUTPUT_STREAM.write(10);
                        this.SOCKET_OUTPUT_STREAM.flush();
                    } else if (i == 10) {
                        if (lastb != 13) {
                            if (count > 0) {
                                this.SOCKET_OUTPUT_STREAM.write(transfer, 0, count);
                                count = 0;
                            }
                            this.SOCKET_OUTPUT_STREAM.write(13);
                            this.SOCKET_OUTPUT_STREAM.write(10);
                            this.SOCKET_OUTPUT_STREAM.flush();
                        }
                    } else {
                        transfer[count++] = sendBytes[i];
                        if (count >= transfer.length) {
                            this.SOCKET_OUTPUT_STREAM.write(transfer, 0, count);
                            count = 0;
                        }
                    }
                    lastb = sendBytes[i];
                }
                this.SOCKET_OUTPUT_STREAM.write(13);
                this.SOCKET_OUTPUT_STREAM.write(10);
                this.SOCKET_OUTPUT_STREAM.flush();
            }
            finally {
                ByteArrayContainer.recycleInstance(transfer);
            }
        } else {
            this.SOCKET_OUTPUT_STREAM.write(sendBytes);
            this.SOCKET_OUTPUT_STREAM.flush();
        }
    }

    public void send(String str, boolean flagTelnet) throws IOException {
        byte[] sendBytes = this.CHAR_SET == null ? str.getBytes() : str.getBytes(this.CHAR_SET);
        this.send(sendBytes, flagTelnet);
    }
}

