/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.mail.mx.MXLookup;

public class TCPMXLookup
extends MXLookup {
    private static final Logger log = LoggerFactory.getLogger(TCPMXLookup.class);
    protected Socket CONNECTED_SOCKET = null;

    protected TCPMXLookup() {
    }

    @Override
    protected int getDNSResult(InetAddress address, byte[] query, eMsByteArrayOutputStream buffer) throws Throwable {
        int responseLength = -1;
        try {
            this.CONNECTED_SOCKET = new Socket(address, 53);
            BufferedOutputStream bufferedOut = new BufferedOutputStream(this.CONNECTED_SOCKET.getOutputStream());
            DataOutputStream dataOut = new DataOutputStream(bufferedOut);
            BufferedInputStream bufferedIn = new BufferedInputStream(this.CONNECTED_SOCKET.getInputStream());
            DataInputStream dataIn = new DataInputStream(bufferedIn);
            dataOut.writeShort(query.length);
            dataOut.write(query);
            dataOut.flush();
            responseLength = dataIn.readUnsignedShort();
            buffer.ensureSize(responseLength);
            byte[] rawByte = buffer.getRawByteArray();
            dataIn.readFully(rawByte, 0, responseLength);
        }
        catch (Throwable thw) {
            throw thw;
        }
        finally {
            this.close();
        }
        return responseLength;
    }

    @Override
    public void close() {
        this.CONNECT_HOST = null;
        this.IN_COMM = false;
        this.COMM_START_TIME = -1L;
        this.killSession();
        this.CONNECTED_SOCKET = null;
    }

    @Override
    public void killSession() {
        if (this.CONNECTED_SOCKET != null) {
            try {
                this.CONNECTED_SOCKET.shutdownInput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.CONNECTED_SOCKET.shutdownOutput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.CONNECTED_SOCKET.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.IN_COMM = false;
        }
    }

    @Override
    protected void setConnectionTimeout(int timeOfTimeout) {
        block2: {
            this.TIME_OUT = timeOfTimeout;
            try {
                this.CONNECTED_SOCKET.setSoTimeout(timeOfTimeout);
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block2;
                log.error(e.getMessage());
            }
        }
    }
}

