/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail.mx;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.mail.mx.DNS;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.MXResultSorter;

public class DNSInputStream
extends ByteArrayInputStream {
    private static final Logger log = LoggerFactory.getLogger(DNSInputStream.class);
    protected DataInputStream dataIn = new DataInputStream(this);

    public DNSInputStream(byte[] data, int off, int len) {
        super(data, off, len);
    }

    public int getPosition() {
        return this.pos;
    }

    public void plusPosition(int add) {
        this.pos += add;
    }

    public int readByte() throws IOException {
        return this.dataIn.readUnsignedByte();
    }

    public int readShort() throws IOException {
        return this.dataIn.readUnsignedShort();
    }

    public long readInt() throws IOException {
        return (long)this.dataIn.readInt() & 0xFFFFFFFFL;
    }

    public String readString() throws IOException {
        int len = this.readByte();
        if (len == 0) {
            return "";
        }
        byte[] buffer = new byte[len];
        this.dataIn.readFully(buffer);
        return new String(buffer, "latin1");
    }

    public String readDomainName() throws IOException {
        if (this.pos >= this.count) {
            throw new EOFException("EOF reading domain name");
        }
        if ((this.buf[this.pos] & 0xC0) == 0) {
            String tail;
            String label = this.readString();
            if (label.length() > 0 && (tail = this.readDomainName()).length() > 0) {
                label = label + '.' + tail;
            }
            return label;
        }
        if ((this.buf[this.pos] & 0xC0) != 192) {
            throw new IOException("Invalid domain name compression offset");
        }
        int offset = this.readShort() & 0x3FFF;
        DNSInputStream dnsIn = new DNSInputStream(this.buf, offset, this.buf.length - offset);
        return dnsIn.readDomainName();
    }

    public void readRR(MXResultSorter sorter) throws IOException {
        String rrName = this.readDomainName();
        int rrType = this.readShort();
        int rrClass = this.readShort();
        long rrTTL = this.readInt();
        int rrDataLen = this.readShort();
        DNSInputStream rrDNSIn = new DNSInputStream(this.buf, this.pos, rrDataLen);
        this.pos += rrDataLen;
        switch (rrType) {
            case 1: {
                if (log.isDebugEnabled()) {
                    log.debug("find TYPE_A");
                }
                sorter.putAddress(rrName, rrDNSIn);
                break;
            }
            case 2: {
                if (log.isDebugEnabled()) {
                    log.debug("find TYPE_NS");
                }
                if (log.isDebugEnabled()) {
                    log.debug("read TYPE_NS domain START");
                }
                String domain = rrDNSIn.readDomainName();
                if (log.isDebugEnabled()) {
                    log.debug("read TYPE_NS domain END");
                }
                sorter.addNameServer(domain);
                break;
            }
            case 5: {
                String domain = rrDNSIn.readDomainName();
                if (log.isDebugEnabled()) {
                    log.debug("canonical from:" + rrName + " to:" + domain);
                }
                sorter.addCanonicalName(rrName, domain);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                if (log.isDebugEnabled()) {
                    log.debug("read ETC domain START");
                }
                String domain = rrDNSIn.readDomainName();
                if (log.isDebugEnabled()) {
                    log.debug("read ETC domain START");
                }
                if (!log.isDebugEnabled()) break;
                log.debug(DNS.typeName(rrType) + ":" + domain);
                break;
            }
            case 6: {
                if (log.isDebugEnabled()) {
                    log.debug("find SOA");
                }
                sorter.putStartOfAuth(rrDNSIn);
                break;
            }
            case 10: {
                byte[] data = new byte[rrDataLen];
                rrDNSIn.read(data);
                String text = new String(data, "latin1");
                if (!log.isDebugEnabled()) break;
                log.debug("etc null:" + text);
                break;
            }
            case 11: {
                int[] ipAddress = new int[4];
                for (int i = 0; i < 4; ++i) {
                    ipAddress[i] = rrDNSIn.readByte();
                }
                int protocol = rrDNSIn.readByte();
                byte[] data = new byte[rrDataLen - 5];
                rrDNSIn.read(data);
                break;
            }
            case 13: {
                String cpu = rrDNSIn.readString();
                String os = rrDNSIn.readString();
                break;
            }
            case 14: {
                if (log.isDebugEnabled()) {
                    log.debug("read TYPE_MINFO1 domain START");
                }
                String rBox = rrDNSIn.readDomainName();
                if (log.isDebugEnabled()) {
                    log.debug("read TYPE_MINFO1 domain END");
                }
                if (log.isDebugEnabled()) {
                    log.debug("read TYPE_MINFO2 domain START");
                }
                String eBox = rrDNSIn.readDomainName();
                if (!log.isDebugEnabled()) break;
                log.debug("read TYPE_MINFO2 domain END");
                break;
            }
            case 15: {
                sorter.putMailExchanger(rrDNSIn);
                break;
            }
            case 16: {
                String s;
                while ((s = rrDNSIn.readString()) != null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("TEXT:" + s);
                }
                break;
            }
            default: {
                LookupCacheManager.log(rrName + " receive unknown:" + rrType);
            }
        }
    }
}

