/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRcptInfo {
    private static final Logger log = LoggerFactory.getLogger(MultiRcptInfo.class);
    private int size;
    String domain = null;
    StringBuffer INNER_CONTAINER = null;
    int count = 0;

    public MultiRcptInfo(String domain, int s) {
        this.domain = domain;
        this.size = s;
        this.INNER_CONTAINER = new StringBuffer(256);
        this.INNER_CONTAINER.append(this.domain);
    }

    public synchronized String getResult() {
        if (this.count < 1) {
            return null;
        }
        String returnValue = this.INNER_CONTAINER.toString();
        this.INNER_CONTAINER.setLength(0);
        this.INNER_CONTAINER.append(this.domain);
        this.count = 0;
        if (log.isDebugEnabled()) {
            log.debug("RCPT INFO GET RESULT...");
        }
        return returnValue;
    }

    public void reset(String domain, int s) {
        this.domain = domain;
        this.size = s;
        this.INNER_CONTAINER.setLength(0);
        this.INNER_CONTAINER.append(this.domain);
        this.count = 0;
    }

    public int getSize() {
        return this.count;
    }

    public String getDomain() {
        return this.domain;
    }

    public synchronized boolean addElement(String src) {
        this.INNER_CONTAINER.append("<*>");
        this.INNER_CONTAINER.append(src);
        ++this.count;
        return this.count >= this.size;
    }

    public void destroy() {
        this.INNER_CONTAINER = null;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }
}

