/*
 * Decompiled with CFR 0.152.
 */
package pluto.mail;

public class DNSSearchResult {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient String[] elementData;
    private int size;

    public DNSSearchResult(int initialCapacity) {
        this.elementData = new String[initialCapacity];
        this.size = 0;
    }

    public DNSSearchResult() {
        this(10);
    }

    protected synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            String[] oldData = this.elementData;
            this.elementData = new String[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            String[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new String[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public boolean add(String o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    public void remove(int index) {
        this.RangeCheck(index);
        this.elementData[index] = null;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public synchronized String toString() {
        StringBuffer tmpBuffer = null;
        try {
            tmpBuffer = new StringBuffer(128);
            tmpBuffer.setLength(0);
            tmpBuffer.append("{");
            for (int i = 0; i < this.size; ++i) {
                tmpBuffer.append(this.elementData[i]);
                tmpBuffer.append(",");
            }
            tmpBuffer.setLength(tmpBuffer.length() - 1);
            tmpBuffer.append("}");
            String string = tmpBuffer.toString();
            return string;
        }
        finally {
            tmpBuffer = null;
        }
    }
}

