/*
 * Decompiled with CFR 0.152.
 */
package pluto.live.monitor;

import java.util.Hashtable;
import java.util.Properties;
import kr.co.amail.LiveEMS.Common.InfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.schedule.ScheduledMonitor;

public class SystemInfoCollector
extends ScheduledMonitor {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoCollector.class);
    private static boolean canCollect = false;
    private static final long REFRESH_CYCLE = 10000L;
    private static SystemInfoCollector systemInfoCollector = new SystemInfoCollector();
    private static Hashtable DiskTotal;
    private static Hashtable DiskUsed;
    private static String MemoryTotal;
    private static String MemoryUsed;
    private static String exMemoryTotal;
    private static String exMemoryUsed;
    private static String CPUUsed;
    private static String NetworkReceived;
    private static String NetworkSent;
    private static String IPInfo;

    public SystemInfoCollector() {
        super(10000L);
    }

    public SystemInfoCollector(long size, String name) {
        super(size, name);
    }

    public static synchronized void init(Object tmp) throws Exception {
        Properties oProp = (Properties)tmp;
        canCollect = InfoUtil.init((String)oProp.getProperty("systeminfo.jni.path", "\\work\\kr\\co\\amail\\LiveEMS\\Common"));
        if (!canCollect) {
            log.debug("SystemInfoCollector : failed to initialize getSystemInfo.dll");
        }
    }

    @Override
    protected void check() throws Exception {
        if (!canCollect) {
            log.debug(this.getName().concat(" : closed"));
            this.close();
        }
        String SysValue = new String();
        String DiskInfo = new String();
        String FirstDiskInfo = new String();
        String NextDiskInfo = new String();
        String Hash = new String();
        SysValue = InfoUtil.Win_GetSysInfoAll();
        int DestNumber = SysValue.indexOf("|");
        int BeginNumber = 0;
        SystemInfoCollector.setCPUUsed(SysValue.substring(BeginNumber, DestNumber));
        try {
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setMemoryTotal(SysValue.substring(BeginNumber, DestNumber));
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setMemoryUsed(SysValue.substring(BeginNumber, DestNumber));
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setExMemoryTotal(SysValue.substring(BeginNumber, DestNumber));
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setExMemoryUsed(SysValue.substring(BeginNumber, DestNumber));
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            DiskInfo = SysValue.substring(BeginNumber, DestNumber);
            int DiskDestNumber = DiskInfo.indexOf("&");
            int DiskBeginNumber = 0;
            do {
                FirstDiskInfo = DiskInfo.substring(DiskBeginNumber, DiskDestNumber);
                int ExDiskDestNumber = FirstDiskInfo.indexOf("$");
                int ExDiskBeginNumber = 0;
                Hash = FirstDiskInfo.substring(ExDiskBeginNumber, ExDiskDestNumber);
                ExDiskBeginNumber = ExDiskDestNumber + 1;
                ExDiskDestNumber = FirstDiskInfo.indexOf("$", ExDiskBeginNumber);
                NextDiskInfo = FirstDiskInfo.substring(ExDiskBeginNumber, ExDiskDestNumber);
                SystemInfoCollector.setDiskTotal(Hash, NextDiskInfo);
                ExDiskBeginNumber = ExDiskDestNumber + 1;
                ExDiskDestNumber = FirstDiskInfo.indexOf("$", ExDiskBeginNumber);
                NextDiskInfo = FirstDiskInfo.substring(ExDiskBeginNumber, ExDiskDestNumber);
                SystemInfoCollector.setDiskUsed(Hash, NextDiskInfo);
            } while ((DiskDestNumber = DiskInfo.indexOf("&", DiskBeginNumber = DiskDestNumber + 1)) != -1);
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setNetworkReceived(SysValue.substring(BeginNumber, DestNumber));
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setNetworkSent(SysValue.substring(BeginNumber, DestNumber));
            BeginNumber = DestNumber + 1;
            DestNumber = SysValue.indexOf("|", BeginNumber);
            SystemInfoCollector.setIPInfo(SysValue.substring(BeginNumber, DestNumber));
        }
        catch (Exception e) {
            log.debug(this.getName().concat(" : ").concat(e.toString()));
        }
    }

    public static String getCPUUsed() {
        return CPUUsed;
    }

    public static void setCPUUsed(String used) {
        CPUUsed = used;
    }

    public static String getExMemoryTotal() {
        return exMemoryTotal.equals("") ? "0" : exMemoryTotal;
    }

    public static void setExMemoryTotal(String memTotal) {
        exMemoryTotal = memTotal;
    }

    public static String getExMemoryUsed() {
        return exMemoryUsed.equals("") ? "0" : exMemoryUsed;
    }

    public static void setExMemoryUsed(String memUsed) {
        exMemoryUsed = memUsed;
    }

    public static String getIPInfo() {
        return IPInfo.equals("") ? "0" : IPInfo;
    }

    public static void setIPInfo(String info) {
        IPInfo = info;
    }

    public static String getMemoryTotal() {
        return MemoryTotal.equals("") ? "0" : MemoryTotal;
    }

    public static void setMemoryTotal(String memTotal) {
        MemoryTotal = memTotal;
    }

    public static String getMemoryUsed() {
        return MemoryUsed.equals("") ? "0" : MemoryUsed;
    }

    public static void setMemoryUsed(String memUsed) {
        MemoryUsed = memUsed;
    }

    public static String getNetworkReceived() {
        return NetworkReceived.equals("") ? "0" : NetworkReceived;
    }

    public static void setNetworkReceived(String netReceived) {
        NetworkReceived = netReceived;
    }

    public static String getNetworkSent() {
        return NetworkSent.equals("") ? "0" : NetworkSent;
    }

    public static void setNetworkSent(String netSent) {
        NetworkSent = netSent;
    }

    public static String getDiskTotal(String hash) {
        return (String)DiskTotal.get(hash);
    }

    public static void setDiskTotal(String hash, String value) {
        DiskTotal.put(hash, value);
    }

    public static String getDiskUsed(String hash) {
        return (String)DiskUsed.get(hash);
    }

    public static void setDiskUsed(String hash, String value) {
        DiskUsed.put(hash, value);
    }

    public static void main(String[] args) {
    }

    static {
        systemInfoCollector.start();
        DiskTotal = new Hashtable();
        DiskUsed = new Hashtable();
        MemoryTotal = "";
        MemoryUsed = "";
        exMemoryTotal = "";
        exMemoryUsed = "";
        CPUUsed = "";
        NetworkReceived = "";
        NetworkSent = "";
        IPInfo = "";
    }
}

