/*
 * Decompiled with CFR 0.152.
 */
package pluto.ioutil;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putStringToLocalFile(File target, String sContent, String enc) throws Exception {
        PrintWriter pw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            osw = new OutputStreamWriter((OutputStream)fos, enc);
            pw = new PrintWriter(osw);
            pw.print(sContent);
            pw.flush();
        }
        catch (Throwable throwable) {
            FileUtil.close(pw);
            throw throwable;
        }
        FileUtil.close(pw);
    }

    public static void putLocalFileToStream(File target, OutputStream stream) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(target);
            byte[] buffer = new byte[256];
            int read = 0;
            while ((read = in.read(buffer)) > 0) {
                stream.write(buffer, 0, read);
            }
        }
        catch (Throwable thw) {
            try {
                log.error("error", thw);
                if (thw instanceof Exception) {
                    throw (Exception)thw;
                }
                throw new Exception(thw.toString());
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                throw throwable;
            }
        }
        FileUtil.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToLocalFile(String source, File target, String encoding, boolean escape) throws IOException {
        FileOutputStream fos;
        OutputStreamWriter osw;
        BufferedWriter writer;
        block8: {
            "abc".getBytes(encoding);
            writer = null;
            osw = null;
            fos = null;
            fos = new FileOutputStream(target);
            osw = new OutputStreamWriter((OutputStream)fos, encoding);
            writer = new BufferedWriter(osw);
            if (escape) break block8;
            writer.write(source);
            writer.flush();
            FileUtil.close(fos);
            FileUtil.close(osw);
            FileUtil.close(writer);
            return;
        }
        try {
            char[] sourceArray = source.toCharArray();
            for (int i = 0; i < sourceArray.length; ++i) {
                if (sourceArray[i] < ' ') {
                    switch (sourceArray[i]) {
                        case '\n': 
                        case '\r': {
                            writer.write(sourceArray, i, 1);
                            break;
                        }
                        default: {
                            writer.write(" ");
                            break;
                        }
                    }
                    continue;
                }
                writer.write(sourceArray, i, 1);
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            FileUtil.close(fos);
            FileUtil.close(osw);
            FileUtil.close(writer);
            throw throwable;
        }
        FileUtil.close(fos);
        FileUtil.close(osw);
        FileUtil.close(writer);
    }

    public static final String deleteLocalFile(String url) {
        return FileUtil.deleteLocalFile(new File(url));
    }

    public static final String deleteLocalFile(File file) {
        boolean flag = false;
        try {
            flag = file.delete();
        }
        catch (Throwable thw) {
            return thw.toString();
        }
        return flag ? null : "RESULT FALSE";
    }

    public static final synchronized void close(Object obj) {
        if (obj == null) {
            return;
        }
        Class<?> classObj = obj.getClass();
        Method method = null;
        try {
            method = classObj.getMethod("close", null);
        }
        catch (Throwable thw) {
            log.error("getMethod error", thw);
        }
        try {
            method.invoke(obj, null);
        }
        catch (Throwable thw) {
            log.error("method invoke error", thw);
        }
    }

    public static String readLocal(File f) throws IOException {
        int j;
        FileInputStream fis = new FileInputStream(f);
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((j = fis.read(b)) > 0) {
            baos.write(b, 0, j);
        }
        return baos.toString(eMsLocale.CHAR_SET);
    }

    public static String readLocal(String fName) throws IOException {
        File f = new File(fName);
        return FileUtil.readLocal(f);
    }
}

