/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.io.eMsByteArrayOutputStream;
import pluto.lang.ByteArrayContainer;
import pluto.lang.eMsLocale;

public class eMsSizeIndexedInputStream
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(eMsSizeIndexedInputStream.class);
    protected byte[] __READ_BUFFER__ = ByteArrayContainer.getInstance();
    protected int __BUFFER_SIZE__ = 0;
    protected int __BUFFER_INDEX__ = 0;
    protected long __FILE_POINT__ = 0L;
    protected eMsByteArrayOutputStream __INNER_WORK_BYTE_STREAM__ = eMsByteArrayOutputStream.getInstance();

    public eMsSizeIndexedInputStream(InputStream in) {
        super(in);
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long returnValue = super.skip(n);
        this.__FILE_POINT__ += returnValue;
        return returnValue;
    }

    public long getFilePointer() {
        return this.__FILE_POINT__;
    }

    protected void inner_read() throws IOException {
        this.__BUFFER_SIZE__ = super.read(this.__READ_BUFFER__);
        this.__BUFFER_INDEX__ = 0;
    }

    protected synchronized boolean ready() throws IOException {
        if (this.__BUFFER_INDEX__ >= this.__BUFFER_SIZE__) {
            if (super.available() > 0) {
                this.inner_read();
                if (this.__BUFFER_SIZE__ < 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        int returnValue = this.__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF;
        ++this.__FILE_POINT__;
        return returnValue;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            eMsByteArrayOutputStream.recycleInstance(this.__INNER_WORK_BYTE_STREAM__);
            ByteArrayContainer.recycleInstance(this.__READ_BUFFER__);
        }
    }

    protected synchronized String readString(int size) throws IOException {
        if (!this.ready()) {
            throw new RuntimeException("INVALID FORMAT");
        }
        if (size < this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__) {
            String returnValue = new String(this.__READ_BUFFER__, this.__BUFFER_INDEX__, size);
            this.__BUFFER_INDEX__ += size;
            this.__FILE_POINT__ += (long)size;
            return returnValue;
        }
        this.__INNER_WORK_BYTE_STREAM__.reset();
        this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, this.__BUFFER_INDEX__, this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
        int __REMAIN_SIZE__ = size - (this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
        this.__FILE_POINT__ += (long)(this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
        do {
            this.inner_read();
            if (this.__BUFFER_SIZE__ < 0) break;
            if (__REMAIN_SIZE__ > this.__BUFFER_SIZE__) {
                this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, 0, this.__BUFFER_SIZE__);
                __REMAIN_SIZE__ -= this.__BUFFER_SIZE__;
                this.__FILE_POINT__ += (long)this.__BUFFER_SIZE__;
                continue;
            }
            this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, 0, __REMAIN_SIZE__);
            this.__BUFFER_INDEX__ = __REMAIN_SIZE__;
            this.__FILE_POINT__ += (long)__REMAIN_SIZE__;
            __REMAIN_SIZE__ = -1;
        } while (__REMAIN_SIZE__ > 0);
        return this.__INNER_WORK_BYTE_STREAM__.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
    }

    public synchronized String next() throws IOException {
        int readSize = -1;
        if (!this.ready()) {
            return null;
        }
        readSize = (this.__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 24;
        ++this.__FILE_POINT__;
        if (!this.ready()) {
            return null;
        }
        readSize += (this.__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 16;
        ++this.__FILE_POINT__;
        if (!this.ready()) {
            return null;
        }
        readSize += (this.__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 8;
        ++this.__FILE_POINT__;
        if (!this.ready()) {
            return null;
        }
        ++this.__FILE_POINT__;
        return this.readString(readSize += (this.__READ_BUFFER__[this.__BUFFER_INDEX__++] & 0xFF) << 0);
    }
}

