/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import pluto.io.eMsByteArray;
import pluto.util.FIFOBuffer;

public class eMsByteArrayOutputStream
extends OutputStream {
    private static final int MAX_CONTAIN_SIZE = 10;
    private static FIFOBuffer INNER_CONTAINER = null;
    protected byte[] buf;
    protected int count;

    public static eMsByteArrayOutputStream getInstance() {
        Object returnValue = INNER_CONTAINER.pop();
        if (returnValue == null) {
            return new eMsByteArrayOutputStream(1024);
        }
        return (eMsByteArrayOutputStream)returnValue;
    }

    public static void recycleInstance(eMsByteArrayOutputStream tmp) {
        if (tmp == null) {
            return;
        }
        try {
            tmp.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        INNER_CONTAINER.push(tmp);
    }

    public eMsByteArrayOutputStream() {
        this(32);
    }

    public eMsByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("TARGET : " + b.length + " OFF: " + off + " LEN: " + len);
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void ensureSize(int size) {
        if (this.buf.length < size) {
            byte[] newbuf = new byte[size];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = null;
            this.buf = newbuf;
        }
    }

    public byte[] getRawByteArray() {
        return this.buf;
    }

    public byte[] getByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public synchronized int toByteArray(eMsByteArray toBuffer) {
        if (toBuffer.length() < this.count) {
            toBuffer.setArray(new byte[this.count]);
        }
        System.arraycopy(this.buf, 0, toBuffer.getArray(), 0, this.count);
        return this.count;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }

    static {
        INNER_CONTAINER = new FIFOBuffer(10);
    }
}

