/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import pluto.io.eMsByteArray;
import pluto.io.eMsByteArrayOutputStream;

public abstract class StreamFileReader
extends InputStream {
    public static final int OTHER_LINE_DELIM_TYPE = 0;
    public static final int CRLF_LINE_DELIM_TYPE = 1;
    protected InputStream STREAM = null;
    protected byte[] __READ_BUFFER__ = new byte[1024];
    protected int __BUFFER_SIZE__ = 0;
    protected int __BUFFER_INDEX__ = 0;
    protected boolean __SKIP_REMAIN_FLAG__ = false;
    protected int __SKIP_REMAIN_COUNT__ = 0;
    protected eMsByteArrayOutputStream __INNER_WORK_BYTE_STREAM__ = new eMsByteArrayOutputStream(512);

    public StreamFileReader(String filename) throws IOException {
        this(new File(filename));
    }

    public StreamFileReader(File filename) throws IOException {
        this(new FileInputStream(filename));
    }

    public StreamFileReader(InputStream stream) throws IOException {
        this.STREAM = stream;
        this.inner_read();
    }

    @Override
    public void close() throws IOException {
        this.STREAM.close();
    }

    @Override
    public int read() throws IOException {
        return this.STREAM.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.STREAM.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.STREAM.read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        this.STREAM.reset();
    }

    protected void inner_read() throws IOException {
        this.__BUFFER_SIZE__ = super.read(this.__READ_BUFFER__);
        this.__BUFFER_INDEX__ = 0;
    }

    public synchronized boolean ready() throws IOException {
        if (this.__BUFFER_SIZE__ < 1) {
            if (super.available() > 0) {
                this.inner_read();
                if (this.__BUFFER_SIZE__ < 1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public synchronized int readLineByte(eMsByteArray toBuffer) throws IOException {
        this.__INNER_WORK_BYTE_STREAM__.reset();
        if (!this.ready()) {
            return -1;
        }
        while (this.__BUFFER_SIZE__ >= 1) {
            int idx = this.findNextLineDelimIndex(this.__BUFFER_INDEX__);
            if (idx < 0) {
                if (this.__BUFFER_SIZE__ > this.__BUFFER_INDEX__) {
                    this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, this.__BUFFER_INDEX__, this.__BUFFER_SIZE__ - this.__BUFFER_INDEX__);
                }
                this.inner_read();
                continue;
            }
            this.__INNER_WORK_BYTE_STREAM__.write(this.__READ_BUFFER__, this.__BUFFER_INDEX__, idx - this.__BUFFER_INDEX__);
            this.__BUFFER_INDEX__ = this.skipLineDelim(idx);
            if (this.__BUFFER_INDEX__ >= 0) break;
            this.inner_read();
            this.skipLineFirst();
            if (!this.__SKIP_REMAIN_FLAG__) break;
            this.__BUFFER_INDEX__ = this.__SKIP_REMAIN_COUNT__;
            break;
        }
        return this.__INNER_WORK_BYTE_STREAM__.toByteArray(toBuffer);
    }

    protected abstract void skipLineFirst();

    protected abstract int findNextLineDelimIndex(int var1);

    protected abstract int skipLineDelim(int var1);
}

