/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.File;
import java.util.Properties;
import pluto.io.eMsFileReader;
import pluto.io.eMsFileWriter;
import pluto.lang.Name;

public abstract class FileObjectController
extends Name {
    protected eMsFileReader BUFFERED_READER = null;
    protected eMsFileWriter BUFFERED_WRITER = null;
    private File WRITE_FILE_POINTER = null;

    protected void openReader(String filename) throws Exception {
        if (this.BUFFERED_READER != null) {
            try {
                this.BUFFERED_READER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.BUFFERED_READER = new eMsFileReader(filename);
    }

    protected void openWriter(String filename) throws Exception {
        this.openWriter(filename, false);
    }

    protected void openWriter(String filename, boolean append) throws Exception {
        if (this.BUFFERED_WRITER != null) {
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.BUFFERED_WRITER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.BUFFERED_WRITER = new eMsFileWriter(filename, append);
        this.WRITE_FILE_POINTER = new File(filename);
    }

    protected void releaseResource() {
        this.closeWriter();
        this.closeReader();
    }

    protected void deleteWriter() {
        if (this.BUFFERED_WRITER != null) {
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.BUFFERED_WRITER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.BUFFERED_WRITER = null;
            this.WRITE_FILE_POINTER.delete();
        }
    }

    protected void closeWriter() {
        if (this.BUFFERED_WRITER != null) {
            try {
                this.BUFFERED_WRITER.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.BUFFERED_WRITER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.BUFFERED_WRITER = null;
            this.WRITE_FILE_POINTER = null;
        }
    }

    protected void closeReader() {
        if (this.BUFFERED_READER != null) {
            try {
                this.BUFFERED_READER.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.BUFFERED_READER = null;
        }
    }

    public final void process(Properties prop) throws Exception {
        try {
            this.inner_process(prop);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.releaseResource();
        }
    }

    protected abstract void inner_process(Properties var1) throws Exception;
}

