/*
 * Decompiled with CFR 0.152.
 */
package pluto.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import pluto.lang.eMsLocale;

public abstract class CRLFFilteredOutputStream
extends BufferedOutputStream {
    protected int lastb = -1;

    public CRLFFilteredOutputStream(OutputStream outputstream) {
        super(outputstream);
    }

    @Override
    public void write(int i) throws IOException {
        if (i == 13) {
            this.writeln();
        } else if (i == 10) {
            if (this.lastb != 13) {
                this.writeln();
            }
        } else {
            this.writeLocal(i);
        }
        this.lastb = i;
    }

    @Override
    public void write(byte[] abyte0) throws IOException {
        this.write(abyte0, 0, abyte0.length);
    }

    public void write(String s) throws IOException {
        byte[] src = null;
        try {
            src = s.getBytes(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
        }
        catch (Exception e) {
            src = s.getBytes();
        }
        this.write(src);
    }

    @Override
    public void write(byte[] abyte0, int start, int end) throws IOException {
        for (int l = start; l < end; ++l) {
            this.write(abyte0[l]);
        }
    }

    protected void writeLocal(int i) throws IOException {
        super.write(i);
    }

    protected abstract void writeln() throws IOException;
}

