/*
 * Decompiled with CFR 0.152.
 */
package pluto.dbutil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.dbutil.CharConvertor;
import pluto.util.PlutoLinkedList;
import pluto.util.StringConvertUtil;

public class HashPreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(HashPreparedStatement.class);
    public static final char STRING_PARAM_INDEX = '\'';
    public static final short STRING_TYPE_PARAMETER = 1;
    public static final short NUMERIC_TYPE_PARAMETER = 2;
    private PreparedStatement ps = null;
    private String ORIGINAL_QUERY = null;
    private String CONVERT_QUERY = null;
    private PlutoLinkedList PARAMETER_INFOS = null;
    private CharConvertor convertor = null;

    public HashPreparedStatement(String src, String START_INDEX, String END_INDEX) throws Exception {
        this.ORIGINAL_QUERY = src;
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(512);
            buffer.setLength(0);
            this.convertSql(buffer, START_INDEX, END_INDEX);
            this.CONVERT_QUERY = buffer.toString();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    public void connectTo(Connection conn, CharConvertor tcon) throws SQLException {
        this.close();
        this.convertor = tcon;
        this.ps = conn.prepareStatement(this.CONVERT_QUERY);
    }

    public void close() {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ps = null;
        }
    }

    public int executeUpdate(Map map) throws SQLException {
        this.setParameter(map);
        int n = this.ps.executeUpdate();
        return n;
    }

    public ResultSet executeQuery(Map map) throws SQLException {
        this.setParameter(map);
        ResultSet resultSet = this.ps.executeQuery();
        return resultSet;
    }

    private synchronized void setParameter(Map map) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("INSERT PARAMETER", (Object)map.toString());
        }
        int idx = 1;
        for (PreparedParameter param : this.PARAMETER_INFOS) {
            Object value = map.get(param.getIndex());
            switch (param.getType()) {
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug("STRING_TYPE_PARAMETER set:" + param.getIndex(), (Object)("[" + value.toString() + "]"));
                    }
                    if (value == null) {
                        this.ps.setString(idx, " ");
                        break;
                    }
                    if (value instanceof Throwable) {
                        this.ps.setString(idx, this.convertor.encode(StringConvertUtil.exToString((Throwable)value)));
                        break;
                    }
                    this.ps.setString(idx, this.convertor.encode(value.toString()));
                    break;
                }
                case 2: {
                    if (value == null) {
                        throw new RuntimeException("CAN'T SET NUMERIC TO NULL:" + param.getIndex());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("NUMERIC_TYPE_PARAMETER set:" + param.getIndex(), (Object)("[" + value.toString() + "]"));
                    }
                    this.ps.setInt(idx, Integer.parseInt(value.toString()));
                    break;
                }
                default: {
                    throw new RuntimeException("UNKNOWN TYPE:" + String.valueOf(param.getType()));
                }
            }
            ++idx;
        }
    }

    protected void convertSql(StringBuffer myBuffer, String START_INDEX, String END_INDEX) throws Exception {
        if (this.ORIGINAL_QUERY == null) {
            throw new RuntimeException("TARGET QUERY IS NULL");
        }
        this.PARAMETER_INFOS = new PlutoLinkedList();
        String source = this.ORIGINAL_QUERY.concat("             ");
        int idx1 = 0;
        int idx2 = 0;
        int idx3 = 0;
        while ((idx1 = source.indexOf(START_INDEX, idx3)) >= 0) {
            idx2 = source.indexOf(END_INDEX, idx1);
            if (idx2 < 0) {
                throw new RuntimeException("PARSE ERROR NEAR=>" + source.substring(idx1 - 3));
            }
            if (source.charAt(idx1 - 1) == '\'' && source.charAt(idx2 + END_INDEX.length()) == '\'') {
                this.PARAMETER_INFOS.addLast(new PreparedParameter(1, source.substring(idx1 + 2, idx2)));
                if (log.isDebugEnabled()) {
                    log.debug("STRING_TYPE_PARAMETER", (Object)(source.substring(idx1 + START_INDEX.length(), idx2) + " ADDED"));
                }
                myBuffer.append(source.substring(idx3, idx1 - 1));
                myBuffer.append("?");
                idx3 = idx2 + END_INDEX.length() + 1;
                continue;
            }
            if (source.charAt(idx1 - 1) != '\'' && source.charAt(idx2 + END_INDEX.length()) != '\'') {
                this.PARAMETER_INFOS.addLast(new PreparedParameter(2, source.substring(idx1 + 2, idx2)));
                if (log.isDebugEnabled()) {
                    log.debug("NUMERIC_TYPE_PARAMETER", (Object)(source.substring(idx1 + START_INDEX.length(), idx2) + " ADDED"));
                }
                myBuffer.append(source.substring(idx3, idx1));
                myBuffer.append("?");
                idx3 = idx2 + END_INDEX.length();
                continue;
            }
            throw new RuntimeException("PARSE ERROR NEAR=>" + source.substring(idx1 - 3));
        }
        myBuffer.append(source.substring(idx3));
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    static class PreparedParameter {
        short type;
        String index;

        PreparedParameter(short t, String i) {
            this.type = t;
            this.index = i;
        }

        public short getType() {
            return this.type;
        }

        public String getIndex() {
            return this.index;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "STRING_TYPE_PARAMETER:".concat(this.index);
                }
                case 2: {
                    return "NUMERIC_TYPE_PARAMETER:".concat(this.index);
                }
            }
            return "UNKNOWN TYPE";
        }
    }
}

