/*
 * Decompiled with CFR 0.152.
 */
package pluto.db;

import java.io.InputStream;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.db.eMsConnection;
import pluto.io.eMsByteArrayOutputStream;
import pluto.io.eMsFileWriter;
import pluto.lang.ByteArrayContainer;
import pluto.lang.CharArrayContainer;
import pluto.lang.eMsLocale;
import pluto.util.convert.DelimConvertor;

public class eMsResultSet {
    private static final Logger log = LoggerFactory.getLogger(eMsResultSet.class);
    private eMsConnection EMS_CONNECTION = null;
    private ResultSet rs = null;
    private ResultSetMetaData rsmt = null;
    private int colcount = -1;
    private String HEADER_MAP = null;

    public eMsResultSet(eMsConnection conn, ResultSet result) throws SQLException {
        this.EMS_CONNECTION = conn;
        this.rs = result;
        this.rsmt = this.rs.getMetaData();
        this.colcount = this.rsmt.getColumnCount();
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(256);
            buffer.setLength(0);
            for (int i = 1; i <= this.colcount; ++i) {
                if ("mysql".equals(eMsLocale.DB_TYPE)) {
                    buffer.append(this.rsmt.getColumnLabel(i).toUpperCase());
                } else {
                    buffer.append(this.rsmt.getColumnName(i).toUpperCase());
                }
                buffer.append("|");
            }
            buffer.setLength(buffer.length() - 1);
            this.HEADER_MAP = buffer.toString();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    public eMsResultSet(eMsConnection conn, ResultSet result, String dbType) throws SQLException {
        this.EMS_CONNECTION = conn;
        this.rs = result;
        this.rsmt = this.rs.getMetaData();
        this.colcount = this.rsmt.getColumnCount();
        StringBuffer buffer = null;
        try {
            buffer = new StringBuffer(256);
            buffer.setLength(0);
            for (int i = 1; i <= this.colcount; ++i) {
                if ("mysql".equals(dbType)) {
                    buffer.append(this.rsmt.getColumnLabel(i).toUpperCase());
                } else {
                    buffer.append(this.rsmt.getColumnName(i).toUpperCase());
                }
                buffer.append("|");
            }
            buffer.setLength(buffer.length() - 1);
            this.HEADER_MAP = buffer.toString();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            buffer = null;
        }
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public String getHeaderString() {
        return this.HEADER_MAP;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rsmt;
    }

    public int getColumnCount() {
        return this.colcount;
    }

    public final String getIN_CHARSET() {
        return this.EMS_CONNECTION.getIN_CHARSET();
    }

    public final String getOUT_CHARSET() {
        return this.EMS_CONNECTION.getOUT_CHARSET();
    }

    public final String getBASE_CHARSET() {
        return this.EMS_CONNECTION.getBASE_CHARSET();
    }

    public boolean next() throws SQLException {
        try {
            this.EMS_CONNECTION.setIdleLimitTime(600);
            boolean bl = this.rs.next();
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.EMS_CONNECTION.releaseIdleLimitTime();
        }
    }

    public void close() {
        try {
            this.rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getString(int idx) throws SQLException {
        String string = this.EMS_CONNECTION.decode(this.rs.getString(idx));
        return string;
    }

    public String getString(String name) throws SQLException {
        try {
            String string = this.EMS_CONNECTION.decode(this.rs.getString(name));
            return string;
        }
        catch (SQLException e) {
            log.error(e.getMessage());
            throw e;
        }
    }

    public byte[] getStringAsByteArray(int idx) throws SQLException {
        byte[] byArray = this.EMS_CONNECTION.decodeByteArray(this.rs.getString(idx));
        return byArray;
    }

    public byte[] getStringAsByteArray(String name) throws SQLException {
        byte[] byArray = this.EMS_CONNECTION.decodeByteArray(this.rs.getString(name));
        return byArray;
    }

    public int getInt(int idx) throws SQLException {
        int n = this.rs.getInt(idx);
        return n;
    }

    public int getInt(String name) throws SQLException {
        int n = this.rs.getInt(name);
        return n;
    }

    public Timestamp getTimestamp(int idx) throws SQLException {
        Timestamp timestamp = this.rs.getTimestamp(idx);
        return timestamp;
    }

    public InputStream getBinaryStream(int idx) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(idx);
        return inputStream;
    }

    public InputStream getBinaryStream(String name) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(name);
        return inputStream;
    }

    public String getBinaryStreamAsString(int idx) throws Exception {
        return this.getBinaryStreamAsString(idx, null);
    }

    public String getBinaryStreamAsString(int idx, String charset) throws Exception {
        String string = this.ConvertBinaryStreamToString(this.rs.getBinaryStream(idx), charset);
        return string;
    }

    public String getBinaryStreamAsString(String name) throws Exception {
        return this.getBinaryStreamAsString(name, null);
    }

    public String getBinaryStreamAsString(String name, String charset) throws Exception {
        String string = this.ConvertBinaryStreamToString(this.rs.getBinaryStream(name), charset);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String ConvertBinaryStreamToString(InputStream in, String charset) throws Exception {
        String bytes23322;
        if (in == null) {
            return "";
        }
        eMsByteArrayOutputStream __BUFFER__ = null;
        byte[] buffer = null;
        try {
            String string;
            block13: {
                block12: {
                    __BUFFER__ = eMsByteArrayOutputStream.getInstance();
                    __BUFFER__.flush();
                    __BUFFER__.reset();
                    buffer = ByteArrayContainer.getInstance();
                    while (true) {
                        int bytes23322;
                        if ((bytes23322 = in.read(buffer)) < 0) {
                            __BUFFER__.flush();
                            if (charset == null) {
                                break;
                            }
                            break block12;
                        }
                        __BUFFER__.write(buffer, 0, bytes23322);
                    }
                    string = this.EMS_CONNECTION.getOUT_CHARSET();
                    break block13;
                }
                string = charset;
            }
            bytes23322 = __BUFFER__.toString(string);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ByteArrayContainer.recycleInstance(buffer);
                eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
                throw throwable;
            }
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ByteArrayContainer.recycleInstance(buffer);
        eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
        return bytes23322;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCharStreamAsString(int idx) throws Exception {
        switch (this.rsmt.getColumnType(idx)) {
            case -1: 
            case 2005: {
                if (!log.isDebugEnabled()) return this.ConvertCharStreamToString(this.rs.getCharacterStream(idx));
                log.debug("======= " + idx + " ==========");
                log.debug("CLOB");
                return this.ConvertCharStreamToString(this.rs.getCharacterStream(idx));
            }
            case 2004: {
                if (!log.isDebugEnabled()) return this.ConvertBinaryStreamToString(this.rs.getBinaryStream(idx));
                log.debug("======= " + idx + " ==========");
                log.debug("BLOB");
                return this.ConvertBinaryStreamToString(this.rs.getBinaryStream(idx));
            }
        }
        if (!log.isDebugEnabled()) return this.EMS_CONNECTION.decode(this.rs.getString(idx));
        log.debug("======= " + idx + " ==========");
        log.debug("DEFAULT STRING");
        return this.EMS_CONNECTION.decode(this.rs.getString(idx));
    }

    protected final String ConvertBinaryStreamToString(InputStream in) throws Exception {
        if (in == null) {
            return "";
        }
        eMsByteArrayOutputStream __BUFFER__ = null;
        byte[] buffer = null;
        try {
            int bytes22;
            __BUFFER__ = eMsByteArrayOutputStream.getInstance();
            buffer = ByteArrayContainer.getInstance();
            while ((bytes22 = in.read(buffer)) >= 0) {
                __BUFFER__.write(buffer, 0, bytes22);
            }
            String bytes22 = __BUFFER__.toString(this.EMS_CONNECTION.getIN_CHARSET());
            return bytes22;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            ByteArrayContainer.recycleInstance(buffer);
            eMsByteArrayOutputStream.recycleInstance(__BUFFER__);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String ConvertCharStreamToString(Reader in) throws Exception {
        String bytes23322;
        if (in == null) {
            return "";
        }
        StringBuffer __BUFFER__ = null;
        char[] buffer = null;
        try {
            __BUFFER__ = new StringBuffer(256);
            __BUFFER__.setLength(0);
            buffer = CharArrayContainer.getInstance();
            while (true) {
                int bytes23322;
                if ((bytes23322 = in.read(buffer)) < 0) {
                    bytes23322 = this.EMS_CONNECTION.decode(__BUFFER__.toString());
                    break;
                }
                __BUFFER__.append(buffer, 0, bytes23322);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CharArrayContainer.recycleInstance(buffer);
                __BUFFER__ = null;
                throw throwable;
            }
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CharArrayContainer.recycleInstance(buffer);
        return bytes23322;
    }

    public synchronized void putToMap(Map data, boolean attach_full) throws Exception {
        StringBuffer buffer = null;
        try {
            if (attach_full) {
                buffer = new StringBuffer(1024);
                buffer.setLength(0);
            }
            for (int i = 1; i <= this.colcount; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("source:" + this.rs.getString(i));
                    log.debug("target:" + this.EMS_CONNECTION.decode(this.rs.getString(i)));
                }
                if ("mysql".equals(eMsLocale.DB_TYPE)) {
                    data.put(this.rsmt.getColumnLabel(i).toUpperCase(), this.EMS_CONNECTION.decode(this.rs.getString(i)));
                } else {
                    data.put(this.rsmt.getColumnName(i).toUpperCase(), this.EMS_CONNECTION.decode(this.rs.getString(i)));
                }
                if (!attach_full) continue;
                DelimConvertor.encodeToBuffer(buffer, this.EMS_CONNECTION.decode(this.rs.getString(i)));
                buffer.append("|");
            }
            if (attach_full) {
                buffer.setLength(buffer.length() - 1);
                data.put("TOTAL_SPOOL_LINE", buffer.toString());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (attach_full) {
                buffer = null;
            }
        }
    }

    public synchronized void putToMap(Map data, boolean attach_full, String dbType) throws Exception {
        StringBuffer buffer = null;
        try {
            if (attach_full) {
                buffer = new StringBuffer(1024);
                buffer.setLength(0);
            }
            for (int i = 1; i <= this.colcount; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("source:" + this.rs.getString(i));
                    log.debug("target:" + this.EMS_CONNECTION.decode(this.rs.getString(i)));
                }
                if ("mysql".equals(dbType)) {
                    data.put(this.rsmt.getColumnLabel(i).toUpperCase(), this.EMS_CONNECTION.decode(this.rs.getString(i)));
                } else {
                    data.put(this.rsmt.getColumnName(i).toUpperCase(), this.EMS_CONNECTION.decode(this.rs.getString(i)));
                }
                if (!attach_full) continue;
                DelimConvertor.encodeToBuffer(buffer, this.EMS_CONNECTION.decode(this.rs.getString(i)));
                buffer.append("|");
            }
            if (attach_full) {
                buffer.setLength(buffer.length() - 1);
                data.put("TOTAL_SPOOL_LINE", buffer.toString());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (attach_full) {
                buffer = null;
            }
        }
    }

    public synchronized void putToMapAndStringBuffer(StringBuffer __INNER_STRING_BUFFER__, Map data) throws Exception {
        for (int i = 1; i <= this.colcount; ++i) {
            if ("mysql".equals(eMsLocale.DB_TYPE)) {
                data.put(this.rsmt.getColumnLabel(i).toUpperCase(), this.EMS_CONNECTION.decode(this.rs.getString(i)));
            } else {
                data.put(this.rsmt.getColumnName(i).toUpperCase(), this.EMS_CONNECTION.decode(this.rs.getString(i)));
            }
            DelimConvertor.encodeToBuffer(__INNER_STRING_BUFFER__, this.EMS_CONNECTION.decode(this.rs.getString(i)));
            __INNER_STRING_BUFFER__.append("|");
        }
        __INNER_STRING_BUFFER__.setLength(__INNER_STRING_BUFFER__.length() - 1);
    }

    public synchronized void putToString(StringBuffer data) throws Exception {
        for (int i = 1; i <= this.colcount; ++i) {
            data.append("[");
            if ("mysql".equals(eMsLocale.DB_TYPE)) {
                data.append(this.rsmt.getColumnLabel(i).toUpperCase());
            } else {
                data.append(this.rsmt.getColumnName(i).toUpperCase());
            }
            data.append("|");
            data.append(this.EMS_CONNECTION.decode(this.rs.getString(i)));
            data.append("]");
        }
    }

    public synchronized void putToWriter(eMsFileWriter out) throws Exception {
        this.putToWriter(out, "\t", false);
    }

    public synchronized void putToWriter(eMsFileWriter out, String delim) throws Exception {
        this.putToWriter(out, delim, false);
    }

    public synchronized void putToWriter(eMsFileWriter out, String delim, boolean addTT) throws Exception {
        if (addTT) {
            out.write("\"");
        }
        out.write(DelimConvertor.encode(this.getString(1)));
        if (addTT) {
            out.write("\"");
        }
        for (int i = 2; i <= this.colcount; ++i) {
            out.write(delim);
            if (addTT) {
                out.write("\"");
            }
            out.write(DelimConvertor.encode(this.getString(i)));
            if (!addTT) continue;
            out.write("\"");
        }
        out.println();
    }
}

