/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.task;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

public class SystemCheckTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(SystemCheckTask.class);
    public static String QUERY_UPDATE_SYSTEM_SERVER_INFO = null;
    public static String QUERY_UPSERT_SYSTEM_SERVER_INFO = null;
    public static String QUERY_UPDATE_SYSTEM_DAEMON_INFO = null;
    public static String QUERY_UPSERT_SYSTEM_DAEMON_INFO = null;
    public static String server_id = "";
    public static String daemon_id = "";
    public static String daemon_name = "daemon";
    public static String analysis_type = "daemon";
    public static String hdd_path = "";
    public static String db_type = "";
    public static String db_url = "";
    public static String db_id = "";
    public static String db_pw = "";
    public static String db_schema = "";
    public static String db_info = "";
    public static double max_db = 1048576.0;
    public static double warning_db_percent = 80.0;
    public static double warning_hdd_percent = 80.0;
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement __SELECT_STATEMENT__ = null;

    public SystemCheckTask() {
        super((short)2);
        this.setName("SystemCheckTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("SystemCheckTask");
    }

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        server_id = prop.getProperty("tms.server.id");
        daemon_id = prop.getProperty("tms.daemon.id");
        daemon_name = prop.getProperty("tms.daemon.name");
        analysis_type = prop.getProperty("analysis.type", "daemon");
        if (SystemCheckTask.canUpdateServerInfo()) {
            db_type = prop.getProperty("db.type");
            hdd_path = prop.getProperty("hdd.path");
            db_info = prop.getProperty("db.info");
            File dbInfo = new File(db_info);
            Properties tmpinfo = new Properties();
            tmpinfo.load(new FileInputStream(dbInfo));
            db_url = tmpinfo.getProperty("ems.url");
            db_id = tmpinfo.getProperty("ems.id");
            db_pw = tmpinfo.getProperty("ems.pass");
            db_schema = tmpinfo.getProperty("ems.db.schema");
            warning_hdd_percent = Double.valueOf(prop.getProperty("warning.hdd.percent"));
            max_db = Double.valueOf(prop.getProperty("max.db"));
            warning_db_percent = Double.valueOf(prop.getProperty("warning.db.percent"));
        }
        if (log.isDebugEnabled()) {
            log.debug("SYSTEM CHECK TASK INIT...");
        }
        SystemCheckTask.initDaemonAndServerInfo();
    }

    public static boolean canUpdateServerInfo() {
        return "server".equals(analysis_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDaemonAndServerInfo() {
        eMsConnection connection = null;
        eMsStatement stmt = null;
        try {
            Properties prop = new Properties();
            prop.setProperty("SERVER_ID", server_id);
            prop.setProperty("DAEMON_ID", daemon_id);
            prop.setProperty("DAEMON_NAME", daemon_name);
            String execDaemonQuery = StringConvertUtil.ConvertString(QUERY_UPSERT_SYSTEM_DAEMON_INFO, prop, "${", "}", true, false);
            connection = ConnectionPool.getConnection();
            stmt = connection.createStatement();
            stmt.executeUpdate(execDaemonQuery);
            if (SystemCheckTask.canUpdateServerInfo()) {
                prop.setProperty("SERVER_NAME", server_id);
                long totalHdd = SystemCheckTask.GetMaxHddSpace(hdd_path);
                prop.setProperty("MAX_HDD", String.valueOf(totalHdd));
                prop.setProperty("WARNING_HDD", String.valueOf((double)totalHdd * warning_hdd_percent / 100.0));
                prop.setProperty("MAX_DB", String.valueOf(max_db));
                prop.setProperty("WARNING_DB", String.valueOf(max_db * warning_db_percent / 100.0));
                prop.setProperty("HDD_PATH", hdd_path);
                prop.setProperty("CURRENT_HDD", String.valueOf(SystemCheckTask.GetFreeHDDSpace(hdd_path)));
                prop.setProperty("CURRENT_DB", String.valueOf(SystemCheckTask.GetDBSpace(db_type, db_url, db_id, db_pw)));
                String execServerQuery = StringConvertUtil.ConvertString(QUERY_UPSERT_SYSTEM_SERVER_INFO, prop, "${", "}", true, false);
                stmt.execute(execServerQuery);
            }
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("SystemCheck_at_".concat(Cal.getSerialDate()));
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        this.__SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(" Request Connection Error");
        log.error(this.getName(), thw);
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycleStatement(this.__SELECT_STATEMENT__);
            this.EMS_CONNECTION.recycle();
        }
    }

    @Override
    public void execute() throws Exception {
        this.check_system();
    }

    private synchronized void check_system() throws Exception {
        Properties SYSTEM_INFO = new Properties();
        SYSTEM_INFO.setProperty("SERVER_ID", server_id);
        SYSTEM_INFO.setProperty("DAEMON_ID", daemon_id);
        if (SystemCheckTask.canUpdateServerInfo()) {
            log.debug(" is GetFreeHDDSpace method  START...");
            long freeHdd = SystemCheckTask.GetFreeHDDSpace(hdd_path);
            log.debug(" is GetFreeHDDSpace method  END...");
            log.debug(" is GetDBSpace method  START...");
            long freeDb = SystemCheckTask.GetDBSpace(db_type, db_url, db_id, db_pw);
            log.debug(" is GetDBSpace method  END...");
            SYSTEM_INFO.setProperty("CURRENT_HDD", String.valueOf(freeHdd));
            SYSTEM_INFO.setProperty("CURRENT_DB", String.valueOf(freeDb));
            String execServerQuery = StringConvertUtil.ConvertString(QUERY_UPDATE_SYSTEM_SERVER_INFO, SYSTEM_INFO, "${", "}", true, false);
            log.debug(" is UPDATE SERVER QUERY ..." + execServerQuery);
            this.__SELECT_STATEMENT__.executeUpdate(execServerQuery);
        }
        String execDaemonQuery = StringConvertUtil.ConvertString(QUERY_UPDATE_SYSTEM_DAEMON_INFO, SYSTEM_INFO, "${", "}", true, false);
        log.debug(" is UPDATE DAEMON QUERY ..." + execDaemonQuery);
        this.__SELECT_STATEMENT__.executeUpdate(execDaemonQuery);
    }

    public static long GetFreeHDDSpace(String path) {
        long freeSpace = 0L;
        try {
            freeSpace = new File(path).getFreeSpace() / 0x100000L;
        }
        catch (Exception e) {
            log.error("hdd free space error", (Throwable)e);
        }
        return freeSpace;
    }

    public static long GetMaxHddSpace(String path) {
        long freeSpace = 0L;
        try {
            freeSpace = new File(path).getTotalSpace() / 0x100000L;
        }
        catch (Exception e) {
            log.error("hdd max space error", (Throwable)e);
        }
        return freeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetDBSpace(String DB, String url, String id, String pw) {
        long rtn = 0L;
        Connection con = null;
        Statement cstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = "";
        try {
            con = DriverManager.getConnection(url, id, pw);
            if (DB.equalsIgnoreCase("mssql")) {
                cstmt = con.prepareCall("{call sp_spaceused}");
                rs = cstmt.executeQuery();
                if (rs.next()) {
                    rtn = (int)Float.parseFloat(rs.getString(2).replaceAll("MB", "").replaceAll(" ", "").replaceAll(",", ""));
                }
            } else if (DB.equalsIgnoreCase("oracle")) {
            } else if (DB.equalsIgnoreCase("mysql")) {
                stmt = con.createStatement();
                query = query + "SELECT SUM(data_length+index_length) used_MB, SUM(data_free) free_MB       ,(SUM(data_length+index_length)+SUM(data_free)) total_MB  FROM information_schema.tables WHERE table_schema = '" + db_schema + "' ";
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    rtn += rs.getLong("free_MB");
                }
                rtn = rtn / 1024L / 1024L;
            }
        }
        catch (Exception e) {
            log.error("DB space error", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetOracleDBSize(Connection con) {
        if (con == null) {
            return 0L;
        }
        long rtn = 0L;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select sum(bytes) from user_free_space");
            while (rs.next()) {
                rtn += rs.getLong(1);
            }
            rtn = rtn / 1024L / 1024L;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return rtn;
    }

    static {
        try {
            QUERY_UPSERT_SYSTEM_SERVER_INFO = SqlManager.getQuery("SYSTEM_INFO_CHECK", "QUERY_UPSERT_SYSTEM_SERVER_INFO");
            QUERY_UPDATE_SYSTEM_SERVER_INFO = SqlManager.getQuery("SYSTEM_INFO_CHECK", "QUERY_UPDATE_SYSTEM_SERVER_INFO");
            QUERY_UPSERT_SYSTEM_DAEMON_INFO = SqlManager.getQuery("SYSTEM_INFO_CHECK", "QUERY_UPSERT_SYSTEM_DAEMON_INFO");
            QUERY_UPDATE_SYSTEM_DAEMON_INFO = SqlManager.getQuery("SYSTEM_INFO_CHECK", "QUERY_UPDATE_SYSTEM_DAEMON_INFO");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

