/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.task;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.reporter.Reporter;
import pluto.schedule.Task;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;

public class HardBounceFilterTask
extends Task {
    private static final Logger log = LoggerFactory.getLogger(HardBounceFilterTask.class);
    private static String QUERY_SELECT_ERROR_LIST_INFO = null;
    private static Hashtable HT_ERROR_LIST = null;
    protected eMsConnection EMS_CONNECTION = null;
    protected eMsStatement __SELECT_STATEMENT__ = null;

    public static void init(Object tmp) throws Exception {
    }

    public HardBounceFilterTask() {
        this.setName("HardBounceFilterTask_at_".concat(Cal.getSerialDate()));
        this.setTaskID("HardBounceFilterTask");
    }

    @Override
    public void execute_initiate() throws Exception {
        this.setName("HardBounceFilterTask_at_".concat(Cal.getSerialDate()));
        this.EMS_CONNECTION = ConnectionPool.getConnection();
        this.__SELECT_STATEMENT__ = this.EMS_CONNECTION.createStatement();
    }

    @Override
    public void execute_initiateError(Throwable thw) {
        log.error(" Request Connection Error");
        log.error(this.getName(), thw);
        if (!(thw instanceof SQLException)) {
            Reporter.report("common", this.getName(), "HardBounceFilterTask.init.err", thw);
        }
    }

    @Override
    public void release_Resource() {
        if (this.EMS_CONNECTION != null) {
            this.EMS_CONNECTION.recycleStatement(this.__SELECT_STATEMENT__);
            this.EMS_CONNECTION.recycle();
        }
    }

    @Override
    public void execute() throws Exception {
        eMsResultSet ERR_LIST = null;
        HT_ERROR_LIST.clear();
        try {
            ERR_LIST = this.__SELECT_STATEMENT__.executeQuery(QUERY_SELECT_ERROR_LIST_INFO);
            while (ERR_LIST.next()) {
                Properties LIST = new Properties();
                ERR_LIST.putToMap(LIST, false);
                HT_ERROR_LIST.put(CryptoUtil.deEmailAddr(LIST.getProperty("ERR_EMAIL")), CryptoUtil.deEmailAddr(LIST.getProperty("ERR_EMAIL")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.EMS_CONNECTION != null) {
                this.EMS_CONNECTION.recycleStatement(this.__SELECT_STATEMENT__);
                this.EMS_CONNECTION.recycle();
            }
        }
    }

    public static synchronized boolean checkErrEmail(String email) {
        boolean b_chk = true;
        Object o_Tmp = HT_ERROR_LIST.get(email);
        if (o_Tmp == null) {
            b_chk = false;
        }
        return b_chk;
    }

    static {
        try {
            QUERY_SELECT_ERROR_LIST_INFO = SqlManager.getQuery("ERROR_LIST_INFO", "QUERY_SELECT_ERROR_LIST_INFO");
            HT_ERROR_LIST = new Hashtable();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

