/*
 * Decompiled with CFR 0.152.
 */
package pluto.common.log;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.common.log.LogUpdatorImpl;
import pluto.db.eMsConnection;
import pluto.log.LogTypeUpdator;
import pluto.log.LogUpdator;

public abstract class LogTypeUpdatorImpl
extends LogUpdatorImpl
implements LogTypeUpdator {
    private static final Logger log = LoggerFactory.getLogger(LogTypeUpdatorImpl.class);
    protected Hashtable TYPE_UPDATE_HASH = null;

    @Override
    public void setUpdateRules(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        this.TYPE_UPDATE_HASH = new Hashtable();
        Enumeration<Object> eNum = prop.keys();
        while (eNum.hasMoreElements()) {
            String key = (String)eNum.nextElement();
            if (!key.startsWith("type.") || !key.endsWith(".class")) continue;
            log.debug("LOAD[" + key.substring(5, key.indexOf(".class")) + "]", (Object)prop.getProperty(key));
            this.TYPE_UPDATE_HASH.put(key.substring(5, key.indexOf(".class")), Class.forName(prop.getProperty(key)).newInstance());
        }
    }

    @Override
    public abstract String update(Object var1) throws Exception;

    @Override
    public void init_connection(eMsConnection conn) throws Exception {
        if (this.TYPE_UPDATE_HASH != null) {
            Enumeration eNum = this.TYPE_UPDATE_HASH.elements();
            while (eNum.hasMoreElements()) {
                ((LogUpdator)eNum.nextElement()).init_connection(conn);
            }
        }
        super.init_connection(conn);
    }

    @Override
    public void clear_connection() {
        if (this.TYPE_UPDATE_HASH != null) {
            Enumeration eNum = this.TYPE_UPDATE_HASH.elements();
            while (eNum.hasMoreElements()) {
                ((LogUpdator)eNum.nextElement()).clear_connection();
            }
        }
        super.clear_connection();
    }

    @Override
    public void setKeyUpdator(String key, LogUpdator updator) {
        if (this.TYPE_UPDATE_HASH == null) {
            this.TYPE_UPDATE_HASH = new Hashtable();
        }
        this.TYPE_UPDATE_HASH.put(key, updator);
    }
}

