/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.DNS.Message;
import pluto.DNS.Name;
import pluto.DNS.OPTRecord;
import pluto.DNS.Options;
import pluto.DNS.Rcode;
import pluto.DNS.Record;
import pluto.DNS.ResolveThread;
import pluto.DNS.Resolver;
import pluto.DNS.ResolverListener;
import pluto.DNS.TSIG;
import pluto.DNS.TSIGRecord;
import pluto.DNS.WireParseException;
import pluto.DNS.ZoneTransferException;
import pluto.DNS.ZoneTransferIn;
import pluto.DNS.utils.hexdump;

public class SimpleResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(SimpleResolver.class);
    public static final int DEFAULT_PORT = 53;
    private InetAddress addr;
    private int port = 53;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private byte EDNSlevel = (byte)-1;
    private TSIG tsig;
    private int timeoutValue = 10000;
    private static final short DEFAULT_UDPSIZE = 512;
    private static final short EDNS_UDPSIZE = 1280;
    private static int uniqueID = 0;

    public SimpleResolver(InetAddress hostname) throws UnknownHostException {
        this.addr = hostname;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return this.addr.getHostAddress() + ":" + String.valueOf(this.port);
    }

    @Override
    public void setTCP(boolean flag) {
        this.useTCP = flag;
    }

    @Override
    public void setIgnoreTruncation(boolean flag) {
        this.ignoreTruncation = flag;
    }

    @Override
    public void setEDNS(int level) {
        if (level != 0 && level != -1) {
            throw new UnsupportedOperationException("invalid EDNS level - must be 0 or -1");
        }
        this.EDNSlevel = (byte)level;
    }

    @Override
    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    @Override
    public void setTSIGKey(Name name, byte[] key) {
        this.tsig = new TSIG(name, key);
    }

    @Override
    public void setTSIGKey(String name, String key) {
        this.tsig = new TSIG(name, key);
    }

    @Override
    public void setTSIGKey(String key) throws UnknownHostException {
        this.setTSIGKey(InetAddress.getLocalHost().getHostName(), key);
    }

    @Override
    public void setTimeout(int secs) {
        this.timeoutValue = secs * 1000;
    }

    private byte[] readUDP(DatagramSocket s, int max) throws IOException {
        DatagramPacket dp = new DatagramPacket(new byte[max], max);
        s.receive(dp);
        byte[] in = new byte[dp.getLength()];
        System.arraycopy(dp.getData(), 0, in, 0, in.length);
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("UDP read", in));
        }
        return in;
    }

    private void writeUDP(DatagramSocket s, byte[] out, InetAddress addr, int port) throws IOException {
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("UDP write", out));
        }
        s.send(new DatagramPacket(out, out.length, addr, port));
    }

    private byte[] readTCP(Socket s) throws IOException {
        DataInputStream dataIn = new DataInputStream(s.getInputStream());
        int inLength = dataIn.readUnsignedShort();
        byte[] in = new byte[inLength];
        dataIn.readFully(in);
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("TCP read", in));
        }
        return in;
    }

    private void writeTCP(Socket s, byte[] out) throws IOException {
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("TCP write", out));
        }
        DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
        dataOut.writeShort(out.length);
        dataOut.write(out);
        dataOut.flush();
    }

    private Message parseMessage(byte[] b) throws WireParseException {
        try {
            return new Message(b);
        }
        catch (IOException e2) {
            WireParseException e2;
            if (Options.check("verbose")) {
                log.error(e2.getMessage());
            }
            if (!(e2 instanceof WireParseException)) {
                e2 = new WireParseException("Error parsing message");
            }
            throw (WireParseException)e2;
        }
    }

    private void verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return;
        }
        int error = tsig.verify(response, b, query.getTSIG());
        response.tsigState = error == 0 ? 1 : 4;
        if (Options.check("verbose")) {
            System.err.println("TSIG verify: " + Rcode.string(error));
        }
    }

    private void applyEDNS(Message query) {
        if (this.EDNSlevel < 0 || query.getOPT() != null) {
            return;
        }
        OPTRecord opt = new OPTRecord(1280, 0, 0);
        query.addRecord(opt, 3);
    }

    private int maxUDPSize(Message query) {
        OPTRecord opt = query.getOPT();
        if (opt == null) {
            return 512;
        }
        return opt.getPayloadSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message send(Message query) throws IOException {
        Message response;
        Record question;
        if (Options.check("verbose")) {
            System.err.println("Sending to " + this.addr.getHostAddress() + ":" + this.port);
        }
        if (query.getHeader().getOpcode() == 0 && (question = query.getQuestion()) != null && question.getType() == 252) {
            return this.sendAXFR(query);
        }
        query = (Message)query.clone();
        this.applyEDNS(query);
        if (this.tsig != null) {
            this.tsig.apply(query, null);
        }
        byte[] out = query.toWire(65535);
        int udpSize = this.maxUDPSize(query);
        boolean tcp = false;
        boolean nowrite = false;
        while (true) {
            byte[] in;
            Runnable SURE_SOCKET;
            Closeable s;
            if (this.useTCP || out.length > udpSize) {
                tcp = true;
            }
            if (tcp) {
                if (log.isDebugEnabled()) {
                    log.debug("TCP TYPE");
                }
                s = new Socket(this.addr, this.port);
                SURE_SOCKET = new SureShutdownSocket((Socket)s, this.timeoutValue);
                try {
                    this.writeTCP((Socket)s, out);
                    in = this.readTCP((Socket)s);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.error(e.getMessage());
                    }
                    throw e;
                }
                finally {
                    ((SureShutdownSocket)SURE_SOCKET).close();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("UDP TYPE");
            }
            s = new DatagramSocket();
            SURE_SOCKET = new SureShutdownDatagramSocket((DatagramSocket)s, this.timeoutValue);
            try {
                if (!nowrite) {
                    this.writeUDP((DatagramSocket)s, out, this.addr, this.port);
                }
                in = this.readUDP((DatagramSocket)s, udpSize);
            }
            finally {
                ((SureShutdownDatagramSocket)SURE_SOCKET).close();
            }
            if (in.length < 12) {
                throw new WireParseException("invalid DNS header - too short");
            }
            int id = ((in[0] & 0xFF) << 8) + (in[1] & 0xFF);
            int qid = query.getHeader().getID();
            if (id != qid) {
                String error = "invalid message id: expected " + qid + "; got id " + id;
                if (tcp) {
                    throw new WireParseException(error);
                }
                if (Options.check("verbose")) {
                    System.err.println(error);
                }
                nowrite = true;
                continue;
            }
            response = this.parseMessage(in);
            this.verifyTSIG(query, response, in, this.tsig);
            if (tcp || this.ignoreTruncation || !response.getHeader().getFlag(6)) break;
            tcp = true;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object sendAsync(Message query, ResolverListener listener) {
        Integer id;
        if (log.isDebugEnabled()) {
            log.debug("call sendAsync ");
        }
        SimpleResolver simpleResolver = this;
        synchronized (simpleResolver) {
            id = new Integer(uniqueID++);
        }
        Record question = query.getQuestion();
        String qname = question != null ? question.getName().toString() : "(none)";
        String name = this.getClass() + ": " + qname;
        ResolveThread thread = new ResolveThread(this, query, id, listener);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
        return id;
    }

    private Message sendAXFR(Message query) throws IOException {
        Name qname = query.getQuestion().getName();
        ZoneTransferIn xfrin = ZoneTransferIn.newAXFR(qname, this);
        try {
            xfrin.run();
        }
        catch (ZoneTransferException e) {
            throw new WireParseException(e.getMessage());
        }
        List records = xfrin.getAXFR();
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(5);
        response.getHeader().setFlag(0);
        response.addRecord(query.getQuestion(), 0);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            response.addRecord((Record)it.next(), 1);
        }
        return response;
    }

    static class Stream {
        SimpleResolver res;
        Socket sock;
        TSIG tsig;
        TSIG.StreamVerifier verifier;

        Stream(SimpleResolver res) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("CREATE INNER STREAM INSTANCE");
            }
            this.res = res;
            this.sock = new Socket(res.addr, res.port);
            this.sock.setSoTimeout(res.timeoutValue);
            this.tsig = res.tsig;
        }

        void send(Message query) throws IOException {
            if (this.tsig != null) {
                this.tsig.apply(query, null);
                this.verifier = new TSIG.StreamVerifier(this.tsig, query.getTSIG());
            }
            byte[] out = query.toWire(65535);
            this.res.writeTCP(this.sock, out);
        }

        Message next() throws IOException {
            byte[] in = this.res.readTCP(this.sock);
            Message response = this.res.parseMessage(in);
            if (response.getHeader().getRcode() != 0) {
                return response;
            }
            if (this.verifier != null) {
                TSIGRecord tsigrec = response.getTSIG();
                int error = this.verifier.verify(response, in);
                response.tsigState = error == 0 && tsigrec != null ? 1 : (error == 0 ? 2 : 4);
            }
            return response;
        }

        void close() {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class SureShutdownDatagramSocket
    implements Runnable {
        long timeout;
        DatagramSocket socket;
        boolean connection_end;
        Thread inner_monitor_thread = null;

        SureShutdownDatagramSocket(DatagramSocket s, int t) throws IOException {
            this.socket = s;
            this.timeout = t;
            this.socket.setSoTimeout(t);
            this.connection_end = false;
            this.inner_monitor_thread = new Thread((Runnable)this, "DNS Session Monitor");
            this.inner_monitor_thread.start();
        }

        void close() throws IOException {
            this.connection_end = true;
            this.inner_monitor_thread.interrupt();
            this.socket.close();
        }

        @Override
        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.connection_end) {
                if (log.isDebugEnabled()) {
                    log.debug("Already Close");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("DNS Session Not Complete in : " + String.valueOf(this.timeout) + "ms So Close Socket");
                }
                try {
                    this.socket.close();
                }
                catch (Throwable thw) {
                    log.error("socket error", thw);
                }
            }
        }
    }

    static class SureShutdownSocket
    implements Runnable {
        long timeout;
        Socket socket;
        boolean connection_end;
        Thread inner_monitor_thread = null;

        SureShutdownSocket(Socket s, int t) throws IOException {
            this.socket = s;
            this.timeout = t;
            this.socket.setSoTimeout(t);
            this.connection_end = false;
            this.inner_monitor_thread = new Thread((Runnable)this, "DNS Session Monitor");
            this.inner_monitor_thread.start();
        }

        void close() throws IOException {
            this.connection_end = true;
            this.inner_monitor_thread.interrupt();
            this.socket.close();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.connection_end) {
                if (log.isDebugEnabled()) {
                    log.debug("Already Close");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("DNS Session Not Complete in : " + String.valueOf(this.timeout) + "ms So Close Socket");
                }
                try {
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                }
                catch (Throwable thw) {
                    log.error("socket shudown error", thw);
                }
                try {
                    this.socket.close();
                }
                catch (Throwable thw) {
                    log.error("socket close error", thw);
                }
            }
        }
    }
}

