/*
 * Decompiled with CFR 0.152.
 */
package pluto.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pluto.DNS.Compression;
import pluto.DNS.DNSInput;
import pluto.DNS.DNSOutput;
import pluto.DNS.Mnemonic;
import pluto.DNS.Name;
import pluto.DNS.Record;
import pluto.DNS.Tokenizer;
import pluto.DNS.Type;
import pluto.DNS.WireParseException;

public class NSECRecord
extends Record {
    private Name next;
    private int[] types;

    NSECRecord() {
    }

    @Override
    Record getObject() {
        return new NSECRecord();
    }

    public NSECRecord(Name name, int dclass, long ttl, Name next, int[] types) {
        super(name, 47, dclass, ttl);
        this.next = NSECRecord.checkName("next", next);
        for (int i = 0; i < types.length; ++i) {
            Type.check(types[i]);
        }
        this.types = new int[types.length];
        System.arraycopy(types, 0, this.types, 0, types.length);
        Arrays.sort(this.types);
    }

    private int[] listToArray(List list) {
        int size = list.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (Integer)list.get(i);
        }
        return array;
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.next = new Name(in);
        int lastbase = -1;
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (in.remaining() > 0) {
            if (in.remaining() < 2) {
                throw new WireParseException("invalid bitmap descriptor");
            }
            int mapbase = in.readU8();
            if (mapbase < lastbase) {
                throw new WireParseException("invalid ordering");
            }
            int maplength = in.readU8();
            if (maplength > in.remaining()) {
                throw new WireParseException("invalid bitmap");
            }
            for (int i = 0; i < maplength; ++i) {
                int current = in.readU8();
                if (current == 0) continue;
                for (int j = 0; j < 8; ++j) {
                    if ((current & 1 << 7 - j) == 0) continue;
                    int typecode = mapbase * 256 + i * 8 + j;
                    list.add(Mnemonic.toInteger(typecode));
                }
            }
        }
        this.types = this.listToArray(list);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.next = st.getName(origin);
        ArrayList<Integer> list = new ArrayList<Integer>();
        while ((t = st.get()).isString()) {
            int type = Type.value(t.value);
            if (type < 0) {
                throw st.exception("Invalid type: " + t.value);
            }
            list.add(Mnemonic.toInteger(type));
        }
        st.unget();
        this.types = this.listToArray(list);
        Arrays.sort(this.types);
    }

    @Override
    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.next);
        for (int i = 0; i < this.types.length; ++i) {
            sb.append(" ");
            sb.append(Type.string(this.types[i]));
        }
        return sb.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public int[] getTypes() {
        int[] array = new int[this.types.length];
        System.arraycopy(this.types, 0, array, 0, this.types.length);
        return array;
    }

    public boolean hasType(int type) {
        return Arrays.binarySearch(this.types, type) >= 0;
    }

    static void mapToWire(DNSOutput out, int[] array, int mapbase, int mapstart, int mapend) {
        int j;
        int mapmax = array[mapend - 1] & 0xFF;
        int maplength = mapmax / 8 + 1;
        int[] map = new int[maplength];
        out.writeU8(mapbase);
        out.writeU8(maplength);
        for (j = mapstart; j < mapend; ++j) {
            int typecode = array[j];
            int n = (typecode & 0xFF) / 8;
            map[n] = map[n] | 1 << 7 - typecode % 8;
        }
        for (j = 0; j < maplength; ++j) {
            out.writeU8(map[j]);
        }
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.next.toWire(out, null, canonical);
        if (this.types.length == 0) {
            return;
        }
        int mapbase = -1;
        int mapstart = -1;
        for (int i = 0; i < this.types.length; ++i) {
            int base = this.types[i] >> 8;
            if (base == mapbase) continue;
            if (mapstart >= 0) {
                NSECRecord.mapToWire(out, this.types, mapbase, mapstart, i);
            }
            mapbase = base;
            mapstart = i;
        }
        NSECRecord.mapToWire(out, this.types, mapbase, mapstart, this.types.length);
    }
}

