/*
 * Decompiled with CFR 0.152.
 */
package moon.plan.actor;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.common.bean.PlanBean;
import pluto.lang.Name;
import pluto.net.communicator.InfoActor;
import pluto.net.communicator.InfoBeans;
import pluto.net.communicator.InfoComunicator;
import pluto.util.Cal;

public class FlowPlanControlActor
extends Name
implements InfoActor {
    private static final Logger log = LoggerFactory.getLogger(FlowPlanControlActor.class);
    private static final String HANDLER = "moon.plan.actor.FlowPlanControlActor";

    public FlowPlanControlActor() {
        this.setName("DomainFilterActor" + Cal.getSerialDate());
    }

    @Override
    public void execute(InfoBeans arg) throws Exception {
        log.info("[execute]...[start]");
        Properties prop = arg.getArgs();
        String actFlag = prop.getProperty("ACTFLAG");
        String resultStr = "";
        if (log.isDebugEnabled()) {
            log.info("[ACTFLAG] :" + actFlag);
        }
        if (actFlag.equals("INIT")) {
            log.info("[INIT]");
            PlanBean.cleanPlanInfo();
            resultStr = "CLEAN_OK";
        }
        prop.setProperty("RESULT", resultStr);
        log.info("[execute]...[end]");
    }

    public String flowPlanCleanCommu(ArrayList<String> arry) throws Exception {
        if (arry == null || arry.size() == 0) {
            return "COMMU list is null";
        }
        StringBuffer returnBuffer = new StringBuffer();
        Properties prop = new Properties();
        prop.setProperty("ACTFLAG", "INIT");
        int arrySize = arry.size();
        String arryStr = "";
        String serverIp = "";
        String serverPort = "";
        int port = 0;
        String returnStr = "";
        boolean firstFlag = true;
        for (int i = 0; i < arrySize; ++i) {
            arryStr = arry.get(i);
            int idx = arryStr.indexOf(":");
            if (idx < 0) continue;
            serverIp = arryStr.substring(0, idx);
            serverPort = arryStr.substring(idx + 1);
            try {
                port = Integer.parseInt(serverPort);
            }
            catch (Exception ex) {
                log.error(this.getName(), (Throwable)ex);
                continue;
            }
            returnStr = this.commu(prop, serverIp, port);
            if ("CLEAN_OK".equals(returnStr)) {
                if (firstFlag) {
                    firstFlag = false;
                } else {
                    returnBuffer.append(",");
                }
                returnBuffer.append(arryStr);
                continue;
            }
            log.error("[ERROR-from server] server:" + arryStr + ", " + returnStr);
        }
        return returnBuffer.toString();
    }

    private String commu(Properties prop, String serverIp, int serverPort) throws Exception {
        InfoBeans bean;
        String returnMsg;
        block3: {
            returnMsg = "init";
            bean = new InfoBeans();
            bean.setArgs(prop);
            bean.setHandler(HANDLER);
            bean.setServerIP(serverIp);
            bean.setServerPORT(serverPort);
            InfoComunicator commu = new InfoComunicator();
            commu.setInfoBeans(bean);
            try {
                bean = commu.execute();
            }
            catch (Exception e) {
                if (!(e instanceof ConnectException)) break block3;
                returnMsg = "ERROR-Communication : You need to check the engine.";
            }
        }
        if (returnMsg.equals("init")) {
            returnMsg = bean.getProperty("RESULT");
        }
        return returnMsg;
    }
}

