/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.body;

import freemarker20.template.SimpleHash;
import java.util.Properties;
import mercury.contents.common.body.SimpleMailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.message.SimpleMessage;
import mercury.contents.common.parser.BinaryAttachBodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneByOneAttachMailBody
extends SimpleMailBody {
    private static final Logger log = LoggerFactory.getLogger(OneByOneAttachMailBody.class);

    @Override
    public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        String MIME_BASE_CHAR_SET = SCHEDULE_INFO.getProperty("MAIL_BASE_CHAR_SET", "euc-kr");
        Object[] attachMsg = this.makeAttachFiles((SimpleHash)info1, MIME_BASE_CHAR_SET);
        int BODY_TYPE = 0;
        BODY_TYPE = attachMsg != null && attachMsg.length != 0 ? 1 : 2;
        this.byteBuffer.reset();
        this.setHeaderString(info1, info2, SCHEDULE_INFO, this.byteBuffer);
        if (log.isDebugEnabled()) {
            log.debug("header", (Object)this.byteBuffer.toString());
        }
        switch (BODY_TYPE) {
            case 2: {
                ((Message)this.myMessages.get(0)).putHeaderToStream(this.byteBuffer);
                this.byteBuffer.write(NEW_LINE);
                if (log.isDebugEnabled()) {
                    log.debug(Thread.currentThread().getName() + "'s add message HEADER => " + this.byteBuffer.toString());
                }
                ((Message)this.myMessages.get(0)).putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
                this.byteBuffer.write(NEW_LINE);
                if (!log.isDebugEnabled()) break;
                log.debug(Thread.currentThread().getName() + "'s add message BODY => " + this.byteBuffer.toString());
                break;
            }
            case 1: {
                int i;
                String boundary = this.getBoundaryString();
                this.byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
                this.byteBuffer.write("\tboundary=\"".getBytes());
                this.byteBuffer.write(boundary.getBytes());
                this.byteBuffer.write("\"\r\n\r\n".getBytes());
                this.byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
                Message tmpMessage = null;
                for (i = 0; i < this.myMessages.size(); ++i) {
                    tmpMessage = (Message)this.myMessages.get(i);
                    this.byteBuffer.write("\n--".getBytes());
                    this.byteBuffer.write(boundary.getBytes());
                    this.byteBuffer.write(NEW_LINE);
                    tmpMessage.putHeaderToStream(this.byteBuffer);
                    this.byteBuffer.write(NEW_LINE);
                    tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
                    this.byteBuffer.write(NEW_LINE);
                }
                if (attachMsg != null) {
                    for (i = 0; i < attachMsg.length; ++i) {
                        tmpMessage = (Message)attachMsg[i];
                        if (tmpMessage == null) continue;
                        this.byteBuffer.write("\n--".getBytes());
                        this.byteBuffer.write(boundary.getBytes());
                        this.byteBuffer.write(NEW_LINE);
                        tmpMessage.putHeaderToStream(this.byteBuffer);
                        this.byteBuffer.write(NEW_LINE);
                        tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, this.byteBuffer);
                        this.byteBuffer.write(NEW_LINE);
                    }
                }
                this.byteBuffer.write("\r\n--".getBytes());
                this.byteBuffer.write(boundary.getBytes());
                this.byteBuffer.write("--\r\n\r\n".getBytes());
            }
        }
        return this.byteBuffer.toString();
    }

    public Object[] makeAttachFiles(SimpleHash userInfo, String charSet) throws Exception {
        String[] attachPath = this.getAttachFilePathFromMapping(userInfo);
        if (attachPath == null) {
            return null;
        }
        Object[] attachMsg = new Object[attachPath.length];
        BinaryAttachBodyParser bodyParser = null;
        SimpleMessage msg = null;
        for (int i = 0; i < attachPath.length; ++i) {
            if (attachPath[i].equals("")) continue;
            bodyParser = new BinaryAttachBodyParser();
            try {
                bodyParser.setContents(attachPath[i]);
            }
            catch (Exception e) {
                log.debug("[\ud574\ub2f9 \uacbd\ub85c\uc5d0 \ucca8\ubd80\ud30c\uc77c\uc774  \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.]");
                log.debug("Path = [" + attachPath[i] + "]");
                attachMsg[i] = null;
                continue;
            }
            msg = new SimpleMessage();
            msg.setContent(bodyParser);
            msg.setContentType(new Short(5));
            msg.setCharSet(charSet);
            msg.setContentEncoding(new Short(1));
            msg.setMessageID(Thread.currentThread().getName());
            msg.setContentName(attachPath[i].substring(attachPath[i].lastIndexOf(47) + 1));
            attachMsg[i] = msg;
        }
        return attachMsg;
    }

    public String[] getAttachFilePathFromMapping(SimpleHash userInfo) {
        String letter1 = userInfo.getAsString("ATTACH01");
        String letter2 = userInfo.getAsString("ATTACH02");
        String letter3 = userInfo.getAsString("ATTACH03");
        String letter4 = userInfo.getAsString("ATTACH04");
        String letter5 = userInfo.getAsString("ATTACH05");
        String[] letterList = new String[5];
        if (letter1 == null && letter2 == null && letter3 == null && letter4 == null && letter5 == null) {
            letterList = null;
        } else if (letter1.equals("") && letter2.equals("") && letter3.equals("") && letter4.equals("") && letter5.equals("")) {
            letterList = null;
        } else {
            letterList[0] = letter1 == null ? "" : letter1.replace('\\', '/');
            letterList[1] = letter2 == null ? "" : letter2.replace('\\', '/');
            letterList[2] = letter3 == null ? "" : letter3.replace('\\', '/');
            letterList[3] = letter4 == null ? "" : letter4.replace('\\', '/');
            letterList[4] = letter5 == null ? "" : letter5.replace('\\', '/');
        }
        return letterList;
    }
}

