/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.body;

import freemarker20.template.SimpleHash;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import mercury.contents.common.body.AttachBean;
import mercury.contents.common.body.SimpleMailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.message.SimpleMessage;
import mercury.contents.common.parser.BinaryAttachBodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.lang.eMsLocale;
import pluto.util.StringUtil;

public class AttachableMailBody
extends SimpleMailBody {
    private static final Logger log = LoggerFactory.getLogger(AttachableMailBody.class);
    public static String ATTACH_HEAD = "ATTACH";
    public static int ATTACH_CNT = 5;
    public static boolean ATTACH_USE = true;
    public static HashMap ATTACH_MAP = new HashMap();
    public static boolean ATTACH_KEEP_YN = false;
    public static int ATTACH_KEEP_CNT = 10;
    public static String FINAL_ACT_TIME = "";
    public static Properties PROP_FTP_INFO = null;
    public static String FTP_LOCAL_PATH = null;
    public static boolean FTP_USE_YN = false;

    public static void init(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        ATTACH_HEAD = prop.getProperty("attach.head", "ATTACH");
        ATTACH_CNT = Integer.parseInt(prop.getProperty("attach.cnt", "5"));
        ATTACH_USE = prop.getProperty("use.yn", "N").equals("Y");
        ATTACH_KEEP_YN = prop.getProperty("attach.keep.yn", "N").equals("Y");
        ATTACH_KEEP_CNT = Integer.parseInt(prop.getProperty("attach.keep.cnt", "10"));
        FTP_USE_YN = prop.getProperty("ftp.yn", "N").equals("Y");
        FTP_LOCAL_PATH = prop.getProperty("ftp.local.path", "");
        PROP_FTP_INFO = new Properties();
        PROP_FTP_INFO.setProperty("ftp.server", prop.getProperty("ftp.server", "100.254.55.85"));
        PROP_FTP_INFO.setProperty("ftp.username", prop.getProperty("ftp.username", "ems_user"));
        PROP_FTP_INFO.setProperty("ftp.password", prop.getProperty("ftp.password", "apdlf$00"));
        PROP_FTP_INFO.setProperty("ftp.port", prop.getProperty("ftp.port", "21"));
        PROP_FTP_INFO.setProperty("ftp.path", prop.getProperty("ftp.path", "/EMAIL_ATTACH"));
        PROP_FTP_INFO.setProperty("ftp.local.path", FTP_LOCAL_PATH);
        if (log.isDebugEnabled()) {
            log.debug("ATTACH MAIL INIT...");
        }
    }

    @Override
    public synchronized String getMailBody(Object info1, Object info2, Properties SCHEDULE_INFO) throws Exception {
        if (!ATTACH_USE) {
            return super.getMailBody(info1, info2, SCHEDULE_INFO);
        }
        if (log.isDebugEnabled()) {
            log.debug("[FIRST]" + AttachableMailBody.memCheck());
        }
        ByteArrayOutputStream byteBuffer = null;
        String returnStr = "";
        if (info1 == null) {
            log.debug("[info1 is null]");
            return null;
        }
        Iterator itr = ((SimpleHash)info1).getKeyIterator();
        while (itr.hasNext()) {
            log.debug("[info1_itr]" + (String)itr.next());
        }
        String attach_list = ((SimpleHash)info1).getAsString("ATTACH_LIST");
        log.debug("[attach_list] ==>" + attach_list);
        Object[] attachMsg = AttachableMailBody.makeAttachFiles((SimpleHash)info1, "UTF-8");
        if (attachMsg == null) {
            log.debug("[AttachableMailBody] attach_file is null");
            return super.getMailBody(info1, info2, SCHEDULE_INFO);
        }
        log.debug("================ [AttachableMailBody] act getMailBody ================");
        try {
            int i;
            byteBuffer = new ByteArrayOutputStream(512);
            this.setHeaderString(info1, info2, SCHEDULE_INFO, byteBuffer);
            if (log.isDebugEnabled()) {
                log.debug("[ATTACH] ==> exist attachMsg [TYPE] MIME_BODY");
            }
            String boundary = this.getBoundaryString();
            byteBuffer.write("Content-Type: multipart/mixed;\r\n".getBytes());
            byteBuffer.write("\tboundary=\"".getBytes());
            byteBuffer.write(boundary.getBytes());
            byteBuffer.write("\"\r\n\r\n".getBytes());
            byteBuffer.write("This is a multi-part message in MIME format.\r\n\r\n".getBytes());
            Message tmpMessage = null;
            for (i = 0; i < this.myMessages.size(); ++i) {
                tmpMessage = (Message)this.myMessages.get(i);
                byteBuffer.write("\n--".getBytes());
                byteBuffer.write(boundary.getBytes());
                byteBuffer.write(NEW_LINE);
                tmpMessage.putHeaderToStream(byteBuffer);
                byteBuffer.write(NEW_LINE);
                tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
                byteBuffer.write(NEW_LINE);
            }
            for (i = 0; i < attachMsg.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("[ATTACH COUNT] : " + i);
                }
                if ((tmpMessage = (Message)attachMsg[i]) == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Message is null ");
                    continue;
                }
                byteBuffer.write("\n--".getBytes());
                byteBuffer.write(boundary.getBytes());
                byteBuffer.write(NEW_LINE);
                tmpMessage.putHeaderToStream(byteBuffer);
                byteBuffer.write(NEW_LINE);
                tmpMessage.putStringMessageToStream(info1, info2, SCHEDULE_INFO, byteBuffer);
                byteBuffer.write(NEW_LINE);
            }
            attachMsg = null;
            byteBuffer.write("\r\n--".getBytes());
            byteBuffer.write(boundary.getBytes());
            byteBuffer.write("--\r\n\r\n".getBytes());
            returnStr = byteBuffer.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            byteBuffer.close();
            byteBuffer = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("[LAST]" + AttachableMailBody.memCheck());
        }
        return returnStr;
    }

    public static String memCheck() {
        double[] n1 = new double[1000000];
        double[] n2 = new double[1000000];
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long max = Runtime.getRuntime().maxMemory();
        String out_str = "[Total Memory]:" + Runtime.getRuntime().totalMemory() + "[Free Memory]:" + Runtime.getRuntime().freeMemory() + "[Used Memory]:" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        log.debug(out_str);
        return out_str;
    }

    public static Object[] makeAttachFiles(SimpleHash info1, String charSet) throws Exception {
        ArrayList attachPath;
        if (log.isDebugEnabled()) {
            log.debug("[GET ATTACH FILES]");
        }
        if ((attachPath = AttachableMailBody.getAttachFilePathFromMapping(info1)) == null) {
            log.debug("[attachPath.SIZE] ==> 0");
            return null;
        }
        Object[] attachMsg = new Object[attachPath.size()];
        BinaryAttachBodyParser binarybodyParser = null;
        SimpleMessage msg = null;
        AttachBean abean = null;
        log.debug("[GET ATTACH START] >>>>>>>> ");
        for (int i = 0; i < attachPath.size(); ++i) {
            abean = (AttachBean)attachPath.get(i);
            if (abean.getFile_path().equals("")) continue;
            try {
                binarybodyParser = new BinaryAttachBodyParser();
                binarybodyParser.setContentsAttach(abean.getFile_path());
            }
            catch (Exception e) {
                log.debug("[not found attach file] Path = [" + abean.getFile_path() + "]");
                attachMsg[i] = null;
                throw e;
            }
            msg = new SimpleMessage();
            msg.setContent(binarybodyParser);
            msg.setContentType(new Short(5));
            msg.setCharSet(charSet);
            msg.setContentEncoding(new Short(1));
            msg.setMessageID(Thread.currentThread().getName());
            msg.setContentName(abean.getFile_name());
            attachMsg[i] = msg;
            if (log.isDebugEnabled()) {
                log.debug("[ATTACH FILE]" + abean.getFile_path());
            }
            if (new File(abean.getFile_path()).exists()) {
                log.debug("[DELETE FILE]SUCCESS" + abean.getFile_path());
                continue;
            }
            log.debug("[DELETE FILE]FAIL" + abean.getFile_path());
        }
        log.debug(">>>>>>>>> [GET ATTACH END]");
        return attachMsg;
    }

    public static boolean isFile(String url) {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        if (StringUtil.isNull(fileName)) {
            return false;
        }
        int dot_index = fileName.lastIndexOf(".");
        return dot_index >= 0 && dot_index == fileName.length() - 4;
    }

    public static ArrayList getAttachFilePathFromMapping_SSLIFE(String attach_list) {
        ArrayList<AttachBean> attachList = null;
        String attach_path = "";
        String attach_file = "";
        String attach_title = "";
        String alias = "";
        boolean is_check = true;
        Properties prop_attach = StringUtil.getProp_sslife(attach_list, ATTACH_HEAD);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < ATTACH_CNT; ++i) {
            buffer.setLength(0);
            buffer.append(ATTACH_HEAD).append("_").append(i);
            alias = buffer.toString();
            attach_file = prop_attach.getProperty(alias);
            if (log.isDebugEnabled()) {
                log.debug("[alias]" + alias + "[attach_file]" + attach_file);
            }
            if (StringUtil.isNull(attach_file)) continue;
            if (is_check) {
                attachList = new ArrayList<AttachBean>();
                is_check = false;
            }
            attach_title = attach_file;
            if (log.isDebugEnabled()) {
                log.debug("[attach_title]" + attach_title);
            }
            AttachBean abean = new AttachBean(attach_title, attach_title);
            attachList.add(abean);
        }
        return attachList;
    }

    public static ArrayList getAttachFilePathFromMapping(SimpleHash userInfo) {
        ArrayList<AttachBean> attachList = null;
        String attach_path = "";
        String attach_title = "";
        String alias = "";
        boolean is_check = true;
        for (int i = 0; i < ATTACH_CNT; ++i) {
            alias = ATTACH_HEAD + (i + 1);
            attach_path = userInfo.getAsString(alias);
            if (StringUtil.isNull(attach_path)) continue;
            if (is_check) {
                attachList = new ArrayList<AttachBean>();
                is_check = false;
            }
            if (StringUtil.isNull(attach_title = userInfo.getAsString(alias + "_NAME"))) {
                attach_title = attach_path.substring(attach_path.lastIndexOf("/") + 1);
            }
            AttachBean abean = new AttachBean(attach_path, attach_title);
            attachList.add(abean);
        }
        return attachList;
    }
}

