/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.basic;

import java.util.Hashtable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InstanceFactory {
    private static final Logger log = LoggerFactory.getLogger(InstanceFactory.class);
    public static final String __UNDER_BAR__ = "_";
    private static final String name = "InstanceFactory";
    private static Hashtable InstanceMap = new Hashtable();

    public static String getName() {
        return name;
    }

    public static void init(Object tmp) throws Exception {
        Element TargetNode = (Element)tmp;
        Element SubNode = null;
        String SendTypeName = null;
        String SendStateName = null;
        String InstanceName = null;
        String InstanceClassName = null;
        NodeList TargetNodeList = TargetNode.getElementsByTagName("type");
        int TargetNodeCount = TargetNodeList.getLength();
        for (int i = 0; i < TargetNodeCount; ++i) {
            TargetNode = (Element)TargetNodeList.item(i);
            SendTypeName = TargetNode.getAttribute("value");
            SendStateName = TargetNode.getAttribute("state");
            NodeList TargetInstanceNodeList = TargetNode.getElementsByTagName("Instance");
            for (int j = 0; j < TargetInstanceNodeList.getLength(); ++j) {
                SubNode = (Element)TargetInstanceNodeList.item(j);
                InstanceName = SubNode.getAttribute("name");
                InstanceClassName = SubNode.getAttribute("class");
                Class<?> targetClass = Class.forName(InstanceClassName);
                InstanceMap.put(SendTypeName.concat(__UNDER_BAR__).concat(SendStateName).concat(__UNDER_BAR__).concat(InstanceName), targetClass);
            }
        }
    }

    public static Object getInstance(Properties info, short instance_type) throws Exception {
        Object returnValue = InstanceFactory.getInstance(info.getProperty("SEND_STATE"), info.getProperty("SEND_TYPE"), instance_type);
        if (log.isDebugEnabled()) {
            log.debug(info.toString(), (Object)returnValue.getClass().getName());
        }
        return returnValue;
    }

    public static Object getInstance(String type, String state, short instance_type) throws Exception {
        String TargetKey = null;
        switch (instance_type) {
            case 1: {
                TargetKey = type.concat(__UNDER_BAR__).concat(state).concat("_BodyParser");
                break;
            }
            case 2: {
                TargetKey = type.concat(__UNDER_BAR__).concat(state).concat("_Message");
                break;
            }
            case 3: {
                TargetKey = type.concat(__UNDER_BAR__).concat(state).concat("_MailBody");
                break;
            }
            case 5: {
                TargetKey = type.concat(__UNDER_BAR__).concat(state).concat("_ContentPD");
                break;
            }
            default: {
                throw new RuntimeException("Invalid Instance Type");
            }
        }
        Class classes = (Class)InstanceMap.get(TargetKey);
        if (classes == null) {
            throw new RuntimeException("Unregist Instance Type=>" + TargetKey);
        }
        return classes.newInstance();
    }

    static {
        try {
            InstanceMap.put("00_O_BodyParser", Class.forName("mercury.contents.common.parser.FreemarkerBodyParser"));
            InstanceMap.put("00_O_Message", Class.forName("mercury.contents.common.message.SimpleMessage"));
            InstanceMap.put("00_O_MailBody", Class.forName("mercury.contents.common.body.SimpleMailBody"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }
}

