/*
 * Decompiled with CFR 0.152.
 */
package mercury.contents.common.basic;

import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pluto.io.eMsFileWriter;
import pluto.lang.eMsLocale;
import pluto.util.xml.DOMParser;
import pluto.util.xml.XMLUtil;
import pluto.util.xml.XMLWriter;

public class ContentInfo
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(ContentInfo.class);
    private static String DTD_LOCATION = null;
    private static String XML_ENC_TYPE = null;
    private String contentInfoPath = "";
    private static XMLWriter XML_WRITER_INSTANCE = null;
    public static final long NO_END_DURATION = 600000L;
    private String ID = "";
    private MailBody mailBody;
    private String returnPath = "";
    private long startTime;
    private Map defaultMapping;
    private Properties scheduleInfo;
    private String mappingHeader = "";
    private long exec_time = System.currentTimeMillis();
    private String sendType = "";
    private String SPOOL_DELIMIT = null;

    public static synchronized void setDTDLocation(String location) throws Exception {
        DTD_LOCATION = location;
    }

    public static synchronized void setEncoding(String enc) throws Exception {
        XML_ENC_TYPE = enc;
    }

    public static synchronized void setFileEncoding(String enc) throws Exception {
    }

    protected synchronized Document getXmlDocument() throws Exception {
        Document returnValue = DOMParser.getEmptyDocument();
        Element CONTENT_ELEMENTS = returnValue.createElement("CONTENT");
        Element POSTID_ELEMENTS = returnValue.createElement("POSTID");
        POSTID_ELEMENTS.setAttribute("value", this.ID);
        CONTENT_ELEMENTS.appendChild(POSTID_ELEMENTS);
        log.debug("echo");
        Element INFO_ELEMENTS = returnValue.createElement("INFO");
        Element MAILFROM_ELEMENTS = returnValue.createElement("MAILFROM");
        MAILFROM_ELEMENTS.setAttribute("value", this.returnPath);
        INFO_ELEMENTS.appendChild(MAILFROM_ELEMENTS);
        for (String string : this.scheduleInfo.keySet()) {
            String value = (String)this.scheduleInfo.get(string);
            Element VAR_ELEMENTS = returnValue.createElement("var");
            VAR_ELEMENTS.setAttribute("name", string);
            VAR_ELEMENTS.setAttribute("value", value);
            INFO_ELEMENTS.appendChild(VAR_ELEMENTS);
        }
        CONTENT_ELEMENTS.appendChild(INFO_ELEMENTS);
        MailBody mailbody = this.getMailBody();
        Element element = returnValue.createElement("BODY");
        Element BODYCLASS_ELEMENTS = returnValue.createElement("BODYCLASS");
        BODYCLASS_ELEMENTS.setAttribute("value", this.getMailBody().getClass().getName());
        element.appendChild(BODYCLASS_ELEMENTS);
        Element FROMEMAIL_ELEMENTS = returnValue.createElement("FROMEMAIL");
        FROMEMAIL_ELEMENTS.setAttribute("value", mailbody.getFromEmail());
        element.appendChild(FROMEMAIL_ELEMENTS);
        Element FROMNAME_ELEMENTS = returnValue.createElement("FROMNAME");
        FROMNAME_ELEMENTS.setAttribute("value", mailbody.getFromName());
        element.appendChild(FROMNAME_ELEMENTS);
        Element SUBJECT_ELEMENTS = returnValue.createElement("SUBJECT");
        SUBJECT_ELEMENTS.setAttribute("value", mailbody.getSubject());
        element.appendChild(SUBJECT_ELEMENTS);
        Element TONAME_ELEMENTS = returnValue.createElement("TONAME");
        TONAME_ELEMENTS.setAttribute("value", mailbody.getToName());
        element.appendChild(TONAME_ELEMENTS);
        Element TOEMAIL_ELEMENTS = returnValue.createElement("TOEMAIL");
        TOEMAIL_ELEMENTS.setAttribute("value", mailbody.getToEmail());
        element.appendChild(TOEMAIL_ELEMENTS);
        Vector Messages = mailbody.getMessage();
        for (int i = 0; i < Messages.size(); ++i) {
            Element MESSAGE_ELEMENTS = returnValue.createElement("MESSAGE");
            Message tmpMessage = (Message)Messages.get(i);
            Element MESSAGECLASS_ELEMENTS = returnValue.createElement("MESSAGECLASS");
            MESSAGECLASS_ELEMENTS.setAttribute("value", tmpMessage.getClass().getName());
            MESSAGE_ELEMENTS.appendChild(MESSAGECLASS_ELEMENTS);
            Element MESSAGECHARSET_ELEMENTS = returnValue.createElement("MESSAGECHARSET");
            MESSAGECHARSET_ELEMENTS.setAttribute("value", tmpMessage.getCharSet());
            MESSAGE_ELEMENTS.appendChild(MESSAGECHARSET_ELEMENTS);
            Element CONTENTENCODING_ELEMENTS = returnValue.createElement("CONTENTENCODING");
            CONTENTENCODING_ELEMENTS.setAttribute("value", tmpMessage.getContentEncoding().toString());
            MESSAGE_ELEMENTS.appendChild(CONTENTENCODING_ELEMENTS);
            Element CONTENTTYPE_ELEMENTS = returnValue.createElement("CONTENTTYPE");
            CONTENTTYPE_ELEMENTS.setAttribute("value", tmpMessage.getContentType().toString());
            MESSAGE_ELEMENTS.appendChild(CONTENTTYPE_ELEMENTS);
            Element MESSAGEID_ELEMENTS = returnValue.createElement("MESSAGEID");
            MESSAGEID_ELEMENTS.setAttribute("value", tmpMessage.getMessageID());
            MESSAGE_ELEMENTS.appendChild(MESSAGEID_ELEMENTS);
            BodyParser tmpBodyParser = tmpMessage.getContent();
            Element BODYPARSERCLASS_ELEMENTS = returnValue.createElement("BODYPARSERCLASS");
            BODYPARSERCLASS_ELEMENTS.setAttribute("value", tmpBodyParser.getClass().getName());
            MESSAGE_ELEMENTS.appendChild(BODYPARSERCLASS_ELEMENTS);
            Element ORIGINAL_ELEMENTS = returnValue.createElement("ORIGINAL");
            CDATASection ORIGINAL_SECTION = returnValue.createCDATASection("ORIGINAL");
            ORIGINAL_SECTION.setData(tmpBodyParser.getOriginal());
            ORIGINAL_ELEMENTS.appendChild(ORIGINAL_SECTION);
            MESSAGE_ELEMENTS.appendChild(ORIGINAL_ELEMENTS);
            Element MESSAGENAME_ELEMENTS = returnValue.createElement("MESSAGENAME");
            MESSAGENAME_ELEMENTS.setAttribute("value", tmpMessage.getContentName());
            MESSAGE_ELEMENTS.appendChild(MESSAGENAME_ELEMENTS);
            Element MESSAGECONTENTS_ELEMENTS = returnValue.createElement("MESSAGECONTENTS");
            CDATASection CONTENT_SECTION = returnValue.createCDATASection("CONTENT");
            if (log.isDebugEnabled()) {
                String content = tmpBodyParser.getContents();
                log.debug("XML GET CONTENT", (Object)content);
                CONTENT_SECTION.setData(content);
            } else {
                CONTENT_SECTION.setData(tmpBodyParser.getContents());
            }
            MESSAGECONTENTS_ELEMENTS.appendChild(CONTENT_SECTION);
            MESSAGE_ELEMENTS.appendChild(MESSAGECONTENTS_ELEMENTS);
            element.appendChild(MESSAGE_ELEMENTS);
        }
        CONTENT_ELEMENTS.appendChild(element);
        returnValue.appendChild(CONTENT_ELEMENTS);
        return returnValue;
    }

    public static synchronized void toXmlFile(String out_file, ContentInfo info) throws Exception {
        eMsFileWriter out = new eMsFileWriter(out_file);
        try {
            XML_WRITER_INSTANCE.setEncoding(XML_ENC_TYPE);
            XML_WRITER_INSTANCE.outResult(out, info.getXmlDocument(), DTD_LOCATION);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized ContentInfo XmlToContentInfo(String url) throws Exception {
        log.debug("Debug-url:" + url);
        Document DOCUMENT = DOMParser.getDocumentFromUrl(url);
        ContentInfo returnValue = new ContentInfo();
        Element CONTENT_ELEMENTS = (Element)DOCUMENT.getElementsByTagName("CONTENT").item(0);
        Element POSTID_ELEMENTS = (Element)CONTENT_ELEMENTS.getElementsByTagName("POSTID").item(0);
        returnValue.setID(POSTID_ELEMENTS.getAttribute("value"));
        Element INFO_ELEMENTS = (Element)CONTENT_ELEMENTS.getElementsByTagName("INFO").item(0);
        Element MAILFROM_ELEMENTS = (Element)INFO_ELEMENTS.getElementsByTagName("MAILFROM").item(0);
        returnValue.setReturnPath(MAILFROM_ELEMENTS.getAttribute("value"));
        NodeList PROPERTY_NODES = INFO_ELEMENTS.getElementsByTagName("var");
        Properties __SCHEDULE_INFO__ = new Properties();
        for (int i = 0; i < PROPERTY_NODES.getLength(); ++i) {
            Element VAR_ELEMENTS = (Element)PROPERTY_NODES.item(i);
            __SCHEDULE_INFO__.setProperty(VAR_ELEMENTS.getAttribute("name"), VAR_ELEMENTS.getAttribute("value"));
        }
        returnValue.setScheduleInfo(__SCHEDULE_INFO__);
        Element BODY_ELEMENTS = (Element)CONTENT_ELEMENTS.getElementsByTagName("BODY").item(0);
        Element BODYCLASS_ELEMENTS = (Element)BODY_ELEMENTS.getElementsByTagName("BODYCLASS").item(0);
        MailBody targetMailBody = (MailBody)Class.forName(BODYCLASS_ELEMENTS.getAttribute("value")).newInstance();
        targetMailBody.setEtcHeader(eMsLocale.DEFAULT_HEADER);
        Element FROMEMAIL_ELEMENTS = (Element)BODY_ELEMENTS.getElementsByTagName("FROMEMAIL").item(0);
        targetMailBody.setFromEmail(FROMEMAIL_ELEMENTS.getAttribute("value"));
        Element FROMNAME_ELEMENTS = (Element)BODY_ELEMENTS.getElementsByTagName("FROMNAME").item(0);
        targetMailBody.setFromName(FROMNAME_ELEMENTS.getAttribute("value"));
        Element SUBJECT_ELEMENTS = (Element)BODY_ELEMENTS.getElementsByTagName("SUBJECT").item(0);
        targetMailBody.setSubject(SUBJECT_ELEMENTS.getAttribute("value"));
        Element TONAME_ELEMENTS = (Element)BODY_ELEMENTS.getElementsByTagName("TONAME").item(0);
        targetMailBody.setToName(TONAME_ELEMENTS.getAttribute("value"));
        Element TOEMAIL_ELEMENTS = (Element)BODY_ELEMENTS.getElementsByTagName("TOEMAIL").item(0);
        targetMailBody.setToEmail(TOEMAIL_ELEMENTS.getAttribute("value"));
        NodeList MESSAGE_NODES = BODY_ELEMENTS.getElementsByTagName("MESSAGE");
        for (int i = 0; i < MESSAGE_NODES.getLength(); ++i) {
            Element MESSAGE_ELEMENTS = (Element)MESSAGE_NODES.item(i);
            Element MESSAGECLASS_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("MESSAGECLASS").item(0);
            Message tmpMessage = (Message)Class.forName(MESSAGECLASS_ELEMENTS.getAttribute("value")).newInstance();
            Element MESSAGECHARSET_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("MESSAGECHARSET").item(0);
            tmpMessage.setCharSet(MESSAGECHARSET_ELEMENTS.getAttribute("value"));
            Element CONTENTENCODING_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("CONTENTENCODING").item(0);
            tmpMessage.setContentEncoding(Short.valueOf(CONTENTENCODING_ELEMENTS.getAttribute("value")));
            Element CONTENTTYPE_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("CONTENTTYPE").item(0);
            tmpMessage.setContentType(Short.valueOf(CONTENTTYPE_ELEMENTS.getAttribute("value")));
            Element MESSAGEID_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("MESSAGEID").item(0);
            tmpMessage.setMessageID(MESSAGEID_ELEMENTS.getAttribute("value"));
            Element BODYPARSERCLASS_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("BODYPARSERCLASS").item(0);
            BodyParser tmpBodyParser = (BodyParser)Class.forName(BODYPARSERCLASS_ELEMENTS.getAttribute("value")).newInstance();
            Element ORIGINAL_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("ORIGINAL").item(0);
            Element MESSAGENAME_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("MESSAGENAME").item(0);
            Element MESSAGECONTENTS_ELEMENTS = (Element)MESSAGE_ELEMENTS.getElementsByTagName("MESSAGECONTENTS").item(0);
            String sOriginal = XMLUtil.getCDATA_SECTION(ORIGINAL_ELEMENTS).trim();
            String sContents = XMLUtil.getCDATA_SECTION(MESSAGECONTENTS_ELEMENTS);
            String sName = MESSAGENAME_ELEMENTS.getAttribute("value");
            tmpBodyParser.setContents(sOriginal, sContents, sName);
            tmpMessage.setContentName(MESSAGENAME_ELEMENTS.getAttribute("value"));
            tmpMessage.setContent(tmpBodyParser);
            targetMailBody.setMessage(tmpMessage);
        }
        returnValue.setMailBody(targetMailBody);
        return returnValue;
    }

    public boolean expire() {
        return System.currentTimeMillis() - this.exec_time > 600000L;
    }

    public void execute() {
        this.exec_time = System.currentTimeMillis();
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public MailBody getMailBody() {
        return this.mailBody;
    }

    public void setMailBody(MailBody mailBody) {
        this.mailBody = mailBody;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Map getDefaultMapping() {
        return this.defaultMapping;
    }

    public void setDefaultMapping(Map defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public Properties getScheduleInfo() {
        return this.scheduleInfo;
    }

    public void setScheduleInfo(Properties scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    public String getMappingHeader() {
        return this.mappingHeader;
    }

    public void setMappingHeader(String mappingHeader) {
        this.mappingHeader = mappingHeader;
    }

    public String getSendType() {
        return this.sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }

    public String getResultMailBody(Object info1, Object info2, Properties prop) throws Exception {
        return this.mailBody.getMailBody(info1, info2, prop);
    }

    public String getResultMailBody(Object info1, Object info2) throws Exception {
        return this.getResultMailBody(info1, info2, this.scheduleInfo);
    }

    public String getPreViewMailBody(Object info1, Object info2) throws Exception {
        return this.mailBody.getPreViewMailBody(info1, info2, this.scheduleInfo);
    }

    public String getSpoolPrev(Object info1, Object info2) throws Exception {
        return this.mailBody.getSpoolPrev(info1, info2, this.scheduleInfo);
    }

    public String getSPOOL_DELIMIT() {
        if (this.SPOOL_DELIMIT == null) {
            this.SPOOL_DELIMIT = this.scheduleInfo.getProperty("DELIMIT", "|");
        }
        return this.SPOOL_DELIMIT;
    }

    public ContentInfo getClone() throws Exception {
        return (ContentInfo)this.clone();
    }

    public void setContentInfoPath(String cInfoPath) {
        this.contentInfoPath = cInfoPath;
    }

    public String getContentInfoPath() {
        return this.contentInfoPath;
    }

    static {
        try {
            XML_WRITER_INSTANCE = new XMLWriter();
        }
        catch (Throwable th) {
            log.error(th.getMessage());
            System.exit(1);
        }
    }
}

