/*
 * Decompiled with CFR 0.152.
 */
package mars.tracking.parser;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.LogParser;
import pluto.log.LogProcessor;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;

public class IISLogParser
extends Properties
implements LogParser {
    private static final Logger log = LoggerFactory.getLogger(IISLogParser.class);
    private static final String DATA_DIV = " ";
    private static final String INDEX_DUR_TIME = "&DT=";
    private static final String INDEX_GO_URL = "&URL=";
    private static final String INDEX_END_URL = " ";
    public static String RECEIVER_HTML = "tr.html?";
    public static String LOWER_RECEIVER_HTML = "tr.html?";
    protected List FIRST_INNER_WORK_LIST = new PlutoLinkedList();
    protected List SECOND_INNER_WORK_LIST = new PlutoLinkedList();
    protected StringBuffer __TMP_BUFFER = new StringBuffer(128);
    private static boolean OUT_DEBUG = false;
    private static Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static final int ADD_LOCALE_TIME = 9;
    private static final int INDEX_YEAR = 0;
    private static final int INDEX_MONTH = 5;
    private static final int INDEX_DAY = 8;
    private static final int INDEX_HOUR = 11;
    private static final int INDEX_MINUTE = 14;
    private static final int INDEX_SECOND = 17;

    @Override
    public void setParsingRules(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        RECEIVER_HTML = prop.getProperty("script.index", RECEIVER_HTML);
        RECEIVER_HTML = RECEIVER_HTML.substring(0, RECEIVER_HTML.length() - 1);
        LOWER_RECEIVER_HTML = RECEIVER_HTML.toLowerCase();
        OUT_DEBUG = prop.getProperty("check.debug", "false").equals("true");
    }

    @Override
    public Object parse(String src) throws Exception {
        this.clear();
        String toDate = "";
        String shotDate = "";
        int idx1 = src.indexOf(" ");
        String s_date = src.substring(0, idx1).replaceAll("-", "");
        if (OUT_DEBUG) {
            log.debug("s_date : " + s_date + "  idx1:" + idx1);
        }
        if (s_date.length() != 8) {
            if (OUT_DEBUG) {
                log.debug("no TIME_YYYYMMDD");
            }
            return null;
        }
        int idx2 = src.indexOf(" ", idx1 + 1);
        String tdate = src.substring(0, idx2);
        if (tdate.length() != 19) {
            if (OUT_DEBUG) {
                log.debug("no T_DATE");
            }
            return null;
        }
        cal.set(Integer.parseInt(tdate.substring(0, 4)), Integer.parseInt(tdate.substring(5, 7)) - 1, Integer.parseInt(tdate.substring(8, 10)), Integer.parseInt(tdate.substring(11, 13)), Integer.parseInt(tdate.substring(14, 16)), Integer.parseInt(tdate.substring(17, 19)));
        cal.add(11, 9);
        toDate = this.getToDate(cal);
        shotDate = this.getShotDate(cal);
        if (OUT_DEBUG) {
            log.debug("tdate : " + toDate + " sdate:" + shotDate);
        }
        this.setProperty("TIME_YYYYMMDD", shotDate);
        this.setProperty("T_DATE", toDate);
        idx1 = src.indexOf(RECEIVER_HTML);
        if (idx1 < 0) {
            idx1 = src.toLowerCase().indexOf(LOWER_RECEIVER_HTML);
            if (OUT_DEBUG) {
                log.debug("no script index");
            }
            if (idx1 < 0) {
                return null;
            }
        }
        idx2 = src.indexOf(INDEX_GO_URL, idx1);
        int idx3 = src.indexOf(" ", idx1 + RECEIVER_HTML.length() + 1);
        if (idx2 < 0) {
            src = src.substring(idx1 + RECEIVER_HTML.length() + 1, idx3);
            if (log.isDebugEnabled()) {
                log.debug("REAL_TRACKING_DATA1: " + src);
            }
        } else {
            src = src.substring(idx1 + RECEIVER_HTML.length() + 1, idx2);
            if (log.isDebugEnabled()) {
                log.debug("REAL_TRACKING_DATA2: " + src);
            }
        }
        if ((idx1 = src.indexOf(INDEX_DUR_TIME)) > 0) {
            String DUR = src.substring(idx1 + INDEX_DUR_TIME.length());
            this.setProperty("DT", DUR.length() > 3 ? DUR.substring(0, DUR.length() - 3) : "1");
            src = src.substring(0, idx1);
            if (log.isDebugEnabled()) {
                log.debug(src);
            }
        }
        this.FIRST_INNER_WORK_LIST.clear();
        this.FIRST_INNER_WORK_LIST = StringUtil.toStringList(src, "&", this.FIRST_INNER_WORK_LIST);
        Iterator iter = this.FIRST_INNER_WORK_LIST.iterator();
        while (iter.hasNext()) {
            if (this.parse_tr_part(iter.next().toString())) continue;
            return null;
        }
        return this;
    }

    private boolean parse_tr_part(String s) {
        String src = s.trim();
        if (src.length() < 4) {
            return true;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("before decript : " + src);
            }
            src = TrackingInfoConvertor.decode(src).trim();
            if (log.isDebugEnabled()) {
                log.debug("after decript : " + src);
            }
            this.SECOND_INNER_WORK_LIST.clear();
            this.SECOND_INNER_WORK_LIST = StringUtil.toStringList(src, "&", this.SECOND_INNER_WORK_LIST);
            Iterator iter = this.SECOND_INNER_WORK_LIST.iterator();
            while (iter.hasNext()) {
                this.setValue(iter.next().toString());
            }
        }
        catch (Exception e) {
            if (OUT_DEBUG) {
                log.debug("tr parsing error", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void setValue(String src) {
        int idx = src.indexOf("=");
        if (idx < 0) {
            return;
        }
        this.setProperty(src.substring(0, idx).trim(), src.substring(idx + 1).trim());
    }

    @Override
    public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
    }

    public String getToDate(Calendar cal) {
        return cal.get(1) + "-" + this.lengthConvert(cal.get(2) + 1) + "-" + this.lengthConvert(cal.get(5)) + " " + this.lengthConvert(cal.get(11)) + ":" + this.lengthConvert(cal.get(12)) + ":" + this.lengthConvert(cal.get(13));
    }

    public String getShotDate(Calendar cal) {
        return "" + cal.get(1) + this.lengthConvert(cal.get(2) + 1) + this.lengthConvert(cal.get(5));
    }

    public String lengthConvert(int target) {
        if (target < 10) {
            return "0" + target;
        }
        return "" + target;
    }
}

