/*
 * Decompiled with CFR 0.152.
 */
package mars.tracking.parser;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.log.LogParser;
import pluto.log.LogProcessor;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;
import pluto.util.convert.TrackingInfoConvertor;

public class ApacheA2LogParser
extends Properties
implements LogParser {
    private static final Logger log = LoggerFactory.getLogger(ApacheA2LogParser.class);
    private static final String DATE_START = "[";
    private static final String DATE_END = "]";
    private static final String DATE_MIDDLE = " ";
    private static final String INDEX_DUR_TIME = "&DT=";
    private static final String INDEX_GO_URL = "&URL=";
    private static final String INDEX_END_URL = " ";
    public static String RECEIVER_HTML = "tr.html?";
    public static String LOWER_RECEIVER_HTML = "tr.html?";
    private static Hashtable __MONTH_MAP__ = new Hashtable();
    protected List FIRST_INNER_WORK_LIST = new PlutoLinkedList();
    protected List SECOND_INNER_WORK_LIST = new PlutoLinkedList();
    protected StringBuffer __TMP_BUFFER = new StringBuffer(128);
    private static boolean OUT_DEBUG;

    @Override
    public void setParsingRules(Object tmp) throws Exception {
        Properties prop = (Properties)tmp;
        RECEIVER_HTML = prop.getProperty("script.index", RECEIVER_HTML);
        LOWER_RECEIVER_HTML = RECEIVER_HTML.toLowerCase();
        OUT_DEBUG = prop.getProperty("check.debug", "false").equals("true");
    }

    @Override
    public Object parse(String src) throws Exception {
        this.clear();
        int idx1 = src.indexOf(DATE_START);
        if (idx1 < 0) {
            if (OUT_DEBUG) {
                log.debug("no date start");
            }
            return null;
        }
        int idx2 = src.indexOf(DATE_END);
        if (idx2 < 0) {
            if (OUT_DEBUG) {
                log.debug("no date end");
            }
            return null;
        }
        int idx3 = src.indexOf(" ", idx1);
        if (idx3 < 0) {
            if (OUT_DEBUG) {
                log.debug("no date middle");
            }
            return null;
        }
        if (idx3 > idx2) {
            if (OUT_DEBUG) {
                log.debug("date start and end sequence");
            }
            return null;
        }
        this.parse_date(src.substring(idx1 + DATE_START.length(), idx3));
        idx1 = src.indexOf(RECEIVER_HTML);
        if (idx1 < 0) {
            idx1 = src.toLowerCase().indexOf(LOWER_RECEIVER_HTML);
            if (OUT_DEBUG) {
                log.debug("no script index");
            }
            if (idx1 < 0) {
                return null;
            }
        }
        idx2 = src.indexOf(INDEX_GO_URL, idx1);
        idx3 = src.indexOf(" ", idx1);
        if (idx2 < 0) {
            src = src.substring(idx1 + RECEIVER_HTML.length(), idx3);
            if (log.isDebugEnabled()) {
                log.debug(src);
            }
        } else {
            this.setValue(src.substring(idx2 + 1, idx3));
            src = src.substring(idx1 + RECEIVER_HTML.length(), idx2);
            if (log.isDebugEnabled()) {
                log.debug(src);
            }
        }
        this.FIRST_INNER_WORK_LIST.clear();
        this.FIRST_INNER_WORK_LIST = StringUtil.toStringList(src, "&", this.FIRST_INNER_WORK_LIST);
        Iterator iter = this.FIRST_INNER_WORK_LIST.iterator();
        while (iter.hasNext()) {
            if (this.parse_tr_part(iter.next().toString())) continue;
            return null;
        }
        return this;
    }

    private boolean parse_tr_part(String s) {
        String src = s.trim();
        if (src.length() < 4) {
            return true;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("before decript : " + src);
            }
            src = TrackingInfoConvertor.decode(src).trim();
            if (log.isDebugEnabled()) {
                log.debug("after decript : " + src);
            }
            this.SECOND_INNER_WORK_LIST.clear();
            this.SECOND_INNER_WORK_LIST = StringUtil.toStringList(src, "&", this.SECOND_INNER_WORK_LIST);
            Iterator iter = this.SECOND_INNER_WORK_LIST.iterator();
            while (iter.hasNext()) {
                this.setValue(iter.next().toString());
            }
        }
        catch (Exception e) {
            if (OUT_DEBUG) {
                log.debug("tr parsing error", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private boolean parse_date(String src) {
        try {
            String year = null;
            String month = null;
            String day = null;
            String hour = null;
            String time = null;
            int idx1 = src.indexOf("/");
            day = src.substring(0, idx1);
            int idx2 = src.indexOf("/", idx1 + 1);
            month = (String)__MONTH_MAP__.get(src.substring(idx1 + 1, idx2).toLowerCase());
            idx1 = idx2 + 1;
            idx2 = src.indexOf(":", idx1);
            year = src.substring(idx1, idx2);
            time = src.substring(idx2 + 1);
            hour = src.substring(idx2 + 1, idx2 + 3);
            this.__TMP_BUFFER.setLength(0);
            this.setProperty("TIME_YYYYMMDD", this.__TMP_BUFFER.append(year).append(month).append(day).toString());
            this.__TMP_BUFFER.setLength(0);
            this.setProperty("T_DATE", this.__TMP_BUFFER.append(year).append("-").append(month).append("-").append(day).append(" ").append(time).toString());
            this.setProperty("T_YEAR", year);
            this.setProperty("T_MONTH", month);
            this.setProperty("T_DAY", day);
            this.setProperty("T_HOUR", hour);
        }
        catch (Exception e) {
            if (OUT_DEBUG) {
                log.debug("date parsing error", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private void setValue(String src) {
        int idx = src.indexOf("=");
        if (idx < 0) {
            return;
        }
        this.setProperty(src.substring(0, idx).trim(), src.substring(idx + 1).trim());
    }

    @Override
    public void setExternalLogProcessor(LogProcessor tmp) throws Exception {
    }

    public static void main(String[] args) throws Exception {
        ApacheA2LogParser a = new ApacheA2LogParser();
        a.parse("TV9JRD10ZXN0MQ==&U1RZUEU9TUFTUw==&TElTVF9UQUJMRT1FTVNfTUFTU19TRU5EX0xJU1RfMDg=&UE9TVF9JRD0yMDA4MDgxOTAwMDAx&VEM9MjAwODA4MjQ=&S0lORD1P");
    }

    static {
        __MONTH_MAP__.put("jan", "01");
        __MONTH_MAP__.put("feb", "02");
        __MONTH_MAP__.put("mar", "03");
        __MONTH_MAP__.put("apr", "04");
        __MONTH_MAP__.put("may", "05");
        __MONTH_MAP__.put("jun", "06");
        __MONTH_MAP__.put("jul", "07");
        __MONTH_MAP__.put("aug", "08");
        __MONTH_MAP__.put("sep", "09");
        __MONTH_MAP__.put("oct", "10");
        __MONTH_MAP__.put("nov", "11");
        __MONTH_MAP__.put("dec", "12");
        OUT_DEBUG = false;
    }
}

