/*
 * Decompiled with CFR 0.152.
 */
package jupiter.mass.send.task;

import java.util.Properties;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.AbstractDBMailSendTask;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.basic.InstanceFactory;
import mercury.contents.common.producer.ContentPD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pluto.config.SqlManager;
import pluto.util.Cal;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.parallel.task.SpoolControlTask;

public class SingleTestSendTask
extends AbstractDBMailSendTask {
    private static final Logger log = LoggerFactory.getLogger(SingleTestSendTask.class);
    public static String QUERY_TEST_LIST_SAMPLING_QUERY = null;

    public SingleTestSendTask() throws Exception {
        if (log.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public void setTaskProperty(Properties prop) {
        this.TASK_PROPERTY = prop;
        this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
        this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
        this.LIST_TABLE = this.TASK_PROPERTY.getProperty("LIST_TABLE");
        this.WORK_FILE_ID = this.POST_ID.concat("_real_test_").concat(Cal.getSerialDate());
        this.setTaskID(this.POST_ID.concat("_TEST"));
        this.setName(this.POST_ID + "_SingleTestSendTask");
    }

    @Override
    protected void execute_ContentLoad() throws Exception {
        this.TASK_PROPERTY.setProperty("TASK_ID", this.TASK_PROPERTY.getProperty("POST_ID") + "_CONTENTS");
        String send_state = this.TASK_PROPERTY.getProperty("SEND_STATE");
        String send_type = this.TASK_PROPERTY.getProperty("SEND_TYPE");
        ContentPD targetContentPD = (ContentPD)InstanceFactory.getInstance(send_type, send_state, (short)5);
        targetContentPD.process(this.TASK_PROPERTY);
        ContentInfo sendContentInfo = targetContentPD.getContentInfo();
        ContentInfoManager.registContentInfo(sendContentInfo);
        ContentInfoManager.putContentInfo(sendContentInfo, false);
        if (log.isDebugEnabled()) {
            log.debug("call execute_ContentLoad");
        }
    }

    @Override
    protected void execute_ListMake() throws Exception {
    }

    @Override
    protected void execute_ListLoad() throws Exception {
        this.TASK_PROPERTY.setProperty("TASK_NAME", this.TASK_PROPERTY + "_SPOOLING");
        SpoolControlTask task = (SpoolControlTask)venus.spool.common.basic.InstanceFactory.getInstance(this.TASK_PROPERTY, (short)7);
        task.setTaskProperty(this.TASK_PROPERTY);
        task.setParallelInfo(false, "\uc11c\ubc84 \uc124\uc815\uac12");
        try {
            task.internal_execute();
        }
        catch (Throwable error) {
            log.error(this.getName(), error);
            error.printStackTrace();
        }
        this.mailSpoolInfo = task.getSpoolInfo();
        SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, false);
    }

    @Override
    protected void execute_Finish() throws Exception {
    }

    @Override
    protected void execute_Startup() throws Exception {
    }

    @Override
    protected boolean execute_StopCheck() {
        return false;
    }

    @Override
    protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
        return BufferedAgentPool.getBufferedObjectPool("single", domain);
    }

    @Override
    protected void processSyntaxErrorSpool(String spool) throws Exception {
        log.error("TEST SPOOL SYNTAX ERROR", (Object)spool);
    }

    @Override
    protected void passDomainNotFound(String spool, Throwable e) throws Exception {
        log.error("TEST SPOOL DOMAIN INVALID", (Object)spool.concat("=>").concat(e.toString()));
    }

    @Override
    protected void passRejectDomain(String spool) throws Exception {
        log.error("TEST SPOOL DOMAIN REJECTED", (Object)spool);
    }

    static {
        try {
            QUERY_TEST_LIST_SAMPLING_QUERY = SqlManager.getQuery("WINDFORCE_COMMON", "QUERY_TEST_LIST_SAMPLING_QUERY");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }
}

